/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.Validator;
import com.xiaoleilu.hutool.util.StrUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class NetUtil {
    public static final String LOCAL_IP = "127.0.0.1";

    public static String longToIpv4(long longIP) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(longIP >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIP & 0xFFL));
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        if (Validator.isIpv4(strIP)) {
            long[] ip = new long[4];
            int position1 = strIP.indexOf(".");
            int position2 = strIP.indexOf(".", position1 + 1);
            int position3 = strIP.indexOf(".", position2 + 1);
            ip[0] = Long.parseLong(strIP.substring(0, position1));
            ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIP.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        return 0L;
    }

    public static boolean isUsableLocalPort(int port) {
        if (!NetUtil.isValidPort(port)) {
            return false;
        }
        try {
            new Socket(LOCAL_IP, port).close();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static boolean isInnerIP(String ipAddress) {
        boolean isInnerIp = false;
        long ipNum = NetUtil.ipv4ToLong(ipAddress);
        long aBegin = NetUtil.ipv4ToLong("10.0.0.0");
        long aEnd = NetUtil.ipv4ToLong("10.255.255.255");
        long bBegin = NetUtil.ipv4ToLong("172.16.0.0");
        long bEnd = NetUtil.ipv4ToLong("172.31.255.255");
        long cBegin = NetUtil.ipv4ToLong("192.168.0.0");
        long cEnd = NetUtil.ipv4ToLong("192.168.255.255");
        isInnerIp = NetUtil.isInner(ipNum, aBegin, aEnd) || NetUtil.isInner(ipNum, bBegin, bEnd) || NetUtil.isInner(ipNum, cBegin, cEnd) || ipAddress.equals(LOCAL_IP);
        return isInnerIp;
    }

    public static Set<String> localIpv4s() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new UtilException(e.getMessage(), e);
        }
        if (networkInterfaces == null) {
            throw new UtilException("Get network interface error!");
        }
        HashSet<String> ipSet = new HashSet<String>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || !(inetAddress instanceof Inet4Address)) continue;
                ipSet.add(inetAddress.getHostAddress());
            }
        }
        return ipSet;
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("To absolute url [{}] base [{}] error!", relativePath, absoluteBasePath), e);
        }
    }

    public static String hideIpPart(String ip) {
        return new StringBuffer(ip.length()).append(ip.substring(0, ip.lastIndexOf(".") + 1)).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetUtil.hideIpPart(NetUtil.longToIpv4(ip));
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        if (StrUtil.isBlank(host)) {
            host = LOCAL_IP;
        }
        String destHost = null;
        int port = 0;
        int index = host.indexOf(":");
        if (index != -1) {
            destHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            destHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(destHost, port);
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }
}

