/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class ObjectUtil {
    public static boolean equals(Object obj1, Object obj2) {
        return obj1 != null ? obj1.equals(obj2) : obj2 == null;
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().contains(element);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ObjectUtil.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ObjectUtil.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!ObjectUtil.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static <T extends Cloneable> T clone(T obj) {
        return (T)((Cloneable)ClassUtil.invoke(obj, "clone", new Object[0]));
    }

    public static <T> T clone(T obj) {
        Object object;
        FastByteArrayOutputStream byteOut = new FastByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(obj);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            object = in.readObject();
        }
        catch (Exception e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(out);
                throw throwable;
            }
        }
        IoUtil.close(out);
        return (T)object;
    }

    public static <T> byte[] serialize(T t) {
        FastByteArrayOutputStream byteOut = new FastByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(byteOut);
            oos.writeObject(t);
            oos.flush();
        }
        catch (Exception e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(oos);
                throw throwable;
            }
        }
        IoUtil.close(oos);
        return byteOut.toByteArray();
    }

    public static <T> T unserialize(byte[] bytes) {
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static boolean isBasicType(Object object) {
        return ClassUtil.isBasicType(object.getClass());
    }

    public static boolean isValidIfNumber(Object obj) {
        return obj == null || !(obj instanceof Number) || !(obj instanceof Double ? ((Double)obj).isInfinite() || ((Double)obj).isNaN() : obj instanceof Float && (((Float)obj).isInfinite() || ((Float)obj).isNaN()));
    }
}

