/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class StrUtil {
    public static final String SPACE = " ";
    public static final String DOT = ".";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String CRLF = "\r\n";
    public static final String NEWLINE = "\n";
    public static final String UNDERLINE = "_";
    public static final String COMMA = ",";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";

    public static boolean isBlank(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return false == StrUtil.isBlank(str);
    }

    public static boolean hasBlank(String ... strs) {
        if (CollectionUtil.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StrUtil.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(String ... strs) {
        if (CollectionUtil.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StrUtil.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return false == StrUtil.isEmpty(str);
    }

    public static String nullToEmpty(String str) {
        return StrUtil.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String emptyToNull(String str) {
        return StrUtil.isEmpty(str) ? null : str;
    }

    public static boolean hasEmpty(String ... strs) {
        if (CollectionUtil.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StrUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(String ... strs) {
        if (CollectionUtil.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StrUtil.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        return null == str ? null : StrUtil.trim(str, 0);
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = str.trim();
        }
    }

    public static String trimStart(String str) {
        return StrUtil.trim(str, -1);
    }

    public static String trimEnd(String str) {
        return StrUtil.trim(str, 1);
    }

    public static String trim(String str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.substring(start, end);
        }
        return str;
    }

    public static boolean startWith(String str, String prefix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toLowerCase().startsWith(prefix.toLowerCase());
        }
        return str.startsWith(prefix);
    }

    public static boolean endWith(String str, String suffix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toLowerCase().endsWith(suffix.toLowerCase());
        }
        return str.endsWith(suffix);
    }

    public static boolean containsIgnoreCase(String str, String testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toLowerCase().contains(testStr.toLowerCase());
    }

    public static String getGeneralField(String getOrSetMethodName) {
        if (getOrSetMethodName.startsWith("get") || getOrSetMethodName.startsWith("set")) {
            return StrUtil.cutPreAndLowerFirst(getOrSetMethodName, 3);
        }
        return null;
    }

    public static String genSetter(String fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(String fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, "get");
    }

    public static String cutPreAndLowerFirst(String str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return null;
    }

    public static String upperFirstAndAddPre(String str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StrUtil.upperFirst(str);
    }

    public static String upperFirst(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String lowerFirst(String str) {
        if (StrUtil.isBlank(str)) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String removePrefix(String str, String prefix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removePrefixIgnoreCase(String str, String prefix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return str;
        }
        if (str.toLowerCase().startsWith(prefix.toLowerCase())) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return str;
        }
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String removeSuffixIgnoreCase(String str, String suffix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return str;
        }
        if (str.toLowerCase().endsWith(suffix.toLowerCase())) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String addPrefixIfNot(String str, String prefix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return str;
        }
        if (!str.startsWith(prefix)) {
            str = prefix + str;
        }
        return str;
    }

    public static String addSuffixIfNot(String str, String suffix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return str;
        }
        if (!str.endsWith(suffix)) {
            str = str + suffix;
        }
        return str;
    }

    public static String cleanBlank(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\s*", EMPTY);
    }

    public static List<String> split(String str, char separator) {
        return StrUtil.split(str, separator, 0);
    }

    public static List<String> split(String str, char separator, int limit) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(limit == 0 ? 16 : limit);
        if (limit == 1) {
            list.add(str);
            return list;
        }
        boolean isNotEnd = true;
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (isNotEnd && c == separator) {
                list.add(sb.toString());
                sb.delete(0, sb.length());
                if (limit == 0 || list.size() != limit - 1) continue;
                isNotEnd = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String[] split(String str, String delimiter) {
        int i;
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return new String[]{str};
        }
        int dellen = delimiter.length();
        int maxparts = str.length() / dellen + 2;
        int[] positions = new int[maxparts];
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = str.indexOf(delimiter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = str.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = str.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String sub(String string, int fromIndex, int toIndex) {
        int len = string.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex >= len) {
            fromIndex = len - 1;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        char[] strArray = string.toCharArray();
        char[] newStrArray = Arrays.copyOfRange(strArray, fromIndex, toIndex);
        return new String(newStrArray);
    }

    public static String subPre(String string, int toIndex) {
        return StrUtil.sub(string, 0, toIndex);
    }

    public static String subSuf(String string, int fromIndex) {
        if (StrUtil.isEmpty(string)) {
            return null;
        }
        return StrUtil.sub(string, fromIndex, string.length());
    }

    public static boolean isSurround(String str, String prefix, String suffix) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public static boolean isSurround(String str, char prefix, char suffix) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static String repeat(char c, int count) {
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(String str, int count) {
        int n;
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String format(String template, Object ... values) {
        if (CollectionUtil.isEmpty(values) || StrUtil.isBlank(template)) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int length = template.length();
        int valueIndex = 0;
        for (int i = 0; i < length; ++i) {
            if (valueIndex >= values.length) {
                sb.append(StrUtil.sub(template, i, length));
                break;
            }
            char currentChar = template.charAt(i);
            if (currentChar == '{') {
                char nextChar;
                if ((nextChar = template.charAt(++i)) == '}') {
                    sb.append(StrUtil.utf8Str(values[valueIndex++]));
                    continue;
                }
                sb.append('{').append(nextChar);
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String format(String template, Map<?, ?> map) {
        if (null == map || map.isEmpty()) {
            return template;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            template = template.replace("{" + entry.getKey() + "}", entry.getValue().toString());
        }
        return template;
    }

    public static byte[] bytes(String str, String charset) {
        return StrUtil.bytes(str, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.getBytes();
        }
        return str.getBytes(charset);
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, CharsetUtil.CHARSET_UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StrUtil.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[] || obj instanceof Byte[]) {
            return StrUtil.str((Object)((Byte[])obj), charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)obj, charset);
        }
        if (CollectionUtil.isArray(obj)) {
            return CollectionUtil.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StrUtil.str(bytes, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StrUtil.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static ByteBuffer byteBuffer(String str, String charset) {
        return ByteBuffer.wrap(StrUtil.bytes(str, charset));
    }

    public static String join(String conjunction, Object ... objs) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object item : objs) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String toUnderlineCase(String camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        int length = camelCaseStr.length();
        StringBuilder sb = new StringBuilder();
        boolean isPreUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = camelCaseStr.charAt(i);
            boolean isNextUpperCase = true;
            if (i < length - 1) {
                isNextUpperCase = Character.isUpperCase(camelCaseStr.charAt(i + 1));
            }
            if (Character.isUpperCase(c)) {
                if (!(isPreUpperCase && isNextUpperCase || i <= 0)) {
                    sb.append(UNDERLINE);
                }
                isPreUpperCase = true;
            } else {
                isPreUpperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toCamelCase(String name) {
        if (name == null) {
            return null;
        }
        if (name.contains(UNDERLINE)) {
            name = name.toLowerCase();
            StringBuilder sb = new StringBuilder(name.length());
            boolean upperCase = false;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return name;
    }

    public static String wrap(String str, String prefix, String suffix) {
        return StrUtil.format("{}{}{}", prefix, str, suffix);
    }

    public static boolean isWrap(String str, String prefix, String suffix) {
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public static boolean isWrap(String str, String wrapper) {
        return StrUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(String str, char wrapper) {
        return StrUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(String str, char prefixChar, char suffixChar) {
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String padPre(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padEnd(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(str);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder builder(String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringReader getReader(String str) {
        return new StringReader(str);
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }
}

