/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.watch;

import com.xiaoleilu.hutool.exceptions.WatchException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.watch.WatchListener;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class WatchMonitor {
    private static final Log log = LogFactory.get();
    private Path path;
    private WatchService watchService;

    public static WatchMonitor create(Path path) {
        return new WatchMonitor(path);
    }

    public static WatchMonitor create(File file) {
        return new WatchMonitor(file);
    }

    public static WatchMonitor create(String path) {
        return new WatchMonitor(path);
    }

    public WatchMonitor(Path path) {
        this.path = path;
        this.init();
    }

    public WatchMonitor(File file) {
        this(file.toPath());
    }

    public WatchMonitor(String path) {
        this(Paths.get(path, new String[0]));
    }

    public void init() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.path.register(this.watchService, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (Exception e) {
            throw new WatchException(e);
        }
    }

    public void start(WatchListener listener) {
        log.debug("Start watching path: [{}]", this.path);
        while (true) {
            WatchKey wk;
            try {
                wk = this.watchService.take();
            }
            catch (InterruptedException e) {
                log.warn(e);
                return;
            }
            for (WatchEvent<?> event : wk.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    listener.onCreate(event);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    listener.onModify(event);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    listener.onDelete(event);
                    continue;
                }
                if (kind != StandardWatchEventKinds.OVERFLOW) continue;
                listener.onOverflow(event);
            }
            wk.reset();
        }
    }

    public void close() {
        IoUtil.close(this.watchService);
    }
}

