/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.registry.impl;

import com.xxl.rpc.registry.ServiceRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LocalServiceRegistry
extends ServiceRegistry {
    private Map<String, TreeSet<String>> registryData;

    @Override
    public void start(Map<String, String> param) {
        this.registryData = new HashMap<String, TreeSet<String>>();
    }

    @Override
    public void stop() {
        this.registryData.clear();
    }

    @Override
    public boolean registry(Set<String> keys, String value) {
        if (keys == null || keys.size() == 0 || value == null || value.trim().length() == 0) {
            return false;
        }
        for (String key : keys) {
            TreeSet<String> values = this.registryData.get(key);
            if (values == null) {
                values = new TreeSet();
                this.registryData.put(key, values);
            }
            values.add(value);
        }
        return true;
    }

    @Override
    public boolean remove(Set<String> keys, String value) {
        if (keys == null || keys.size() == 0 || value == null || value.trim().length() == 0) {
            return false;
        }
        for (String key : keys) {
            TreeSet<String> values = this.registryData.get(key);
            if (values == null) continue;
            values.remove(value);
        }
        return true;
    }

    @Override
    public Map<String, TreeSet<String>> discovery(Set<String> keys) {
        if (keys == null || keys.size() == 0) {
            return null;
        }
        HashMap<String, TreeSet<String>> registryDataTmp = new HashMap<String, TreeSet<String>>();
        for (String key : keys) {
            TreeSet<String> valueSetTmp = this.discovery(key);
            if (valueSetTmp == null) continue;
            registryDataTmp.put(key, valueSetTmp);
        }
        return registryDataTmp;
    }

    @Override
    public TreeSet<String> discovery(String key) {
        return this.registryData.get(key);
    }
}

