/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.data.DefaultSlot;
import com.yomahub.liteflow.entity.data.LiteflowResponse;
import com.yomahub.liteflow.entity.data.Slot;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.enums.FlowParserTypeEnum;
import com.yomahub.liteflow.exception.ChainNotFoundException;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.exception.FlowExecutorNotInitException;
import com.yomahub.liteflow.exception.NoAvailableSlotException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.ClassJsonFlowParser;
import com.yomahub.liteflow.parser.ClassXmlFlowParser;
import com.yomahub.liteflow.parser.ClassYmlFlowParser;
import com.yomahub.liteflow.parser.FlowParser;
import com.yomahub.liteflow.parser.JsonFlowParser;
import com.yomahub.liteflow.parser.LocalJsonFlowParser;
import com.yomahub.liteflow.parser.LocalXmlFlowParser;
import com.yomahub.liteflow.parser.LocalYmlFlowParser;
import com.yomahub.liteflow.parser.XmlFlowParser;
import com.yomahub.liteflow.parser.YmlFlowParser;
import com.yomahub.liteflow.parser.ZookeeperJsonFlowParser;
import com.yomahub.liteflow.parser.ZookeeperXmlFlowParser;
import com.yomahub.liteflow.parser.ZookeeperYmlFlowParser;
import com.yomahub.liteflow.property.LiteflowConfig;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(FlowExecutor.class);
    private static final String ZK_CONFIG_REGEX = "[\\w\\d][\\w\\d\\.]+\\:(\\d)+(\\,[\\w\\d][\\w\\d\\.]+\\:(\\d)+)*";
    private static final String LOCAL_XML_CONFIG_REGEX = "^[\\w_\\-\\@\\/\\*]+\\.xml$";
    private static final String LOCAL_JSON_CONFIG_REGEX = "^[\\w_\\-\\@\\/\\*]+\\.json$";
    private static final String LOCAL_YML_CONFIG_REGEX = "^[\\w_\\-\\@\\/\\*]+\\.yml$";
    private static final String FORMATE_XML_CONFIG_REGEX = "xml:.+";
    private static final String FORMATE_JSON_CONFIG_REGEX = "json:.+";
    private static final String FORMATE_YML_CONFIG_REGEX = "yml:.+";
    private static final String PREFIX_FORMATE_CONFIG_REGEX = "xml:|json:|yml:";
    private static final String CLASS_CONFIG_REGEX = "^\\w+(\\.\\w+)*$";
    private LiteflowConfig liteflowConfig;
    private String zkNode;

    public void init() {
        if (ObjectUtil.isNull((Object)this.liteflowConfig) || StrUtil.isBlank((CharSequence)this.liteflowConfig.getRuleSource())) {
            throw new ConfigErrorException("config error, please check liteflow config property");
        }
        ArrayList rulePath = Lists.newArrayList((Object[])this.liteflowConfig.getRuleSource().split(",|;"));
        FlowParser parser = null;
        for (String path : rulePath) {
            try {
                FlowParserTypeEnum pattern = this.matchFormatConfig(path);
                if (ObjectUtil.isNotNull((Object)((Object)pattern))) {
                    path = ReUtil.replaceAll((CharSequence)path, (String)PREFIX_FORMATE_CONFIG_REGEX, (String)"");
                    switch (pattern) {
                        case TYPE_XML: {
                            parser = this.matchFormatParser(path, FlowParserTypeEnum.TYPE_XML);
                            break;
                        }
                        case TYPE_JSON: {
                            parser = this.matchFormatParser(path, FlowParserTypeEnum.TYPE_JSON);
                            break;
                        }
                        case TYPE_YML: {
                            parser = this.matchFormatParser(path, FlowParserTypeEnum.TYPE_YML);
                            break;
                        }
                        default: {
                            LOG.error("can't support the format {}", (Object)path);
                        }
                    }
                }
                if (ObjectUtil.isNotNull(parser)) {
                    parser.parseMain(path);
                    continue;
                }
                throw new ConfigErrorException("parse error, please check liteflow config property");
            }
            catch (Exception e) {
                String errorMsg = MessageFormat.format("init flow executor cause error,can not parse rule file {0}", path);
                LOG.error(errorMsg, (Throwable)e);
                throw new FlowExecutorNotInitException(errorMsg);
            }
        }
    }

    private FlowParser matchFormatParser(String path, FlowParserTypeEnum pattern) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        boolean isLocalFile = this.isLocalConfig(path);
        if (isLocalFile) {
            LOG.info("flow info loaded from local file,path={},format type={}", (Object)path, (Object)pattern.getType());
            switch (pattern) {
                case TYPE_XML: {
                    return new LocalXmlFlowParser();
                }
                case TYPE_JSON: {
                    return new LocalJsonFlowParser();
                }
                case TYPE_YML: {
                    return new LocalYmlFlowParser();
                }
            }
        } else if (this.isClassConfig(path)) {
            LOG.info("flow info loaded from class config,class={},format type={}", (Object)path, (Object)pattern.getType());
            Class<?> c = Class.forName(path);
            switch (pattern) {
                case TYPE_XML: {
                    return (XmlFlowParser)c.newInstance();
                }
                case TYPE_JSON: {
                    return (JsonFlowParser)c.newInstance();
                }
                case TYPE_YML: {
                    return (YmlFlowParser)c.newInstance();
                }
            }
        } else if (this.isZKConfig(path)) {
            LOG.info("flow info loaded from Zookeeper,zkNode={},format type={}", (Object)path, (Object)pattern.getType());
            switch (pattern) {
                case TYPE_XML: {
                    return StrUtil.isNotBlank((CharSequence)this.zkNode) ? new ZookeeperXmlFlowParser(this.zkNode) : new ZookeeperXmlFlowParser();
                }
                case TYPE_JSON: {
                    return StrUtil.isNotBlank((CharSequence)this.zkNode) ? new ZookeeperJsonFlowParser(this.zkNode) : new ZookeeperJsonFlowParser();
                }
                case TYPE_YML: {
                    return StrUtil.isNotBlank((CharSequence)this.zkNode) ? new ZookeeperYmlFlowParser(this.zkNode) : new ZookeeperYmlFlowParser();
                }
            }
        }
        LOG.info("load flow info error, path={}, pattern={}", (Object)path, (Object)pattern.getType());
        return null;
    }

    private boolean isLocalConfig(String path) {
        return ReUtil.isMatch((String)LOCAL_XML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_JSON_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_YML_CONFIG_REGEX, (CharSequence)path);
    }

    private boolean isClassConfig(String path) {
        return ReUtil.isMatch((String)CLASS_CONFIG_REGEX, (CharSequence)path);
    }

    private boolean isZKConfig(String path) {
        return ReUtil.isMatch((String)ZK_CONFIG_REGEX, (CharSequence)path);
    }

    private FlowParserTypeEnum matchFormatConfig(String path) {
        if (ReUtil.isMatch((String)LOCAL_XML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)FORMATE_XML_CONFIG_REGEX, (CharSequence)path)) {
            return FlowParserTypeEnum.TYPE_XML;
        }
        if (ReUtil.isMatch((String)LOCAL_JSON_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)FORMATE_JSON_CONFIG_REGEX, (CharSequence)path)) {
            return FlowParserTypeEnum.TYPE_JSON;
        }
        if (ReUtil.isMatch((String)LOCAL_YML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)FORMATE_YML_CONFIG_REGEX, (CharSequence)path)) {
            return FlowParserTypeEnum.TYPE_YML;
        }
        if (this.isClassConfig(path)) {
            try {
                Class<?> clazz = Class.forName(path);
                if (ClassXmlFlowParser.class.isAssignableFrom(clazz)) {
                    return FlowParserTypeEnum.TYPE_XML;
                }
                if (ClassJsonFlowParser.class.isAssignableFrom(clazz)) {
                    return FlowParserTypeEnum.TYPE_JSON;
                }
                if (ClassYmlFlowParser.class.isAssignableFrom(clazz)) {
                    return FlowParserTypeEnum.TYPE_YML;
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error(e.getMessage());
            }
        }
        return null;
    }

    public void reloadRule() {
        this.init();
    }

    public <T extends Slot> void invoke(String chainId, Object param, Class<T> slotClazz, Integer slotIndex) throws Exception {
        this.execute(chainId, param, slotClazz, slotIndex, true);
    }

    public DefaultSlot execute(String chainId, Object param) throws Exception {
        return this.execute(chainId, param, DefaultSlot.class, null, false);
    }

    public <T extends Slot> T execute(String chainId, Object param, Class<T> slotClazz) throws Exception {
        return this.execute(chainId, param, slotClazz, null, false);
    }

    public <T extends Slot> T execute(String chainId, Object param, Class<T> slotClazz, Integer slotIndex, boolean isInnerChain) throws Exception {
        return this.doExecute(chainId, param, slotClazz, slotIndex, isInnerChain);
    }

    public LiteflowResponse<DefaultSlot> execute2Resp(String chainId, Object param) {
        return this.execute2Resp(chainId, param, DefaultSlot.class);
    }

    public <T extends Slot> LiteflowResponse<T> execute2Resp(String chainId, Object param, Class<T> slotClazz) {
        return this.execute2Resp(chainId, param, slotClazz, null, false);
    }

    public <T extends Slot> LiteflowResponse<T> execute2Resp(String chainId, Object param, Class<T> slotClazz, Integer slotIndex, boolean isInnerChain) {
        LiteflowResponse<T> response = new LiteflowResponse<T>();
        try {
            T slot = this.doExecute(chainId, param, slotClazz, slotIndex, isInnerChain);
            response.setSlot(slot);
        }
        catch (Exception ex) {
            response.setSuccess(false);
            response.setMessage(ex.getMessage());
            response.setCause(ex.fillInStackTrace());
            LOG.error("chain execute exception:{}", (Throwable)ex);
        }
        return response;
    }

    private <T extends Slot> T doExecute(String chainId, Object param, Class<T> slotClazz, Integer slotIndex, boolean isInnerChain) throws Exception {
        Chain chain;
        if (FlowBus.needInit()) {
            this.init();
        }
        if (ObjectUtil.isNull((Object)(chain = FlowBus.getChain(chainId)))) {
            String errorMsg = MessageFormat.format("couldn't find chain with the id[{0}]", chainId);
            throw new ChainNotFoundException(errorMsg);
        }
        if (!isInnerChain && ObjectUtil.isNull((Object)slotIndex)) {
            slotIndex = DataBus.offerSlot(slotClazz);
            LOG.info("slot[{}] offered", (Object)slotIndex);
        }
        if (slotIndex == -1) {
            throw new NoAvailableSlotException("there is no available slot");
        }
        Object slot = DataBus.getSlot(slotIndex);
        if (ObjectUtil.isNull(slot)) {
            throw new NoAvailableSlotException("the slot is not exist");
        }
        if (StrUtil.isBlank((CharSequence)slot.getRequestId())) {
            slot.generateRequestId();
            LOG.info("requestId[{}] has generated", (Object)slot.getRequestId());
        }
        if (!isInnerChain) {
            slot.setRequestData((Object)param);
            slot.setChainName(chainId);
        } else {
            slot.setChainReqData(chainId, (Object)param);
        }
        try {
            chain.execute(slotIndex);
        }
        catch (Exception e) {
            LOG.error("[{}]:chain[{}] execute error on slot[{}]", new Object[]{slot.getRequestId(), chain.getChainName(), slotIndex});
            throw e;
        }
        finally {
            if (!isInnerChain) {
                slot.printStep();
                DataBus.releaseSlot(slotIndex);
            }
        }
        return (T)slot;
    }

    public String getZkNode() {
        return this.zkNode;
    }

    public void setZkNode(String zkNode) {
        this.zkNode = zkNode;
    }

    public LiteflowConfig getLiteflowConfig() {
        return this.liteflowConfig;
    }

    public void setLiteflowConfig(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
    }
}

