/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.liteflow.core.NodeCondComponent;
import com.yomahub.liteflow.entity.data.CmpStep;
import com.yomahub.liteflow.entity.data.CmpStepType;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.data.Slot;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.entity.monitor.CompStatistics;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.spring.ComponentScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class NodeComponent {
    private static final Logger LOG = LoggerFactory.getLogger(NodeComponent.class);
    private TransmittableThreadLocal<Integer> slotIndexTL = new TransmittableThreadLocal();
    @Autowired(required=false)
    private MonitorBus monitorBus;
    private String nodeId;
    private NodeComponent self;
    private TransmittableThreadLocal<Boolean> isEndTL = new TransmittableThreadLocal();

    public void execute() throws Exception {
        Node thisNode;
        Executable condExecutor;
        String condNodeId;
        Object slot = this.getSlot();
        LOG.info("[{}]:[O]start component[{}] execution", (Object)slot.getRequestId(), (Object)this.getClass().getSimpleName());
        slot.addStep(new CmpStep(this.nodeId, CmpStepType.SINGLE));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (ObjectUtil.isNotNull((Object)ComponentScanner.cmpAroundAspect)) {
            ComponentScanner.cmpAroundAspect.beforeProcess(this.getNodeId(), (Slot)slot);
        }
        this.self.process();
        if (ObjectUtil.isNotNull((Object)ComponentScanner.cmpAroundAspect)) {
            ComponentScanner.cmpAroundAspect.afterProcess(this.getNodeId(), (Slot)slot);
        }
        stopWatch.stop();
        long timeSpent = stopWatch.getTotalTimeMillis();
        if (ObjectUtil.isNotNull((Object)this.monitorBus)) {
            CompStatistics statistics = new CompStatistics(this.getClass().getSimpleName(), timeSpent);
            this.monitorBus.addStatistics(statistics);
        }
        if (this instanceof NodeCondComponent && StrUtil.isNotBlank((CharSequence)(condNodeId = (String)slot.getCondResult(this.getClass().getName()))) && ObjectUtil.isNotNull((Object)(condExecutor = (thisNode = FlowBus.getNode(this.nodeId)).getCondNode(condNodeId)))) {
            condExecutor.execute((Integer)this.slotIndexTL.get());
        }
        LOG.debug("[{}]:componnet[{}] finished in {} milliseconds", new Object[]{slot.getRequestId(), this.getClass().getSimpleName(), timeSpent});
    }

    public abstract void process() throws Exception;

    public boolean isAccess() {
        return true;
    }

    public boolean isContinueOnError() {
        return false;
    }

    public boolean isEnd() {
        Boolean isEnd = (Boolean)this.isEndTL.get();
        if (ObjectUtil.isNull((Object)isEnd)) {
            return false;
        }
        return (Boolean)this.isEndTL.get();
    }

    public void setIsEnd(boolean isEnd) {
        this.isEndTL.set((Object)isEnd);
    }

    public void removeIsEnd() {
        this.isEndTL.remove();
    }

    public NodeComponent setSlotIndex(Integer slotIndex) {
        this.slotIndexTL.set((Object)slotIndex);
        return this;
    }

    public Integer getSlotIndex() {
        return (Integer)this.slotIndexTL.get();
    }

    public void removeSlotIndex() {
        this.slotIndexTL.remove();
    }

    public <T extends Slot> T getSlot() {
        return DataBus.getSlot((Integer)this.slotIndexTL.get());
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public NodeComponent getSelf() {
        return this.self;
    }

    public void setSelf(NodeComponent self) {
        this.self = self;
    }
}

