/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.data;

import com.yomahub.liteflow.entity.data.CmpStep;
import com.yomahub.liteflow.entity.data.Slot;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsSlot
implements Slot {
    private static final Logger LOG = LoggerFactory.getLogger(Slot.class);
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";
    private static final String CHAINNAME = "chain_name";
    private static final String COND_NODE_PREFIX = "cond_";
    private static final String NODE_INPUT_PREFIX = "input_";
    private static final String NODE_OUTPUT_PREFIX = "output_";
    private static final String CHAIN_REQ_PREFIX = "chain_req_";
    private static final String REQUEST_ID = "req_id";
    private Deque<CmpStep> executeSteps = new ArrayDeque<CmpStep>();
    protected ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap();

    @Override
    public <T> T getInput(String nodeId) {
        return (T)this.dataMap.get(NODE_INPUT_PREFIX + nodeId);
    }

    @Override
    public <T> T getOutput(String nodeId) {
        return (T)this.dataMap.get(NODE_OUTPUT_PREFIX + nodeId);
    }

    @Override
    public <T> void setInput(String nodeId, T t) {
        this.dataMap.put(NODE_INPUT_PREFIX + nodeId, t);
    }

    @Override
    public <T> void setOutput(String nodeId, T t) {
        this.dataMap.put(NODE_OUTPUT_PREFIX + nodeId, t);
    }

    @Override
    public <T> T getRequestData() {
        return (T)this.dataMap.get(REQUEST);
    }

    @Override
    public <T> void setRequestData(T t) {
        this.dataMap.put(REQUEST, t);
    }

    @Override
    public <T> T getResponseData() {
        return (T)this.dataMap.get(RESPONSE);
    }

    @Override
    public <T> void setResponseData(T t) {
        this.dataMap.put(RESPONSE, t);
    }

    @Override
    public <T> T getChainReqData(String chainId) {
        return (T)this.dataMap.get(CHAIN_REQ_PREFIX + chainId);
    }

    @Override
    public <T> void setChainReqData(String chainId, T t) {
        this.dataMap.put(CHAIN_REQ_PREFIX + chainId, t);
    }

    @Override
    public <T> T getData(String key) {
        return (T)this.dataMap.get(key);
    }

    @Override
    public <T> void setData(String key, T t) {
        this.dataMap.put(key, t);
    }

    @Override
    public <T> void setCondResult(String key, T t) {
        this.dataMap.put(COND_NODE_PREFIX + key, t);
    }

    @Override
    public <T> T getCondResult(String key) {
        return (T)this.dataMap.get(COND_NODE_PREFIX + key);
    }

    @Override
    public void setChainName(String chainName) {
        this.dataMap.put(CHAINNAME, chainName);
    }

    @Override
    public String getChainName() {
        return (String)this.dataMap.get(CHAINNAME);
    }

    @Override
    public void addStep(CmpStep step) {
        this.executeSteps.add(step);
    }

    @Override
    public String printStep() {
        StringBuffer str = new StringBuffer();
        CmpStep cmpStep = null;
        Iterator<CmpStep> it = this.executeSteps.iterator();
        while (it.hasNext()) {
            cmpStep = it.next();
            str.append(cmpStep);
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        LOG.info("[{}]:CHAIN_NAME[{}]\n{}", new Object[]{this.getRequestId(), this.getChainName(), str.toString()});
        return str.toString();
    }

    @Override
    public void generateRequestId() {
        this.dataMap.put(REQUEST_ID, new Long(System.nanoTime()).toString());
    }

    @Override
    public String getRequestId() {
        return (String)this.dataMap.get(REQUEST_ID);
    }

    public Deque<CmpStep> getExecuteSteps() {
        return this.executeSteps;
    }
}

