/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.data;

import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.entity.data.Slot;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.util.SpringAware;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBus {
    private static final Logger LOG = LoggerFactory.getLogger(DataBus.class);
    public static AtomicInteger OCCUPY_COUNT = new AtomicInteger(0);
    private static AtomicReferenceArray<Slot> SLOTS;
    private static ConcurrentLinkedQueue<Integer> QUEUE;

    public static int offerSlot(Class<? extends Slot> slotClazz) {
        try {
            Slot slot = slotClazz.newInstance();
            Integer slotIndex = QUEUE.poll();
            if (ObjectUtil.isNotNull((Object)slotIndex) && SLOTS.compareAndSet(slotIndex, null, slot)) {
                OCCUPY_COUNT.incrementAndGet();
                return slotIndex;
            }
        }
        catch (Exception e) {
            LOG.error("offer slot error", (Throwable)e);
            return -1;
        }
        return -1;
    }

    public static <T extends Slot> T getSlot(int slotIndex) {
        return (T)SLOTS.get(slotIndex);
    }

    public static void releaseSlot(int slotIndex) {
        if (ObjectUtil.isNotNull((Object)SLOTS.get(slotIndex))) {
            LOG.info("[{}]:slot[{}] released", (Object)SLOTS.get(slotIndex).getRequestId(), (Object)slotIndex);
            SLOTS.set(slotIndex, null);
            QUEUE.add(slotIndex);
            OCCUPY_COUNT.decrementAndGet();
        } else {
            LOG.warn("slot[{}] already has been released", (Object)slotIndex);
        }
    }

    static {
        LiteflowConfig liteflowConfig = SpringAware.getBean(LiteflowConfig.class);
        if (ObjectUtil.isNull((Object)liteflowConfig)) {
            liteflowConfig = new LiteflowConfig();
        }
        int slotSize = liteflowConfig.getSlotSize();
        SLOTS = new AtomicReferenceArray(slotSize);
        QUEUE = IntStream.range(0, slotSize - 1).boxed().collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
    }
}

