/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.flow;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.ParallelCallable;
import com.yomahub.liteflow.entity.flow.ThenCondition;
import com.yomahub.liteflow.entity.flow.WhenCondition;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.exception.WhenExecuteException;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.util.ExecutorHelper;
import com.yomahub.liteflow.util.SpringAware;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chain
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(Chain.class);
    private String chainName;
    private List<Condition> conditionList;
    private static ExecutorService parallelExecutor;
    private static LiteflowConfig liteflowConfig;

    public Chain(String chainName, List<Condition> conditionList) {
        this.chainName = chainName;
        this.conditionList = conditionList;
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    public void setConditionList(List<Condition> conditionList) {
        this.conditionList = conditionList;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    @Override
    public void execute(Integer slotIndex) throws Exception {
        if (CollUtil.isEmpty(this.conditionList)) {
            throw new FlowSystemException("no conditionList in this chain[" + this.chainName + "]");
        }
        Object slot = DataBus.getSlot(slotIndex);
        for (Condition condition : this.conditionList) {
            if (condition instanceof ThenCondition) {
                for (Executable executableItem : condition.getNodeList()) {
                    executableItem.execute(slotIndex);
                }
                continue;
            }
            if (!(condition instanceof WhenCondition)) continue;
            this.executeAsyncCondition((WhenCondition)condition, slotIndex, slot.getRequestId());
        }
    }

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.CHAIN;
    }

    @Override
    public String getExecuteName() {
        return this.chainName;
    }

    private void executeAsyncCondition(WhenCondition condition, Integer slotIndex, String requestId) {
        CountDownLatch latch = new CountDownLatch(condition.getNodeList().size());
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(condition.getNodeList().size());
        for (int i = 0; i < condition.getNodeList().size(); ++i) {
            futures.add(parallelExecutor.submit(new ParallelCallable(condition.getNodeList().get(i), slotIndex, requestId, latch)));
        }
        boolean interrupted = false;
        try {
            if (!latch.await(liteflowConfig.getWhenMaxWaitSeconds().intValue(), TimeUnit.SECONDS)) {
                for (Future future : futures) {
                    future.cancel(true);
                }
                interrupted = true;
                LOG.warn("requestId [{}] executing async condition has reached max-wait-seconds, condition canceled.", (Object)requestId);
            }
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        if (!condition.isErrorResume()) {
            if (interrupted) {
                throw new WhenExecuteException(String.format("requestId [%s] when execute interrupted. errorResume [false].", requestId));
            }
            for (Future future : futures) {
                try {
                    if (((Boolean)future.get()).booleanValue()) continue;
                    throw new WhenExecuteException(String.format("requestId [%s] when execute failed. errorResume [false].", requestId));
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new WhenExecuteException(String.format("requestId [%s] when execute failed. errorResume [false].", requestId));
                }
            }
        } else if (interrupted) {
            LOG.warn("requestId [{}] executing when condition timeout , but ignore with errorResume.", (Object)requestId);
        }
    }

    static {
        liteflowConfig = SpringAware.getBean(LiteflowConfig.class);
        if (ObjectUtil.isNull((Object)liteflowConfig)) {
            liteflowConfig = new LiteflowConfig();
        }
        if (ObjectUtil.isNull((Object)(parallelExecutor = SpringAware.getBean(ExecutorService.class)))) {
            parallelExecutor = ExecutorHelper.buildExecutor(liteflowConfig.getWhenMaxWorkers(), liteflowConfig.getWhenQueueLimit(), "liteflow-when-thread", false);
        }
    }
}

