/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.flow;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.FlowSystemException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(Node.class);
    private String id;
    private String clazz;
    private NodeComponent instance;
    private final Map<String, Executable> condNodeMap = new HashMap<String, Executable>();

    public Node() {
    }

    public Node(String id, String clazz, NodeComponent instance) {
        this.id = id;
        this.clazz = clazz;
        this.instance = instance;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public NodeComponent getInstance() {
        return this.instance;
    }

    public void setInstance(NodeComponent instance) {
        this.instance = instance;
    }

    public Executable getCondNode(String nodeId) {
        return this.condNodeMap.get(nodeId);
    }

    public void setCondNode(String nodeId, Executable condNode) {
        this.condNodeMap.put(nodeId, condNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        block10: {
            if (ObjectUtil.isNull((Object)this.instance)) {
                throw new FlowSystemException("there is no instance for node id " + this.id);
            }
            this.instance.setSlotIndex(slotIndex);
            Object slot = DataBus.getSlot(slotIndex);
            try {
                if (this.instance.isAccess()) {
                    this.instance.execute();
                    if (this.instance.isEnd()) {
                        String errorInfo = StrUtil.format((CharSequence)"[{}]:component[{}] lead the chain to end", (Object[])new Object[]{slot.getRequestId(), this.instance.getClass().getSimpleName()});
                        throw new ChainEndException(errorInfo);
                    }
                } else {
                    LOG.info("[{}]:[X]skip component[{}] execution", (Object)slot.getRequestId(), (Object)this.instance.getClass().getSimpleName());
                }
            }
            catch (Exception e) {
                if (this.instance.isContinueOnError()) {
                    String errorMsg = MessageFormat.format("[{0}]:component[{1}] cause error,but flow is still go on", slot.getRequestId(), this.id);
                    LOG.error(errorMsg, (Throwable)e);
                    break block10;
                }
                String errorMsg = MessageFormat.format("[{0}]:component[{1}] cause error,error:{2}", slot.getRequestId(), this.id, e.getMessage());
                LOG.error(errorMsg, (Throwable)e);
                throw e;
            }
            finally {
                this.instance.removeSlotIndex();
                this.instance.removeIsEnd();
            }
        }
    }

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.NODE;
    }

    @Override
    public String getExecuteName() {
        return this.id;
    }
}

