/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.enums.FlowParserTypeEnum;
import com.yomahub.liteflow.exception.ComponentCannotRegisterException;
import com.yomahub.liteflow.parser.LocalJsonFlowParser;
import com.yomahub.liteflow.parser.LocalXmlFlowParser;
import com.yomahub.liteflow.parser.LocalYmlFlowParser;
import com.yomahub.liteflow.util.SpringAware;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowBus {
    private static final Logger LOG = LoggerFactory.getLogger(FlowBus.class);
    private static final Map<String, Chain> chainMap = new HashMap<String, Chain>();
    private static final Map<String, Node> nodeMap = new HashMap<String, Node>();

    private FlowBus() {
    }

    public static Chain getChain(String id) throws Exception {
        if (MapUtil.isEmpty(chainMap)) {
            throw new Exception("please config the rule first");
        }
        return chainMap.get(id);
    }

    public static void addChain(String name, Chain chain) {
        chainMap.put(name, chain);
    }

    public static boolean containChain(String chainId) {
        return chainMap.containsKey(chainId);
    }

    public static boolean needInit() {
        return MapUtil.isEmpty(chainMap);
    }

    public static boolean containNode(String nodeId) {
        return nodeMap.containsKey(nodeId);
    }

    public static void addNode(String nodeId, Node node) {
        if (FlowBus.containNode(nodeId)) {
            return;
        }
        nodeMap.put(nodeId, node);
    }

    public static void addNode(String nodeId, String cmpClazzStr) throws Exception {
        if (FlowBus.containNode(nodeId)) {
            return;
        }
        Class<?> cmpClazz = Class.forName(cmpClazzStr);
        FlowBus.addNode(nodeId, cmpClazz);
    }

    public static void addNode(String nodeId, Class<? extends NodeComponent> cmpClazz) {
        if (FlowBus.containNode(nodeId)) {
            return;
        }
        try {
            NodeComponent cmpInstance = SpringAware.registerOrGet(cmpClazz);
            if (ObjectUtil.isNull((Object)cmpInstance)) {
                LOG.warn("couldn't find component class [{}] from spring context", (Object)cmpClazz.getName());
                cmpInstance = cmpClazz.newInstance();
            }
            cmpInstance.setNodeId(nodeId);
            cmpInstance.setSelf(cmpInstance);
            nodeMap.put(nodeId, new Node(nodeId, cmpClazz.getName(), cmpInstance));
        }
        catch (Exception e) {
            String error = StrUtil.format((CharSequence)"component[{}] register error", (Object[])new Object[]{cmpClazz.getName()});
            LOG.error(error, (Throwable)e);
            throw new ComponentCannotRegisterException(error);
        }
    }

    public static Node getNode(String nodeId) {
        return nodeMap.get(nodeId);
    }

    public static void cleanCache() {
        chainMap.clear();
        nodeMap.clear();
    }

    public static void refreshFlowMetaData(FlowParserTypeEnum type, String content) throws Exception {
        if (type.equals((Object)FlowParserTypeEnum.TYPE_XML)) {
            new LocalXmlFlowParser().parse(content);
        } else if (type.equals((Object)FlowParserTypeEnum.TYPE_JSON)) {
            new LocalJsonFlowParser().parse(content);
        } else if (type.equals((Object)FlowParserTypeEnum.TYPE_YML)) {
            new LocalYmlFlowParser().parse(content);
        }
    }
}

