/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.ThenCondition;
import com.yomahub.liteflow.entity.flow.WhenCondition;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.parser.RegexEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public abstract class FlowParser {
    public abstract void parseMain(String var1) throws Exception;

    public abstract void parse(String var1) throws Exception;

    public RegexEntity parseNodeStr(String str) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern p = Pattern.compile("[^\\)\\(]+");
        Matcher m = p.matcher(str);
        while (m.find()) {
            list.add(m.group());
        }
        RegexEntity regexEntity = new RegexEntity();
        regexEntity.setItem(((String)list.get(0)).trim());
        if (list.size() > 1) {
            String[] realNodeArray = ((String)list.get(1)).split("\\|");
            for (int i = 0; i < realNodeArray.length; ++i) {
                realNodeArray[i] = realNodeArray[i].trim();
            }
            regexEntity.setRealItemArray(realNodeArray);
        }
        return regexEntity;
    }

    protected void buildBaseFlowConditions(List<Condition> conditionList, Condition condition) {
        if (condition.getConditionType().equals(ConditionTypeEnum.TYPE_THEN.getType())) {
            if (conditionList.size() > 1 && CollectionUtil.getLast(conditionList) instanceof ThenCondition) {
                ((Condition)CollectionUtil.getLast(conditionList)).getNodeList().addAll(condition.getNodeList());
            } else {
                conditionList.add(new ThenCondition(condition));
            }
        } else if (condition.getConditionType().equals(ConditionTypeEnum.TYPE_WHEN.getType())) {
            if (conditionList.size() > 1 && CollectionUtil.getLast(conditionList) instanceof WhenCondition && ((Condition)CollectionUtil.getLast(conditionList)).getGroup().equals(condition.getGroup())) {
                ((Condition)CollectionUtil.getLast(conditionList)).getNodeList().addAll(condition.getNodeList());
            } else {
                conditionList.add(new WhenCondition(condition));
            }
        }
    }

    protected Resource[] matchRuleResources(String ruleSource) throws IOException {
        PathMatchingResourcePatternResolver resolver;
        Object[] resources;
        Assert.notNull((Object)ruleSource, (String)"rule source must not be null");
        String locationPattern = ruleSource;
        if (!locationPattern.startsWith("classpath:")) {
            locationPattern = "classpath:" + locationPattern;
        }
        if (ArrayUtil.isEmpty((Object[])(resources = (resolver = new PathMatchingResourcePatternResolver()).getResources(locationPattern)))) {
            throw new ConfigErrorException("config error,please check rule source property");
        }
        return resources;
    }
}

