/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.exception.ExecutableItemNotFoundException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.FlowParser;
import com.yomahub.liteflow.parser.RegexEntity;
import com.yomahub.liteflow.spring.ComponentScanner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonFlowParser
extends FlowParser {
    private final Logger LOG = LoggerFactory.getLogger(JsonFlowParser.class);

    @Override
    public void parse(String content) throws Exception {
        if (StrUtil.isBlank((CharSequence)content)) {
            return;
        }
        JSONObject flowJsonObject = JSONObject.parseObject((String)content, (Feature[])new Feature[]{Feature.OrderedField});
        this.parse(flowJsonObject);
    }

    public void parse(JSONObject flowJsonObject) throws Exception {
        try {
            if (ComponentScanner.nodeComponentMap.isEmpty()) {
                JSONArray nodeArrayList = flowJsonObject.getJSONObject("flow").getJSONObject("nodes").getJSONArray("node");
                for (int i = 0; i < nodeArrayList.size(); ++i) {
                    JSONObject nodeObject = nodeArrayList.getJSONObject(i);
                    String string = nodeObject.getString("id");
                    String clazz = nodeObject.getString("class");
                    FlowBus.addNode(string, clazz);
                }
            } else {
                for (Map.Entry entry : ComponentScanner.nodeComponentMap.entrySet()) {
                    if (FlowBus.containNode((String)entry.getKey())) continue;
                    FlowBus.addNode((String)entry.getKey(), new Node((String)entry.getKey(), ((NodeComponent)entry.getValue()).getClass().getName(), (NodeComponent)entry.getValue()));
                }
            }
            JSONArray chainList = flowJsonObject.getJSONObject("flow").getJSONArray("chain");
            HashMap<String, JSONObject> hashMap = new HashMap<String, JSONObject>();
            for (int i = 0; i < chainList.size(); ++i) {
                JSONObject chainObject = chainList.getJSONObject(i);
                if (!chainObject.containsKey((Object)"name") || !StrUtil.isNotBlank((CharSequence)chainObject.getString("name"))) continue;
                hashMap.put(chainObject.getString("name"), chainObject);
            }
            for (Map.Entry chainEntry : hashMap.entrySet()) {
                this.parseOneChain((JSONObject)chainEntry.getValue(), hashMap);
            }
        }
        catch (Exception e) {
            this.LOG.error("JsonFlowParser parser exception", (Throwable)e);
            throw e;
        }
    }

    private void parseOneChain(JSONObject chainObject, Map<String, JSONObject> chainMap) throws Exception {
        String chainName = chainObject.getString("name");
        JSONArray conditionArray = chainObject.getJSONArray("condition");
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        for (JSONObject condObject : conditionArray) {
            String condType = condObject.getString("type");
            String condArrayStr = condObject.getString("value");
            String group = condObject.getString("group");
            String errorResume = condObject.getString("errorResume");
            if (StrUtil.isBlank((CharSequence)condType) || StrUtil.isBlank((CharSequence)condArrayStr)) continue;
            if (StrUtil.isBlank((CharSequence)group)) {
                group = "default";
            }
            if (StrUtil.isBlank((CharSequence)errorResume)) {
                errorResume = Boolean.TRUE.toString();
            }
            Condition condition = new Condition();
            ArrayList<Executable> chainNodeList = new ArrayList<Executable>();
            String[] condArray = condArrayStr.split(",");
            for (int i = 0; i < condArray.length; ++i) {
                String itemExpression = condArray[i].trim();
                RegexEntity regexEntity = this.parseNodeStr(itemExpression);
                String item = regexEntity.getItem();
                if (FlowBus.containNode(item)) {
                    Node node = FlowBus.getNode(item);
                    chainNodeList.add(node);
                    if (regexEntity.getRealItemArray() == null) continue;
                    for (String key : regexEntity.getRealItemArray()) {
                        if (FlowBus.containNode(key)) {
                            Node condNode = FlowBus.getNode(key);
                            node.setCondNode(condNode.getId(), condNode);
                            continue;
                        }
                        if (!this.hasChain(chainMap, key)) continue;
                        Chain chain = FlowBus.getChain(key);
                        node.setCondNode(chain.getChainName(), chain);
                    }
                    continue;
                }
                if (this.hasChain(chainMap, item)) {
                    Chain chain = FlowBus.getChain(item);
                    chainNodeList.add(chain);
                    continue;
                }
                String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{regexEntity.getItem()});
                throw new ExecutableItemNotFoundException(errorMsg);
            }
            condition.setErrorResume(errorResume.equals(Boolean.TRUE.toString()));
            condition.setGroup(group);
            condition.setConditionType(condType);
            condition.setNodeList(chainNodeList);
            super.buildBaseFlowConditions(conditionList, condition);
        }
        FlowBus.addChain(chainName, new Chain(chainName, conditionList));
    }

    private boolean hasChain(Map<String, JSONObject> chainMap, String chainName) throws Exception {
        if (chainMap.containsKey(chainName) && !FlowBus.containChain(chainName)) {
            this.parseOneChain(chainMap.get(chainName), chainMap);
            return true;
        }
        return FlowBus.containChain(chainName);
    }
}

