/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.exception.ExecutableItemNotFoundException;
import com.yomahub.liteflow.exception.ParseException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.FlowParser;
import com.yomahub.liteflow.parser.RegexEntity;
import com.yomahub.liteflow.spring.ComponentScanner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlFlowParser
extends FlowParser {
    private final Logger LOG = LoggerFactory.getLogger(XmlFlowParser.class);

    @Override
    public void parse(String content) throws Exception {
        if (StrUtil.isBlank((CharSequence)content)) {
            return;
        }
        Document document = DocumentHelper.parseText((String)content);
        this.parse(document);
    }

    public void parse(Document document) throws Exception {
        try {
            Element rootElement = document.getRootElement();
            if (ComponentScanner.nodeComponentMap.isEmpty()) {
                List nodeList = rootElement.element("nodes").elements("node");
                Iterator iterator = nodeList.iterator();
                while (iterator.hasNext()) {
                    Element e = (Element)iterator.next();
                    String string = e.attributeValue("id");
                    String clazz = e.attributeValue("class");
                    FlowBus.addNode(string, clazz);
                }
            } else {
                for (Map.Entry entry : ComponentScanner.nodeComponentMap.entrySet()) {
                    if (FlowBus.containNode((String)entry.getKey())) continue;
                    FlowBus.addNode((String)entry.getKey(), new Node((String)entry.getKey(), ((NodeComponent)entry.getValue()).getClass().getName(), (NodeComponent)entry.getValue()));
                }
            }
            List chainList = rootElement.elements("chain");
            for (Element e : chainList) {
                this.parseOneChain(e);
            }
        }
        catch (Exception e) {
            String errorMsg = "FlowParser parser exception";
            this.LOG.error(errorMsg, (Throwable)e);
            throw new ParseException(errorMsg);
        }
    }

    private void parseOneChain(Element e) throws Exception {
        String chainName = e.attributeValue("name");
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        Iterator it = e.elementIterator();
        while (it.hasNext()) {
            Element condE = (Element)it.next();
            String condArrayStr = condE.attributeValue("value");
            String errorResume = condE.attributeValue("errorResume");
            String group = condE.attributeValue("group");
            if (StrUtil.isBlank((CharSequence)condArrayStr)) continue;
            if (StrUtil.isBlank((CharSequence)group)) {
                group = "default";
            }
            if (StrUtil.isBlank((CharSequence)errorResume)) {
                errorResume = Boolean.TRUE.toString();
            }
            Condition condition = new Condition();
            ArrayList<Executable> chainNodeList = new ArrayList<Executable>();
            String[] condArray = condArrayStr.split(",");
            for (int i = 0; i < condArray.length; ++i) {
                String itemExpression = condArray[i].trim();
                RegexEntity regexEntity = this.parseNodeStr(itemExpression);
                String item = regexEntity.getItem();
                if (FlowBus.containNode(item)) {
                    Node node = FlowBus.getNode(item);
                    chainNodeList.add(node);
                    if (regexEntity.getRealItemArray() == null) continue;
                    for (String key : regexEntity.getRealItemArray()) {
                        if (FlowBus.containNode(key)) {
                            Node condNode = FlowBus.getNode(key);
                            node.setCondNode(condNode.getId(), condNode);
                            continue;
                        }
                        if (!this.hasChain(e, key)) continue;
                        Chain chain = FlowBus.getChain(key);
                        node.setCondNode(chain.getChainName(), chain);
                    }
                    continue;
                }
                if (this.hasChain(e, item)) {
                    Chain chain = FlowBus.getChain(item);
                    chainNodeList.add(chain);
                    continue;
                }
                String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{regexEntity.getItem()});
                throw new ExecutableItemNotFoundException(errorMsg);
            }
            condition.setErrorResume(errorResume.equals(Boolean.TRUE.toString()));
            condition.setGroup(group);
            condition.setConditionType(condE.getName());
            condition.setNodeList(chainNodeList);
            super.buildBaseFlowConditions(conditionList, condition);
        }
        FlowBus.addChain(chainName, new Chain(chainName, conditionList));
    }

    private boolean hasChain(Element e, String chainName) throws Exception {
        Element rootElement = e.getParent();
        List chainList = rootElement.elements("chain");
        for (Element ce : chainList) {
            String ceName = ce.attributeValue("name");
            if (!ceName.equals(chainName)) continue;
            if (!FlowBus.containChain(chainName)) {
                this.parseOneChain(ce);
            }
            return true;
        }
        return false;
    }
}

