/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ParseException;
import com.yomahub.liteflow.parser.JsonFlowParser;
import java.text.MessageFormat;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperJsonFlowParser
extends JsonFlowParser {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperJsonFlowParser.class);
    private String nodePath = "/lite-flow/flow";

    public ZookeeperJsonFlowParser() {
    }

    public ZookeeperJsonFlowParser(String node) {
        this.nodePath = node;
    }

    @Override
    public void parseMain(String path) throws Exception {
        String content;
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)path, (RetryPolicy)new RetryNTimes(10, 5000));
        client.start();
        if (client.checkExists().forPath(this.nodePath) == null) {
            client.create().creatingParentsIfNeeded().forPath(this.nodePath, "".getBytes());
        }
        if (StrUtil.isBlank((CharSequence)(content = new String((byte[])client.getData().forPath(this.nodePath))))) {
            String error = MessageFormat.format("the node[{0}] value is empty", this.nodePath);
            throw new ParseException(error);
        }
        this.parse(content);
        final NodeCache cache = new NodeCache(client, this.nodePath);
        cache.start();
        cache.getListenable().addListener((Object)new NodeCacheListener(){

            public void nodeChanged() throws Exception {
                String content = new String(cache.getCurrentData().getData());
                LOG.info("stating load flow config....");
                ZookeeperJsonFlowParser.this.parse(content);
            }
        });
    }
}

