/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spring;

import com.yomahub.liteflow.aop.ICmpAroundAspect;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.util.LOGOPrinter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ComponentScanner
implements BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentScanner.class);
    public static Map<String, NodeComponent> nodeComponentMap = new HashMap<String, NodeComponent>();
    public static ICmpAroundAspect cmpAroundAspect;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (NodeComponent.class.isAssignableFrom(clazz)) {
            LOG.info("component[{}] has been found", (Object)beanName);
            NodeComponent nodeComponent = (NodeComponent)bean;
            nodeComponent.setNodeId(beanName);
            nodeComponent.setSelf(nodeComponent);
            nodeComponentMap.put(beanName, nodeComponent);
        }
        if (ICmpAroundAspect.class.isAssignableFrom(clazz)) {
            LOG.info("component aspect implement[{}] has been found", (Object)beanName);
            cmpAroundAspect = (ICmpAroundAspect)bean;
        }
        return bean;
    }

    public static void cleanCache() {
        nodeComponentMap.clear();
    }

    static {
        LOGOPrinter.print();
    }
}

