/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorHelper.class);

    private ExecutorHelper() {
    }

    public static void shutdownAwaitTermination(ExecutorService pool) {
        ExecutorHelper.shutdownAwaitTermination(pool, 60L);
    }

    public static void shutdownAwaitTermination(ExecutorService pool, long timeout) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    LOG.error("Pool did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadFactory buildExecutorFactory(String name) {
        return ExecutorHelper.buildExecutorFactory(name, false);
    }

    public static ThreadFactory buildExecutorFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){
            private final AtomicLong number = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = Executors.defaultThreadFactory().newThread(r);
                newThread.setName(name + "-" + this.number.getAndIncrement());
                newThread.setDaemon(daemon);
                return newThread;
            }
        };
    }

    public static ExecutorService buildExecutor(int worker, int queue, String namePrefix, boolean daemon) {
        return new ThreadPoolExecutor(worker, worker, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queue), ExecutorHelper.buildExecutorFactory(namePrefix, daemon), new ThreadPoolExecutor.AbortPolicy());
    }
}

