/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.springboot;

import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.springboot.LiteflowPropertyAutoConfiguration;
import com.yomahub.liteflow.util.ExecutorHelper;
import com.yomahub.liteflow.util.Shutdown;
import java.util.concurrent.ExecutorService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={LiteflowConfig.class})
@AutoConfigureAfter(value={LiteflowPropertyAutoConfiguration.class})
public class LiteflowExecutorAutoConfiguration {
    @Bean(value={"whenExecutors"})
    public ExecutorService executorService(LiteflowConfig liteflowConfig) {
        Integer useWorker = liteflowConfig.getWhenMaxWorkers();
        Integer useQueue = liteflowConfig.getWhenQueueLimit();
        return ExecutorHelper.buildExecutor((int)useWorker, (int)useQueue, (String)"liteflow-when-thead", (boolean)false);
    }

    @Bean
    public Shutdown shutdown() {
        return new Shutdown();
    }
}

