/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.springboot;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.springboot.LiteflowExecutorInit;
import com.yomahub.liteflow.springboot.LiteflowPropertyAutoConfiguration;
import com.yomahub.liteflow.util.SpringAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnBean(value={LiteflowConfig.class})
@AutoConfigureAfter(value={LiteflowPropertyAutoConfiguration.class})
@Import(value={SpringAware.class})
public class LiteflowMainAutoConfiguration {
    @Bean
    public FlowExecutor flowExecutor(LiteflowConfig liteflowConfig) {
        if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getRuleSource())) {
            FlowExecutor flowExecutor = new FlowExecutor();
            flowExecutor.setLiteflowConfig(liteflowConfig);
            return flowExecutor;
        }
        return null;
    }

    @Bean
    @ConditionalOnProperty(prefix="liteflow", name={"parse-on-start"}, havingValue="true")
    public LiteflowExecutorInit liteflowExecutorInit(FlowExecutor flowExecutor) {
        return new LiteflowExecutorInit(flowExecutor);
    }

    @Bean
    public MonitorBus monitorBus(LiteflowConfig liteflowConfig) {
        return new MonitorBus(liteflowConfig);
    }
}

