/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft;

import com.common.draft.model.Comparator;
import com.common.draft.model.FeadConditionUnitDo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Restrictions;

public class FeadComparator {
    private static final Logger logger = LogManager.getLogger(FeadComparator.class);

    public static Predicate parseCondition(FeadConditionUnitDo draftConditionDo, CriteriaBuilder builder, Root<?> root) {
        if (draftConditionDo == null) {
            return null;
        }
        Predicate predicate = null;
        switch (draftConditionDo.getComparator()) {
            case EQ: {
                predicate = builder.equal((Expression)root.get(draftConditionDo.getProperty()), draftConditionDo.getValue());
                break;
            }
            case GE: {
                if (!(draftConditionDo.getValue() instanceof Number)) break;
                predicate = builder.ge((Expression)root.get(draftConditionDo.getProperty()), (Number)draftConditionDo.getValue());
                break;
            }
            case GT: {
                if (!(draftConditionDo.getValue() instanceof Number)) break;
                predicate = builder.gt((Expression)root.get(draftConditionDo.getProperty()), (Number)draftConditionDo.getValue());
                break;
            }
            case IN: {
                CriteriaBuilder.In in = builder.in((Expression)root.get(draftConditionDo.getProperty()));
                Object value = draftConditionDo.getValue();
                if (value != null) {
                    if (value instanceof Array) {
                        Array[] values = (Array[])value;
                        if (values.length == 0) {
                            in = null;
                        } else {
                            for (Array v : values) {
                                in.value((Object)v);
                            }
                        }
                    } else if (value instanceof List || value instanceof ArrayList) {
                        ArrayList values = (ArrayList)value;
                        if (values.size() == 0) {
                            in = null;
                        } else {
                            for (Object v : values) {
                                in.value(v);
                            }
                        }
                    } else {
                        logger.error("[DraftData:parseCondition] Condition Error:" + value);
                    }
                } else {
                    in = null;
                }
                predicate = in;
                break;
            }
            case LE: {
                if (!(draftConditionDo.getValue() instanceof Number)) break;
                predicate = builder.le((Expression)root.get(draftConditionDo.getProperty()), (Number)draftConditionDo.getValue());
                break;
            }
            case LT: {
                if (!(draftConditionDo.getValue() instanceof Number)) break;
                predicate = builder.lt((Expression)root.get(draftConditionDo.getProperty()), (Number)draftConditionDo.getValue());
                break;
            }
            case NE: {
                predicate = builder.notEqual((Expression)root.get(draftConditionDo.getProperty()), draftConditionDo.getValue());
                break;
            }
            case LIKE: {
                if (!(draftConditionDo.getValue() instanceof String)) break;
                predicate = builder.like(builder.lower((Expression)root.get(draftConditionDo.getProperty())), ((String)draftConditionDo.getValue()).toLowerCase());
                break;
            }
            case IS_NULL: {
                predicate = builder.isNull((Expression)root.get(draftConditionDo.getProperty()));
                break;
            }
            case IS_NOT_NULL: {
                predicate = builder.isNotNull((Expression)root.get(draftConditionDo.getProperty()));
                break;
            }
            case IS_EMPTY: {
                predicate = builder.isEmpty((Expression)root.get(draftConditionDo.getProperty()));
                break;
            }
            case IS_NOT_EMPTY: {
                predicate = builder.isNotEmpty((Expression)root.get(draftConditionDo.getProperty()));
            }
        }
        if (predicate == null) {
            throw new IllegalArgumentException("filed type error! Property:" + draftConditionDo.getProperty());
        }
        return predicate;
    }

    public static String parseConditionStr(FeadConditionUnitDo draftConditionDo) {
        if (draftConditionDo == null) {
            return null;
        }
        String conditionStr = null;
        switch (draftConditionDo.getComparator()) {
            case EQ: {
                conditionStr = String.format(" %s= :%s", draftConditionDo.getProperty(), draftConditionDo.getProperty());
                break;
            }
            case GE: {
                if (!(draftConditionDo.getValue() instanceof Number)) break;
                conditionStr = String.format("%s >= :%s", draftConditionDo.getProperty(), draftConditionDo.getProperty());
                break;
            }
            case GT: {
                if (!(draftConditionDo.getValue() instanceof Number)) break;
                conditionStr = String.format("%s > :%s", draftConditionDo.getProperty(), draftConditionDo.getProperty());
                break;
            }
            case IN: {
                Object value = draftConditionDo.getValue();
                if (!(value instanceof List) && !(value instanceof ArrayList)) break;
                conditionStr = String.format("%s in :%s", draftConditionDo.getProperty(), draftConditionDo.getProperty());
                break;
            }
            case LE: {
                if (!(draftConditionDo.getValue() instanceof Number)) break;
                conditionStr = String.format("%s <= :%s", draftConditionDo.getProperty(), draftConditionDo.getProperty());
                break;
            }
            case LT: {
                if (!(draftConditionDo.getValue() instanceof Number)) break;
                conditionStr = String.format("%s < :%s", draftConditionDo.getProperty(), draftConditionDo.getProperty());
                break;
            }
            case NE: {
                conditionStr = String.format("%s!= :%s", draftConditionDo.getProperty(), draftConditionDo.getProperty());
                break;
            }
            case LIKE: {
                conditionStr = String.format("%s like :%s", draftConditionDo.getProperty(), draftConditionDo.getProperty());
                break;
            }
            case IS_NULL: {
                conditionStr = String.format("%s is null", draftConditionDo.getProperty());
                break;
            }
            case IS_NOT_NULL: {
                conditionStr = String.format("%s is not null", draftConditionDo.getProperty());
                break;
            }
            case IS_EMPTY: {
                conditionStr = String.format("%s is empty", draftConditionDo.getProperty());
                break;
            }
            case IS_NOT_EMPTY: {
                conditionStr = String.format("%s is not empty", draftConditionDo.getProperty());
            }
        }
        if (conditionStr == null) {
            throw new IllegalArgumentException("filed type error! Property:" + draftConditionDo.getProperty());
        }
        return conditionStr;
    }

    public static Junction parseDraftParams(FeadConditionUnitDo draftConditionDo, boolean bAnd, Junction junction) {
        if (junction == null) {
            junction = bAnd ? Restrictions.conjunction() : Restrictions.disjunction();
        }
        switch (draftConditionDo.getComparator()) {
            case EQ: {
                junction.add((Criterion)Restrictions.eq((String)draftConditionDo.getProperty(), (Object)draftConditionDo.getValue()));
                break;
            }
            case GE: {
                junction.add((Criterion)Restrictions.ge((String)draftConditionDo.getProperty(), (Object)draftConditionDo.getValue()));
                break;
            }
            case GT: {
                junction.add((Criterion)Restrictions.gt((String)draftConditionDo.getProperty(), (Object)draftConditionDo.getValue()));
                break;
            }
            case IN: {
                Object value = draftConditionDo.getValue();
                if (value instanceof Array) {
                    junction.add(Restrictions.in((String)draftConditionDo.getProperty(), (Object[])new Object[]{draftConditionDo.getValue()}));
                    break;
                }
                if (value instanceof List || value instanceof ArrayList) {
                    junction.add(Restrictions.in((String)draftConditionDo.getProperty(), (Object[])((List)draftConditionDo.getValue()).toArray()));
                    break;
                }
                System.out.println("Condition Error:" + value);
                break;
            }
            case LE: {
                junction.add((Criterion)Restrictions.le((String)draftConditionDo.getProperty(), (Object)draftConditionDo.getValue()));
                break;
            }
            case LT: {
                junction.add((Criterion)Restrictions.lt((String)draftConditionDo.getProperty(), (Object)draftConditionDo.getValue()));
                break;
            }
            case NE: {
                junction.add((Criterion)Restrictions.ne((String)draftConditionDo.getProperty(), (Object)draftConditionDo.getValue()));
                break;
            }
            case IS_NULL: {
                junction.add(Restrictions.isNull((String)draftConditionDo.getProperty()));
                break;
            }
            case IS_NOT_NULL: {
                junction.add(Restrictions.isNotNull((String)draftConditionDo.getProperty()));
                break;
            }
            case IS_EMPTY: {
                junction.add(Restrictions.isEmpty((String)draftConditionDo.getProperty()));
                break;
            }
            case IS_NOT_EMPTY: {
                junction.add(Restrictions.isNotEmpty((String)draftConditionDo.getProperty()));
            }
        }
        return junction;
    }

    public static boolean compareValue(Object a, Object b, Comparator comparator) {
        boolean result = false;
        switch (comparator) {
            case EQ: {
                result = FeadComparator.compareEq(a, b);
                break;
            }
            case GE: {
                result = FeadComparator.compareGe(a, b);
                break;
            }
            case GT: {
                result = FeadComparator.compareGt(a, b);
                break;
            }
            case IN: {
                result = FeadComparator.compareIn(a, (List)b);
                break;
            }
            case LE: {
                result = FeadComparator.compareLe(a, b);
                break;
            }
            case LT: {
                result = FeadComparator.compareLt(a, b);
                break;
            }
            case NE: {
                result = FeadComparator.compareNe(a, b);
                break;
            }
            case IS_NULL: {
                result = FeadComparator.compareIsNull(a);
                break;
            }
            case IS_NOT_NULL: {
                result = FeadComparator.compareIsNotNull(a);
                break;
            }
            case IS_EMPTY: {
                result = FeadComparator.compareIsEmpty(a);
                break;
            }
            case IS_NOT_EMPTY: {
                result = FeadComparator.compareIsNotEmpty(a);
            }
        }
        return result;
    }

    public static <T> boolean compareEq(T a, T b) {
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static <T> boolean compareNe(T a, T b) {
        if (a == null || b == null) {
            return false;
        }
        return !a.equals(b);
    }

    public static <T> boolean compareGt(T a, T b) {
        if (a == null || b == null || a.getClass() != b.getClass()) {
            return false;
        }
        if (a instanceof Integer) {
            return Integer.compare((Integer)a, (Integer)b) > 0;
        }
        if (a instanceof Long) {
            return Long.compare((Long)a, (Long)b) > 0;
        }
        if (a instanceof Float) {
            return Float.compare(((Float)a).floatValue(), ((Float)b).floatValue()) > 0;
        }
        if (a instanceof Double) {
            return Double.compare((Double)a, (Double)b) > 0;
        }
        if (a instanceof String) {
            return ((String)a).compareTo((String)b) > 0;
        }
        return false;
    }

    public static <T> boolean compareGe(T a, T b) {
        if (a == null || b == null || a.getClass() != b.getClass()) {
            return false;
        }
        if (a instanceof Integer) {
            return Integer.compare((Integer)a, (Integer)b) >= 0;
        }
        if (a instanceof Long) {
            return Long.compare((Long)a, (Long)b) >= 0;
        }
        if (a instanceof Float) {
            return Float.compare(((Float)a).floatValue(), ((Float)b).floatValue()) >= 0;
        }
        if (a instanceof Double) {
            return Double.compare((Double)a, (Double)b) >= 0;
        }
        if (a instanceof String) {
            return ((String)a).compareTo((String)b) >= 0;
        }
        return false;
    }

    public static <T> boolean compareLt(T a, T b) {
        if (a == null || b == null || a.getClass() != b.getClass()) {
            return false;
        }
        if (a instanceof Integer) {
            return Integer.compare((Integer)a, (Integer)b) < 0;
        }
        if (a instanceof Long) {
            return Long.compare((Long)a, (Long)b) < 0;
        }
        if (a instanceof Float) {
            return Float.compare(((Float)a).floatValue(), ((Float)b).floatValue()) < 0;
        }
        if (a instanceof Double) {
            return Double.compare((Double)a, (Double)b) < 0;
        }
        if (a instanceof String) {
            return ((String)a).compareTo((String)b) < 0;
        }
        return false;
    }

    public static <T> boolean compareLe(T a, T b) {
        if (a == null || b == null || a.getClass() != b.getClass()) {
            return false;
        }
        if (a instanceof Integer) {
            return Integer.compare((Integer)a, (Integer)b) <= 0;
        }
        if (a instanceof Long) {
            return Long.compare((Long)a, (Long)b) <= 0;
        }
        if (a instanceof Float) {
            return Float.compare(((Float)a).floatValue(), ((Float)b).floatValue()) <= 0;
        }
        if (a instanceof Double) {
            return Double.compare((Double)a, (Double)b) <= 0;
        }
        if (a instanceof String) {
            return ((String)a).compareTo((String)b) <= 0;
        }
        return false;
    }

    public static <T> boolean compareIsNull(T a) {
        return a == null;
    }

    public static <T> boolean compareIsNotNull(T a) {
        return a != null;
    }

    public static <T> boolean compareIsEmpty(T a) {
        return a == null;
    }

    public static <T> boolean compareIsNotEmpty(T a) {
        return a != null;
    }

    public static <T> boolean compareIn(T a, List<T> b) {
        boolean bIn = false;
        for (T x : b) {
            if (!a.equals(x)) continue;
            bIn = true;
            break;
        }
        return bIn;
    }
}

