package com.common.draft.model;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


public class FeadConditionDo implements Serializable {

    private static final long serialVersionUID = 0L;

    public FeadConditionDo(){}

    public FeadConditionDo(Class<?> classType){
        this.classType = classType;
    }

    public FeadConditionDo(Class<?> classType, String flag){
        this.classType = classType;
    }

    public FeadConditionDo addAnd(Comparator comparator, String property, Object value){
        if(Comparator.IN == comparator){
            if(value == null){
                return this;
            }
            if (value instanceof Array) {
                Array [] values = (Array []) value;
                if(values.length == 0){
                    return this;
                }
            }else if(value instanceof ArrayList || value instanceof List){
                ArrayList<Object> values = (ArrayList<Object>) value;
                if(values.size() == 0){
                    return this;
                }
            }else if(value.getClass().isArray()){
                Object[] values = (Object[]) value;
                if(values.length == 0){
                    return this;
                }
            }
        }
        if(andCondition == null){
            andCondition = new ArrayList<FeadConditionUnitDo>();
        }
        andCondition.add(new FeadConditionUnitDo(comparator,property,value));
        return this;
    }

    public FeadConditionDo addOr(Comparator comparator, String property, Object value){
        if(orCondition == null){
            orCondition = new ArrayList<FeadConditionUnitDo>();
        }
        orCondition.add(new FeadConditionUnitDo(comparator,property,value));
        return this;
    }

    public FeadConditionDo orderBy(String property,FeadSort feadSort){
        if(orderBy == null){
            orderBy = new HashMap<String,FeadSort>();
        }
        orderBy.put(property,feadSort);
        return this;
    }

    public FeadConditionDo groupBy(String property){
        if(groupBy == null){
            groupBy = new ArrayList<String>();
        }
        groupBy.add(property);
        return this;
    }

    public Class getClassType(){
        return classType;
    }

    public void setClassType(Class<?> classType) {
        this.classType = classType;
    }

    public List<FeadConditionUnitDo> getAndCondition(){
        return andCondition;
    }

    public List<FeadConditionUnitDo> getOrCondition(){
        return orCondition;
    }

    public HashMap<String,FeadSort> getOrderBy(){
        return orderBy;
    }

    public List<String> getGroupBy(){
        return groupBy;
    }


    private Class classType;

    private List<String> groupBy;  //分组统计字段

    private HashMap<String,FeadSort> orderBy;

    private List<FeadConditionUnitDo> andCondition;

    private List<FeadConditionUnitDo> orCondition;

}
