/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft.dao;

import com.common.draft.dao.BaseDao;
import com.common.draft.model.Comparator;
import com.common.draft.model.CurdType;
import com.common.draft.model.FeadConditionDo;
import com.common.draft.model.FeadPageDo;
import com.common.draft.model.ddo.FeadHistoryDdo;
import com.common.draft.model.ddo.FeadLogDdo;
import com.common.draft.utils.FeadUtil;
import java.util.List;
import javax.persistence.NoResultException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class FeadDao
extends BaseDao {
    private static final Logger logger = LogManager.getLogger(FeadDao.class);

    @Autowired
    public FeadDao(@Qualifier(value="feadSessionFactory") SessionFactory _sessionFactory) {
        super(_sessionFactory);
    }

    public List<FeadLogDdo> queryDraftLog(int categoryType, long categoryValue, String tableName, CurdType curdType) {
        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        draftConditionDo.addAnd(Comparator.EQ, "categoryType", categoryType).addAnd(Comparator.EQ, "categoryValue", categoryValue).addAnd(Comparator.EQ, "tableName", tableName).addAnd(Comparator.EQ, "curdType", curdType.ordinal()).addAnd(Comparator.EQ, "version", 0L);
        List<FeadLogDdo> draftResults = this.queryListByPage(draftConditionDo, 1, 9999);
        return draftResults;
    }

    public FeadPageDo queryDraftLog(int categoryType, long categoryValue, String tableName, int pageId, int pageSize) {
        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        draftConditionDo.addAnd(Comparator.EQ, "categoryType", categoryType).addAnd(Comparator.EQ, "categoryValue", categoryValue).addAnd(Comparator.EQ, "tableName", tableName).addAnd(Comparator.EQ, "version", 0L);
        List<?> draftResults = this.queryListByPage(draftConditionDo, pageId, pageSize);
        long recordCount = this.getCount(draftConditionDo);
        return new FeadPageDo(draftResults, pageId, pageSize, recordCount);
    }

    public void updateDraftLogVersion(int categoryType, long categoryValue, String tableName, long version) {
        String hql = "update from FeadLogDdo set version = :version where categoryType = :categoryType and categoryValue = :categoryValue ";
        if (!FeadUtil.isEmpty(tableName)) {
            hql = hql + " and tableName = :tableName";
        }
        Query query = this.getSession().createQuery(hql);
        query.setParameter("version", (Object)version);
        query.setParameter("categoryType", (Object)categoryType);
        query.setParameter("categoryValue", (Object)categoryValue);
        if (!FeadUtil.isEmpty(tableName)) {
            query.setParameter("tableName", (Object)tableName);
        }
        query.executeUpdate();
    }

    public void clearDraftLog(int categoryType, long categoryValue, String tableName) {
        String hql = "delete from FeadLogDdo where categoryType = :categoryType and categoryValue = :categoryValue ";
        if (!FeadUtil.isEmpty(tableName)) {
            hql = hql + " and tableName = :tableName";
        }
        Query query = this.getSession().createQuery(hql);
        query.setParameter("categoryType", (Object)categoryType);
        query.setParameter("categoryValue", (Object)categoryValue);
        if (!FeadUtil.isEmpty(tableName)) {
            query.setParameter("tableName", (Object)tableName);
        }
        query.executeUpdate();
    }

    public void clearDraftLogWithExclude(int categoryType, long categoryValue, List<String> excludeTableName) {
        String hql = "delete from FeadLogDdo where categoryType = :categoryType and categoryValue = :categoryValue ";
        if (!FeadUtil.isEmpty(excludeTableName)) {
            hql = hql + " and tableName not in :tableName";
        }
        Query query = this.getSession().createQuery(hql);
        query.setParameter("categoryType", (Object)categoryType);
        query.setParameter("categoryValue", (Object)categoryValue);
        if (!FeadUtil.isEmpty(excludeTableName)) {
            query.setParameter("tableName", excludeTableName);
        }
        query.executeUpdate();
    }

    public long countDraftLog(int categoryType, long categoryValue, String tableName) {
        String hql = "select count(1) from FeadLogDdo where categoryType = :categoryType and categoryValue = :categoryValue and version = :version";
        if (!FeadUtil.isEmpty(tableName)) {
            hql = hql + " and tableName = :tableName";
        }
        Query query = this.getSession().createQuery(hql);
        query.setParameter("categoryType", (Object)categoryType);
        query.setParameter("categoryValue", (Object)categoryValue);
        query.setParameter("version", (Object)0L);
        if (!FeadUtil.isEmpty(tableName)) {
            query.setParameter("tableName", (Object)tableName);
        }
        Long count = null;
        try {
            count = (Long)query.getSingleResult();
        }
        catch (NoResultException e) {
            logger.debug("[FeadData->countDraftLog] result empty");
        }
        if (count == null) {
            return 0L;
        }
        return count;
    }

    public List<FeadLogDdo> queryDraftLog(int categoryType, long categoryValue, String tableName, long version) {
        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        draftConditionDo.addAnd(Comparator.EQ, "categoryType", categoryType).addAnd(Comparator.EQ, "categoryValue", categoryValue).addAnd(Comparator.EQ, "version", version);
        if (!FeadUtil.isEmpty(tableName)) {
            draftConditionDo.addAnd(Comparator.EQ, "tableName", tableName);
        }
        List<FeadLogDdo> draftResults = this.queryListByPage(draftConditionDo, 1, 9999);
        return draftResults;
    }

    public FeadLogDdo queryDraftLog(String tableName, Long primaryValue) {
        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        if (StringHelper.isEmpty((String)tableName)) {
            return null;
        }
        if (primaryValue != null) {
            draftConditionDo.addAnd(Comparator.EQ, "primaryValue", primaryValue);
        }
        draftConditionDo.addAnd(Comparator.EQ, "tableName", tableName).addAnd(Comparator.EQ, "version", 0L);
        FeadLogDdo draftResults = (FeadLogDdo)this.querySingle(draftConditionDo);
        return draftResults;
    }

    public List<FeadLogDdo> queryDraftByVersion(String tableName, long version) {
        if (version < 0L) {
            return null;
        }
        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        draftConditionDo.addAnd(Comparator.EQ, "version", version);
        if (!FeadUtil.isEmpty(tableName)) {
            draftConditionDo.addAnd(Comparator.EQ, "tableName", tableName);
        }
        List<FeadLogDdo> draftResults = this.queryListByPage(draftConditionDo, 1, 9999);
        return draftResults;
    }

    public void updateDraftLog(FeadLogDdo draftLogDdo) {
        this.update(draftLogDdo);
    }

    public void deleteDraftLog(FeadLogDdo draftLogDdo) {
        this.delete(draftLogDdo);
    }

    public List<FeadHistoryDdo> queryHistoryData(int categoryType, long categoryValue, long version, String tableName) {
        FeadConditionDo feadConditionDo = new FeadConditionDo(FeadHistoryDdo.class).addAnd(Comparator.EQ, "categoryType", categoryType).addAnd(Comparator.EQ, "categoryValue", categoryValue).addAnd(Comparator.EQ, "version", version);
        if (!FeadUtil.isEmpty(tableName)) {
            feadConditionDo.addAnd(Comparator.EQ, "tableName", tableName);
        }
        return this.queryListByPage(feadConditionDo, 1, 9999);
    }

    public void updateHistoryData(List<FeadHistoryDdo> datas) {
        this.update(datas);
    }
}

