/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.persistence.Table;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeadUtil {
    private static final Logger logger = LogManager.getLogger(FeadUtil.class);

    public static String getTableNameByClass(Class<?> classType) {
        Table table = classType.getAnnotation(Table.class);
        if (table == null) {
            return null;
        }
        return table.name();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isEmpty(String[] string) {
        return string == null || string.length == 0;
    }

    public static boolean isEmpty(List<?> list) {
        if (list == null) {
            return true;
        }
        return list.isEmpty();
    }

    public static Object getFieldValueByName(String fieldName, Object o) {
        Field field = null;
        try {
            field = o.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Exception e) {
            logger.error("Can't find fieldName:{},{}", (Object)fieldName, o, (Object)e);
            return null;
        }
        Class<?> zClass = o.getClass();
        for (int count = 0; field == null && count < 3; ++count) {
            zClass = zClass.getSuperclass();
            try {
                field = zClass.getDeclaredField(fieldName);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (Exception e) {
                logger.error("Can't find fieldName:{},{}", (Object)fieldName, o, (Object)e);
                return null;
            }
        }
        if (field == null) {
            return null;
        }
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get";
            if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                getter = "is";
            }
            getter = getter + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean setFieldValueByName(String fieldName, Object value, Object o) {
        Field field = null;
        try {
            field = o.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Exception e) {
            logger.error("Can't find fieldName:{},{}", (Object)fieldName, o, (Object)e);
            return false;
        }
        Class<?> zClass = o.getClass();
        for (int count = 0; field == null && count < 3; ++count) {
            zClass = zClass.getSuperclass();
            try {
                field = zClass.getDeclaredField(fieldName);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (Exception e) {
                logger.error("Can't find fieldName:{},{}", (Object)fieldName, o, (Object)e);
                return false;
            }
        }
        if (field == null) {
            return false;
        }
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "set" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, field.getType());
            method.invoke(o, value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Object callMethodByName(String methodName, Object o) {
        try {
            Method method = o.getClass().getMethod(methodName, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String md5hex(String data) {
        if (data == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(data.getBytes());
            return Hex.encodeHexString((byte[])messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5hex(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(data);
            return Hex.encodeHexString((byte[])messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFormatDateHourString(Long timeStamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(timeStamp);
    }

    public static String md5hex16(String data) {
        String md5 = FeadUtil.md5hex(data);
        if (md5 != null) {
            return md5.substring(8, 24);
        }
        return md5;
    }
}

