package com.common.draft;

import com.common.draft.model.*;
import common.config.tools.config.ConfigTools3;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

import java.util.List;

public interface FeadData {

    /**
     * update Manager Common data
     *
     * @param draftData
     **/
    void update(FeadBase draftData);

    /**
     * batch update Manager Common data
     *
     * @param draftData
     **/
    <T> void update(Iterable<T> draftData);

    /**
     * update DRAFT or BUSINESS data
     *
     * @param flag      业务分库标识
     * @param draftData
     **/
    @Deprecated
    void update(String flag, FeadBase draftData);

    /**
     * update DRAFT or BUSINESS data
     *
     * @param flag       业务分库标识
     * @param draftDatas
     **/
    @Deprecated
    <T> void update(String flag, Iterable<T> draftDatas);


    /**
     * read  data by list
     *
     * @param draftConditionDo
     **/
    <T> List<T> query(FeadConditionDo draftConditionDo);

    /**
     * read  data by page
     *
     * @param draftConditionDo
     * @param pageSize
     * @param pageIndex
     **/
    <T> FeadPageDo<T> query(FeadConditionDo draftConditionDo, int pageSize, int pageIndex);

    /**
     * read single data
     * <p>
     * 如果返回结果不唯一则抛出异常 可查询多个用户的编辑数据
     *
     * @param draftConditionDo
     **/
    <T> T querySingle(FeadConditionDo draftConditionDo);

    /**
     * read single manager data
     * <p>
     * 如果返回结果不唯一则抛出异常
     *
     * @param id
     * @param zClass
     **/
    <T> T queryById(long id, Class zClass);

    /**
     * read single business data
     * <p>
     * 如果返回结果不唯一则抛出异常
     *
     * @param id
     * @param zClass
     * @param flag
     **/
    @Deprecated
    <T> T queryById(long id, Class zClass, String flag);

    /**
     * get total number of record by given condition
     * <p>
     * 如果返回结果不唯一则抛出异常
     *
     * @param draftConditionDo
     **/
    long count(FeadConditionDo draftConditionDo);

    /**
     * delete manager data
     *
     * @param draftData
     **/
    void delete(FeadBase draftData);

    /**
     * delete manager data
     *
     * @param id
     **/
    void deleteById(Class classType, long id);

    /**
     * batch delete manager data
     *
     * @param classType
     * @param ids
     **/
    void deleteAll(Class classType, List<Long> ids);

    /**
     * batch delete manager data
     *
     * @param datas
     **/
    public <T> void deleteAll(Iterable<T> datas);


    /**
     * delete data by condition
     *
     * @param draftConditionDo
     **/
    void delete(FeadConditionDo draftConditionDo);


    /**
     * delete BUSINESS data
     *
     * @param flag
     * @param classType
     * @param id
     **/
    @Deprecated
    void deleteById(String flag, Class classType, long id);

    /**
     * delete BUSINESS data
     *
     * @param flag 业务分库标识
     * @param ids
     **/
    @Deprecated
    void deleteAll(String flag, Class classType, List<Long> ids);

    /**
     * delete DRAFT data
     *
     * @param flag
     * @param classType
     * @param id
     **/
    @Deprecated
    void deleteById(String flag, int categoryType, long categoryValue, Class classType, long id);

    /**
     * delete DRAFT data
     *
     * @param flag 业务分库标识
     * @param ids
     **/
    @Deprecated
    void deleteAll(String flag, int categoryType, long categoryValue, Class classType, List<Long> ids);

    /**
     * delete DRAFT data by condition
     *
     * @param draftConditionDo
     **/
    @Deprecated
    void delete(int categoryType, long categoryValue, FeadConditionDo draftConditionDo);


    /**
     * delete DRAFT or BUSINESS data
     *
     * @param flag      业务分库标识
     * @param draftData
     **/
    @Deprecated
    void delete(String flag, FeadBase draftData);

    /**
     * batch delete DRAFT or BUSINESS data
     *
     * @param flag
     * @param datas
     **/
    @Deprecated
    <T> void deleteAll(String flag, Iterable<T> datas);


    /****
     *
     * 查询编辑记录
     *
     * ***********/

    <T> List<T> queryAdd(Class classType, FeadCategory feadCategory);

    <T> List<T> queryUpdate(Class classType, FeadCategory feadCategory);

    List<Long> queryDelete(Class classType, FeadCategory feadCategory);


    List<Long> queryAddIds(Class classType, FeadCategory feadCategory);

    List<Long> queryUpdateIds(Class classType, FeadCategory feadCategory);


    FeadPageDo queryModifyIds(Class classType, FeadCategory feadCategory, int pageId, int pageSize);

    List<FeadPrimaryValue> queryModifyIds(Class classType, FeadCategory feadCategory);


    /**
     * 业务编辑记录数
     *
     * @param classType
     * @param feadCategory
     * @return count of draft record
     **/
    long feadRecordCount(FeadCategory feadCategory, Class classType);

    /**
     * 业务编辑记录数
     *
     * @param feadCategory
     * @return count of draft record
     **/
    long feadRecordCount(FeadCategory feadCategory);

    /**
     * 清空业务编辑记录
     *
     * @param feadCategory
     * @param excludeClass
     * @return
     **/
    void clearEditRecord(FeadCategory feadCategory ,Class... excludeClass);

    /**
     * 业务编辑记录查询
     *
     * @param classType
     * @param classType
     * @return draft record info
     **/
    List<FeadRecordDo> feadRecord(FeadCategory feadCategory,Class classType);

    /**
     * 业务编辑记录数查询
     *
     * @param feadCategory
     * @return draft record info
     **/
    List<FeadRecordDo> feadRecord(FeadCategory feadCategory);


    /**
     * 业务数据发布成功通知
     *
     * @param classType
     * @param feadCategory
     **/
    void releaseSuccess(FeadCategory feadCategory, Class classType);

    /**
     * 业务数据发布成功通知
     *
     * @param feadCategory
     **/
    void releaseSuccess(FeadCategory feadCategory);

    /**
     * 业务回滚数据操作
     *
     * @param data
     * @param curdType
     **/
    <T> void rollbackData(List<T> data, CurdType curdType);


    /***
     * 获取 SessionFactory
     *
     * **/
    SessionFactory getSessionFactory();

    /***
     * 获取 Session
     *
     * **/
    Session getSession();

}
