/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft;

import com.common.draft.FeadBase;
import com.common.draft.FeadData;
import com.common.draft.FeadException;
import com.common.draft.FeadTableManager;
import com.common.draft.config.FeadBeanConfig;
import com.common.draft.dao.FeadDao;
import com.common.draft.model.Comparator;
import com.common.draft.model.CurdType;
import com.common.draft.model.DataType;
import com.common.draft.model.FeadCategory;
import com.common.draft.model.FeadConditionDo;
import com.common.draft.model.FeadPageDo;
import com.common.draft.model.FeadPrimaryValue;
import com.common.draft.model.FeadRecordDo;
import com.common.draft.model.ddo.FeadHistoryDdo;
import com.common.draft.model.ddo.FeadLogDdo;
import com.common.draft.utils.FeadUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class FeadDataImpl
implements FeadData {
    private static final Logger logger = LogManager.getLogger(FeadDataImpl.class);
    @Autowired
    private FeadDao mFeadDao;
    @Autowired
    private FeadTableManager mTableManager;
    @Autowired
    FeadBeanConfig config;

    @Override
    public SessionFactory getSessionFactory() {
        return this.mFeadDao.getSessionFactory();
    }

    @Override
    public Session getSession() {
        return this.mFeadDao.getSession();
    }

    @Override
    public void update(FeadBase draftData) {
        if (draftData == null) {
            logger.error("update draftData param is null");
            throw new IllegalArgumentException("update draftData param is null");
        }
        if (this.config.getUseCache() && draftData.dataType() == DataType.DRAFT_BUSINESS) {
            String tableName = this.mTableManager.getMappingTableName(draftData.getClass());
            Long primaryValue = this.getPrimaryValue(draftData);
            if (primaryValue != null) {
                FeadLogDdo draftLogDdo = this.mFeadDao.queryDraftLog(tableName, primaryValue);
                if (draftLogDdo != null) {
                    if (draftLogDdo.getCurdType() == CurdType.DELETE.ordinal()) {
                        throw new FeadException("[FeadData->update] draft log curd type error");
                    }
                } else {
                    FeadLogDdo feadLogDdo = this.genDraftLog(draftData.categoryType(), draftData.categoryValue(), tableName, CurdType.UPDATE, primaryValue);
                    this.mFeadDao.updateDraftLog(feadLogDdo);
                }
                this.mFeadDao.update(draftData);
            } else {
                this.mFeadDao.update(draftData);
                primaryValue = this.getPrimaryValue(draftData);
                if (primaryValue == null) {
                    throw new FeadException("[FeadData->update] draft log read primaryValue error");
                }
                long categoryValue = draftData.categoryValue();
                if (categoryValue == 0L) {
                    categoryValue = primaryValue;
                }
                this.mFeadDao.updateDraftLog(this.genDraftLog(draftData.categoryType(), categoryValue, tableName, CurdType.ADD, primaryValue));
            }
        } else {
            this.mFeadDao.update(draftData);
        }
    }

    @Override
    public <T> void update(Iterable<T> draftDatas) {
        if (draftDatas == null) {
            logger.error("update draftData param is null");
            throw new IllegalArgumentException("update FeadData param is null");
        }
        String tableName = "";
        for (FeadBase draftData : draftDatas) {
            if (!this.config.getUseCache() || draftData.dataType() == DataType.MANAGER) {
                this.mFeadDao.update(draftData);
                continue;
            }
            tableName = this.mTableManager.getMappingTableName(draftData.getClass());
            Long primaryValue = this.getPrimaryValue(draftData);
            if (primaryValue != null) {
                FeadLogDdo draftLogDdo = this.mFeadDao.queryDraftLog(tableName, primaryValue);
                if (draftLogDdo != null) {
                    if (draftLogDdo.getCurdType() == CurdType.DELETE.ordinal()) {
                        throw new FeadException("[FeadData->update] draft log curd type error");
                    }
                } else {
                    this.mFeadDao.updateDraftLog(this.genDraftLog(draftData.categoryType(), draftData.categoryValue(), tableName, CurdType.UPDATE, primaryValue));
                }
                this.mFeadDao.update(draftData);
                continue;
            }
            this.mFeadDao.update(draftData);
            primaryValue = this.getPrimaryValue(draftData);
            if (primaryValue == null) {
                throw new FeadException("[FeadData->update] draft log read primaryValue error");
            }
            long categoryValue = draftData.categoryValue();
            if (categoryValue == 0L) {
                categoryValue = primaryValue;
            }
            this.mFeadDao.updateDraftLog(this.genDraftLog(draftData.categoryType(), categoryValue, tableName, CurdType.ADD, primaryValue));
        }
    }

    @Override
    public void update(String flag, FeadBase draftData) {
        this.update(draftData);
    }

    @Override
    public <T> void update(String flag, Iterable<T> draftDatas) {
        this.update(draftDatas);
    }

    private FeadLogDdo genDraftLog(int categoryType, long categoryValue, String tableName, CurdType curdType, long primaryValue) {
        long version = 0L;
        FeadLogDdo draftLogDdo = new FeadLogDdo();
        draftLogDdo.setVersion(version);
        draftLogDdo.setCategoryType(categoryType);
        draftLogDdo.setCategoryValue(categoryValue);
        draftLogDdo.setTableName(tableName);
        draftLogDdo.setCurdType(curdType.ordinal());
        draftLogDdo.setPrimaryValue(primaryValue);
        return draftLogDdo;
    }

    @Override
    public void delete(FeadBase draftData) {
        if (draftData == null) {
            logger.error("[DraftData->delete]delete draftData param is null");
            throw new IllegalArgumentException("delete draftData param is null");
        }
        if (this.config.getUseCache() && draftData.dataType() == DataType.DRAFT_BUSINESS) {
            Long primaryValue = this.getPrimaryValue(draftData);
            this.deleteDraftLog(draftData.categoryType(), draftData.categoryValue(), draftData.getClass(), primaryValue);
        }
        this.mFeadDao.delete(draftData);
    }

    @Override
    public void deleteById(Class classType, long id) {
        this.checkClassType(classType);
        String primaryKey = this.mTableManager.getMappingPrimaryKey(classType);
        FeadConditionDo draftConditionDo = new FeadConditionDo(classType);
        draftConditionDo.addAnd(Comparator.EQ, primaryKey, id);
        FeadBase data = (FeadBase)this.mFeadDao.querySingle(draftConditionDo);
        if (data == null) {
            return;
        }
        DataType dataType = this.mTableManager.getClassDataType(classType);
        if (this.config.getUseCache() && dataType == DataType.DRAFT_BUSINESS) {
            this.deleteDraftLog(data.categoryType(), data.categoryValue(), classType, id);
        }
        this.mFeadDao.delete(data);
    }

    @Override
    public void deleteAll(Class classType, List<Long> ids) {
        if (ids == null) {
            logger.error("[DraftData->delete]delete draftData param is null");
            throw new IllegalArgumentException("delete draftData param is null");
        }
        this.checkClassType(classType);
        for (Long id : ids) {
            this.deleteById(classType, id);
        }
    }

    @Override
    public <T> void deleteAll(Iterable<T> datas) {
        if (datas == null) {
            logger.error("[DraftData->delete]delete draftData param is null");
            throw new IllegalArgumentException("delete draftData param is null");
        }
        for (T data : datas) {
            this.deleteBase((FeadBase)data);
        }
    }

    @Override
    public void deleteById(String flag, int categoryType, long categoryValue, Class classType, long id) {
        this.checkClassType(classType);
        this.deleteById(classType, id);
    }

    @Override
    public void deleteAll(String flag, int categoryType, long categoryValue, Class classType, List<Long> ids) {
        this.checkClassType(classType);
        for (Long id : ids) {
            this.deleteById(flag, categoryType, categoryValue, classType, id);
        }
    }

    @Override
    public void delete(int categoryType, long categoryValue, FeadConditionDo draftConditionDo) {
        this.checkCondition(draftConditionDo);
        List draftBases = this.query(draftConditionDo);
        if (draftBases == null || draftBases.isEmpty()) {
            return;
        }
        for (FeadBase draftBase : draftBases) {
            this.checkDataType(draftBase.dataType(), DataType.DRAFT_BUSINESS, true);
            this.deleteBase(draftBase);
        }
    }

    @Override
    public void deleteById(String flag, Class classType, long id) {
        this.checkClassType(classType);
        this.deleteById(classType, id);
    }

    @Override
    public void deleteAll(String flag, Class classType, List<Long> ids) {
        this.checkClassType(classType);
        for (Long id : ids) {
            this.deleteById(classType, id);
        }
    }

    @Override
    public void delete(FeadConditionDo draftConditionDo) {
        this.checkCondition(draftConditionDo);
        this.checkClassType(draftConditionDo.getClassType());
        List draftBases = this.queryBase(draftConditionDo);
        if (draftBases == null || draftBases.isEmpty()) {
            return;
        }
        for (FeadBase draftBase : draftBases) {
            this.deleteBase(draftBase);
        }
    }

    @Override
    public void delete(String flag, FeadBase draftData) {
        if (draftData == null) {
            logger.error("[DraftData->delete] delete draftData param is null");
            throw new IllegalArgumentException("delete draftData param is null");
        }
        this.deleteBase(draftData);
    }

    @Override
    public <T> void deleteAll(String flag, Iterable<T> datas) {
        if (datas == null) {
            logger.error("[DraftData->delete]delete draftData param is null");
            throw new IllegalArgumentException("delete draftData param is null");
        }
        for (FeadBase draftData : datas) {
            this.deleteBase(draftData);
        }
    }

    private void deleteBase(FeadBase draftData) {
        if (this.config.getUseCache() && draftData.dataType() == DataType.DRAFT_BUSINESS) {
            Long primaryValue = this.getPrimaryValue(draftData);
            this.deleteDraftLog(draftData.categoryType(), draftData.categoryValue(), draftData.getClass(), primaryValue);
        }
        this.mFeadDao.delete(draftData);
    }

    private void deleteDraftLog(int categoryType, long categoryValue, Class zClass, long id) {
        String tableName = this.mTableManager.getMappingTableName(zClass);
        FeadLogDdo draftLogDdo = this.mFeadDao.queryDraftLog(tableName, id);
        if (draftLogDdo != null) {
            if (draftLogDdo.getCurdType() == CurdType.ADD.ordinal()) {
                this.mFeadDao.deleteDraftLog(draftLogDdo);
            } else if (draftLogDdo.getCurdType() == CurdType.UPDATE.ordinal()) {
                draftLogDdo.setCurdType(CurdType.DELETE.ordinal());
                this.mFeadDao.updateDraftLog(draftLogDdo);
            }
        } else {
            this.mFeadDao.updateDraftLog(this.genDraftLog(categoryType, categoryValue, tableName, CurdType.DELETE, id));
        }
    }

    @Override
    public <T> List<T> query(FeadConditionDo draftConditionDo) {
        FeadPageDo<T> draftPageDo = this.queryBase(draftConditionDo, 9999, 1);
        return draftPageDo.getData();
    }

    @Override
    public <T> FeadPageDo<T> query(FeadConditionDo draftConditionDo, int pageSize, int pageIndex) {
        return this.queryBase(draftConditionDo, pageSize, pageIndex);
    }

    @Override
    public <T> T querySingle(FeadConditionDo feadConditionDo) {
        this.checkCondition(feadConditionDo);
        String tableNamne = this.mTableManager.getMappingTableName(feadConditionDo.getClassType());
        Object data = this.mFeadDao.querySingle(feadConditionDo);
        this.setPublishStatus(data, tableNamne);
        return (T)data;
    }

    @Override
    public <T> T queryById(long id, Class zClass) {
        this.checkClassType(zClass);
        String primaryKey = this.mTableManager.getMappingPrimaryKey(zClass);
        String tableNamne = this.mTableManager.getMappingTableName(zClass);
        FeadConditionDo feadConditionDo = new FeadConditionDo(zClass);
        feadConditionDo.addAnd(Comparator.EQ, primaryKey, id);
        Object data = this.mFeadDao.querySingle(feadConditionDo);
        this.setPublishStatus(data, tableNamne);
        return (T)data;
    }

    @Override
    public <T> T queryById(long id, Class zClass, String flag) {
        this.checkClassType(zClass);
        return this.queryByIdBase(id, zClass);
    }

    private <T> T queryByIdBase(long id, Class zClass) {
        String primaryKey = this.mTableManager.getMappingPrimaryKey(zClass);
        String tableNamne = this.mTableManager.getMappingTableName(zClass);
        FeadConditionDo feadConditionDo = new FeadConditionDo(zClass);
        feadConditionDo.addAnd(Comparator.EQ, primaryKey, id);
        Object data = this.mFeadDao.querySingle(feadConditionDo);
        this.setPublishStatus(data, tableNamne);
        return (T)data;
    }

    @Override
    public long count(FeadConditionDo feadConditionDo) {
        return this.mFeadDao.getCount(feadConditionDo);
    }

    public <T> FeadPageDo<T> queryBase(FeadConditionDo feadConditionDo, int pageSize, int pageIndex) {
        this.checkCondition(feadConditionDo);
        Class classType = feadConditionDo.getClassType();
        this.checkClassType(classType);
        String tableName = this.mTableManager.getMappingTableName(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        logger.debug("query table:{}, dataType:{}", (Object)tableName, (Object)dataType.ordinal());
        List<?> dataList = this.mFeadDao.queryListByPage(feadConditionDo, pageIndex, pageSize);
        dataList.forEach(data -> this.setPublishStatus(data, tableName));
        long recordCount = this.mFeadDao.getCount(feadConditionDo);
        return new FeadPageDo(dataList, pageIndex, pageSize, recordCount);
    }

    public <T> List<T> queryBase(FeadConditionDo draftConditionDo) {
        this.checkCondition(draftConditionDo);
        Class classType = draftConditionDo.getClassType();
        this.checkClassType(classType);
        String tableName = this.mTableManager.getMappingTableName(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        logger.debug("query table:{}, dataType:{}", (Object)tableName, (Object)dataType.ordinal());
        List<?> dataList = this.mFeadDao.queryListByIndex(draftConditionDo, 0, 9999);
        dataList.forEach(data -> this.setPublishStatus(data, tableName));
        return dataList;
    }

    @Override
    public <T> List<T> queryAdd(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBase(classType, feadCategory, CurdType.ADD);
    }

    @Override
    public <T> List<T> queryUpdate(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBase(classType, feadCategory, CurdType.UPDATE);
    }

    @Override
    public List<Long> queryDelete(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBaseIds(classType, feadCategory, CurdType.DELETE);
    }

    @Override
    public List<Long> queryAddIds(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBaseIds(classType, feadCategory, CurdType.ADD);
    }

    @Override
    public List<Long> queryUpdateIds(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBaseIds(classType, feadCategory, CurdType.UPDATE);
    }

    @Override
    public FeadPageDo queryModifyIds(Class classType, FeadCategory feadCategory, int pageId, int pageSize) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        this.checkDataType(dataType, DataType.DRAFT_BUSINESS, true);
        FeadPageDo feadPageDo = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, pageId, pageSize);
        ArrayList primaryValues = new ArrayList();
        feadPageDo.getData().forEach(feadLogDdo -> {
            FeadLogDdo logDdo = (FeadLogDdo)feadLogDdo;
            primaryValues.add(new FeadPrimaryValue((int)logDdo.getPrimaryValue(), logDdo.getCurdType()));
        });
        feadPageDo.setData(primaryValues);
        return feadPageDo;
    }

    @Override
    public List<FeadPrimaryValue> queryModifyIds(Class classType, FeadCategory feadCategory) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        this.checkDataType(dataType, DataType.DRAFT_BUSINESS, true);
        FeadPageDo feadPageDo = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, 1, 9999);
        ArrayList<FeadPrimaryValue> primaryValues = new ArrayList<FeadPrimaryValue>();
        feadPageDo.getData().forEach(feadLogDdo -> {
            FeadLogDdo logDdo = (FeadLogDdo)feadLogDdo;
            primaryValues.add(new FeadPrimaryValue((int)logDdo.getPrimaryValue(), logDdo.getCurdType()));
        });
        return primaryValues;
    }

    private List<FeadRecordDo> queryRecordBase(FeadCategory feadCategory, String tableName) {
        ArrayList<FeadRecordDo> feadRecordDos = new ArrayList<FeadRecordDo>();
        List<FeadHistoryDdo> feadLogDdos = this.mFeadDao.queryHistoryData(feadCategory.getType(), feadCategory.getValue(), feadCategory.getVersion(), tableName);
        if (!FeadUtil.isEmpty(feadLogDdos)) {
            feadLogDdos.forEach(feadLogDdo -> feadRecordDos.add(this.convertLog2Record((FeadHistoryDdo)feadLogDdo, null)));
        }
        return feadRecordDos;
    }

    private FeadRecordDo convertLog2Record(FeadHistoryDdo feadHistoryDdo, Class zClass) {
        FeadRecordDo feadRecordDo = new FeadRecordDo();
        feadRecordDo.setCategoryType(feadHistoryDdo.getCategoryType());
        feadRecordDo.setCategoryValue(feadHistoryDdo.getCategoryValue());
        feadRecordDo.setCurdType(feadHistoryDdo.getCurdType());
        feadRecordDo.setPrimaryValue(feadHistoryDdo.getPrimaryValue());
        if (zClass == null) {
            zClass = this.mTableManager.getMappingClass(feadHistoryDdo.getTableName());
        }
        feadRecordDo.setZClass(zClass);
        feadRecordDo.setVersion(feadHistoryDdo.getVersion());
        return feadRecordDo;
    }

    private <T> List<T> queryDraftBase(Class classType, FeadCategory feadCategory, CurdType curdType) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        String primaryKey = this.mTableManager.getMappingPrimaryKey(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        this.checkDataType(dataType, DataType.DRAFT_BUSINESS, true);
        List<FeadLogDdo> feadLogDdos = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, curdType);
        ArrayList primaryValues = new ArrayList();
        feadLogDdos.forEach(feadLogDdo -> primaryValues.add((int)feadLogDdo.getPrimaryValue()));
        if (primaryValues.isEmpty()) {
            return new ArrayList();
        }
        FeadConditionDo feadConditionDo = new FeadConditionDo(classType);
        feadConditionDo.addAnd(Comparator.IN, primaryKey, primaryValues);
        return this.query(feadConditionDo);
    }

    private List<Long> queryDraftBaseIds(Class classType, FeadCategory feadCategory, CurdType curdType) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        this.checkDataType(dataType, DataType.DRAFT_BUSINESS, true);
        List<FeadLogDdo> feadLogDdos = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, curdType);
        ArrayList<Long> primaryValues = new ArrayList<Long>();
        feadLogDdos.forEach(feadLogDdo -> primaryValues.add(feadLogDdo.getPrimaryValue()));
        return primaryValues;
    }

    @Override
    public long feadRecordCount(FeadCategory feadCategory, Class classType) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        return this.mFeadDao.countDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName);
    }

    @Override
    public long feadRecordCount(FeadCategory feadCategory) {
        return this.mFeadDao.countDraftLog(feadCategory.getType(), feadCategory.getValue(), null);
    }

    @Override
    public void clearEditRecord(FeadCategory feadCategory, Class ... excludeClass) {
        ArrayList<String> excludeTable = new ArrayList<String>();
        if (excludeClass != null) {
            for (Class c : excludeClass) {
                String tableName = this.mTableManager.getMappingTableName(c);
                excludeTable.add(tableName);
            }
        }
        this.mFeadDao.clearDraftLogWithExclude(feadCategory.getType(), feadCategory.getValue(), excludeTable);
    }

    @Override
    public List<FeadRecordDo> feadRecord(FeadCategory feadCategory, Class classType) {
        if (feadCategory == null || feadCategory.getVersion() <= 0L) {
            logger.error("[FeadData->feadRecord] feadRecord  feadCategory or version is null ");
            throw new IllegalArgumentException("feadRecord params is nul");
        }
        String tableName = this.mTableManager.getMappingTableName(classType);
        return this.queryRecordBase(feadCategory, tableName);
    }

    @Override
    public List<FeadRecordDo> feadRecord(FeadCategory feadCategory) {
        if (feadCategory == null || feadCategory.getVersion() <= 0L) {
            logger.error("[FeadData->feadRecord] feadRecord  feadCategory or version is null ");
            throw new IllegalArgumentException("feadRecord params is nul");
        }
        return this.queryRecordBase(feadCategory, null);
    }

    @Override
    public void releaseSuccess(FeadCategory feadCategory, Class classType) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        ArrayList<FeadHistoryDdo> feadHistoryDdos = new ArrayList<FeadHistoryDdo>();
        List<FeadLogDdo> feadLogDdos = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, 0L);
        if (!FeadUtil.isEmpty(feadLogDdos)) {
            feadLogDdos.forEach(feadLogDdo -> feadHistoryDdos.add(new FeadHistoryDdo((FeadLogDdo)feadLogDdo, feadCategory.getVersion())));
        }
        this.mFeadDao.updateHistoryData(feadHistoryDdos);
        this.mFeadDao.clearDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName);
    }

    @Override
    public void releaseSuccess(FeadCategory feadCategory) {
        ArrayList<FeadHistoryDdo> feadHistoryDdos = new ArrayList<FeadHistoryDdo>();
        List<FeadLogDdo> feadLogDdos = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), null, 0L);
        if (!FeadUtil.isEmpty(feadLogDdos)) {
            feadLogDdos.forEach(feadLogDdo -> feadHistoryDdos.add(new FeadHistoryDdo((FeadLogDdo)feadLogDdo, feadCategory.getVersion())));
        }
        this.mFeadDao.updateHistoryData(feadHistoryDdos);
        this.mFeadDao.clearDraftLog(feadCategory.getType(), feadCategory.getValue(), null);
    }

    @Override
    public <T> void rollbackData(List<T> datas, CurdType curdType) {
        if (FeadUtil.isEmpty(datas)) {
            logger.error("[FeadData] rollbackData data is null ");
            throw new IllegalArgumentException("rollbackData is nul");
        }
        if (CurdType.UPDATE == curdType) {
            for (T val : datas) {
                Long primaryVal = this.getPrimaryValue(val);
                if (primaryVal == null) {
                    throw new IllegalArgumentException("primary value is empty");
                }
                T exists = this.queryById(primaryVal.intValue(), val.getClass());
                if (exists != null) {
                    this.getSession().saveOrUpdate(val);
                    continue;
                }
                this.getSession().save(val);
            }
        } else if (CurdType.ADD == curdType) {
            this.getSession().save(datas);
        } else if (CurdType.DELETE == curdType) {
            this.mFeadDao.delete(datas);
        }
    }

    private void setPublishStatus(Object data, String tableName) {
        if (!(data instanceof FeadBase)) {
            logger.error("[FeadData] {} is not FeadBase Type", data);
            return;
        }
        FeadBase dataBase = (FeadBase)data;
        if (dataBase.dataType() != DataType.DRAFT_BUSINESS) {
            return;
        }
        long primaryValue = this.getPrimaryValue(data);
        FeadLogDdo feadLogDdo = this.mFeadDao.queryDraftLog(tableName, primaryValue);
        FeadUtil.setFieldValueByName("publishStatus", feadLogDdo == null ? 1 : 0, data);
    }

    private Long getPrimaryValue(Object draftData) {
        String primaryKey = this.mTableManager.getMappingPrimaryKey(draftData.getClass());
        Object primaryValue = FeadUtil.getFieldValueByName(primaryKey, draftData);
        if (primaryValue == null) {
            return null;
        }
        if (primaryValue instanceof Integer) {
            Integer value = (Integer)primaryValue;
            if (value == 0) {
                return null;
            }
            return value.longValue();
        }
        if (primaryValue instanceof Long) {
            Long value = (Long)primaryValue;
            if (value == 0L) {
                return null;
            }
            return value;
        }
        throw new FeadException("primaryKey Type Error table:" + draftData.getClass().getName());
    }

    private void checkCondition(FeadConditionDo draftConditionDo) {
        if (draftConditionDo == null) {
            logger.error("[FeaodData] DraftConditionDo is null");
            throw new IllegalArgumentException("DraftConditionDo is nul");
        }
    }

    private void checkClassType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeaodData] ClassType empty");
            throw new IllegalArgumentException("ClassType empty");
        }
    }

    private void checkCategoryType(int categoryType) {
        if (categoryType == 0) {
            logger.error("[FeaodData] categoryType empty");
            throw new IllegalArgumentException("categoryType empty");
        }
    }

    private void checkCategoryValue(long categoryValue) {
        if (categoryValue == 0L) {
            logger.error("[FeaodData] categoryValue empty");
            throw new IllegalArgumentException("categoryValue empty");
        }
    }

    private void checkDataType(DataType dataType, DataType checkType, boolean needEqual) {
        boolean bOk;
        if (dataType == null) {
            logger.error("[FeaodData] the class data type is null ");
            throw new IllegalArgumentException("the class data type is null");
        }
        boolean bl = needEqual ? dataType == checkType : (bOk = dataType != checkType);
        if (!bOk) {
            logger.error("[FeaodData]the data type not fit use other interface ");
            throw new IllegalArgumentException("the data type not fit use other interface");
        }
    }
}

