package com.common.draft.utils;

import static com.common.draft.model.FeadConst.FILED_DEEP_COUNT;

import com.common.draft.FeadDataImpl;
import org.apache.commons.codec.binary.Hex;

import javax.persistence.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


public class FeadUtil {

    private static final Logger logger = LogManager.getLogger(FeadUtil.class);

    public static String getTableNameByClass(Class<?> classType) {
        Table table = classType.getAnnotation(Table.class);
        if (table == null) {
            return null;
        }
        return table.name();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isEmpty(String[] string) {
        return string == null || string.length == 0;
    }

    public static boolean isEmpty(List<?> list) {
        if (list == null) {
            return true;
        }
        if (list.isEmpty()) {
            return true;
        }
        return false;
    }

    public static Object getFieldValueByName(String fieldName, Object o) {

        Field field = null;
        try {
            field = o.getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException noFieldExp) {
        } catch (Exception e){
            logger.error("Can't find fieldName:{},{}",fieldName,o,e);
            return null;
        }

        Class<?> zClass = o.getClass();
        int count = 0;
        while (field == null && count < FILED_DEEP_COUNT) {
            zClass = zClass.getSuperclass();
            try {
                field = zClass.getDeclaredField(fieldName);
            } catch (NoSuchFieldException noFieldExp) {

            } catch (Exception e) {
                logger.error("Can't find fieldName:{},{}",fieldName,o,e);
                return null;
            }
            count++;
        }

        if (field == null) {
            return null;
        }

        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get";
            if (field.getType() == boolean.class || field.getType() == Boolean.class) {
                getter = "is";
            }
            getter += firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[]{});
            Object value = method.invoke(o, new Object[]{});
            return value;
        } catch (Exception e) {
            return null;
        }
    }

    public static boolean setFieldValueByName(String fieldName, Object value, Object o) {
        Field field = null;
        try {
            field = o.getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException noFieldExp) {

        } catch (Exception e) {
            logger.error("Can't find fieldName:{},{}",fieldName,o,e);
            return false;
        }


        Class<?> zClass = o.getClass();
        int count = 0;
        while (field == null && count < FILED_DEEP_COUNT) {
            zClass = zClass.getSuperclass();
            try {
                field = zClass.getDeclaredField(fieldName);
            } catch (NoSuchFieldException noFieldExp) {
            } catch (Exception e) {
                logger.error("Can't find fieldName:{},{}",fieldName,o,e);
                return false;
            }
            count++;
        }

        if (field == null) {
            return false;
        }

        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "set" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[]{field.getType()});
            method.invoke(o, new Object[]{value});
        } catch (Exception e) {
            return false;
        }
        return true;
    }


    public static Object callMethodByName(String methodName, Object o) {
        try {
            Method method = o.getClass().getMethod(methodName, new Class[]{});
            Object value = method.invoke(o, new Object[]{});
            return value;
        } catch (Exception e) {
            return null;
        }
    }


    public static String md5hex(final String data) {
        if (data == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(data.getBytes());
            return Hex.encodeHexString(messageDigest.digest());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5hex(final byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(data);
            return Hex.encodeHexString(messageDigest.digest());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFormatDateHourString(Long timeStamp) {
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(timeStamp);
    }

    public static String md5hex16(final String data) {
        String md5 = md5hex(data);
        if (md5 != null) {
            return md5.substring(8, 24);
        }
        return md5;
    }


}
