package com.common.draft.config;

import com.common.draft.FeadTableManager;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.zaxxer.hikari.HikariDataSource;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;


@Configuration
@EnableTransactionManagement
public class FeadBeanConfig extends AbstractConfig {

    public FeadBeanConfig(){
        super("fead");
    }

    protected boolean _useCache = true;

    protected String _scanPackages;


    @Bean(value = "feadEntityManager")
    public EntityManager entityManager(@Qualifier(value = "feadSessionFactory") EntityManagerFactory entityManagerFactory) {
        return entityManagerFactory.createEntityManager();
    }

    @Bean(name = "feadDataSource")
    public DataSource feadDataSource() {
        return getDataSource();
    }


    @Bean(name = "feadSessionFactory")
    public FactoryBean<SessionFactory> feadFactory() {
        return getSessionFactory(feadDataSource());
    }

    @Bean(name = "feadTransactionManager")

    public PlatformTransactionManager feadTransactionManager() throws Exception {
        return getTransactionManager(feadFactory().getObject());
    }

    @Bean(name = "feadTableManager")
    public FeadTableManager feadTableManager() {
        return getTableManager();
    }


    /**
     * Get data source
     *
     * @return
     */
/*    public DataSource getDataSource() {


        if (Strings.isNullOrEmpty(config.getHost())
                || Strings.isNullOrEmpty(config.getDbInst())
                || Strings.isNullOrEmpty(config.getUsername())
                || Strings.isNullOrEmpty(config.getPassword())) {
            throw new IllegalArgumentException(String.format("Database[%s] does not have the proper configuration"));
        }

        String jdbcUrl = new String(config.getJdbcUrl());
        String dbUrl = String.format(jdbcUrl, config.getHost(), config.getDbInst());

        //HikariDataSource
        HikariDataSource datasource = new HikariDataSource();
        datasource.setPoolName(String.format("hikari-pool-fead"));
        datasource.setJdbcUrl(dbUrl);
        datasource.setUsername(config.getUsername());
        datasource.setPassword(config.getPassword());
        datasource.setIdleTimeout(config.getIdleTimeout());
        datasource.setDriverClassName(config.getDriverClassName());
        datasource.setConnectionInitSql(config.getValidationQuery());
        datasource.setMinimumIdle(config.getMinIdle());
        datasource.setMaximumPoolSize(config.getMaxActive());
        //datasource.setAutoCommit(true);
        printHikariProperties(datasource);
        return datasource;
    }*/


    /**
     * Get database properties
     *
     * @return
     */
/*    public Properties getDBProperties() {
        Properties props = new Properties();

        //hibernate config
        props.put("hibernate.dialect", config.getDialect());
        props.put("hibernate.show_sql", config.isShowSql());
        props.put("hibernate.format_sql", config.isFormatSql());
        props.put("hibernate.generate_statistics", config.isGenerateStatistics());
        props.put("hibernate.hbm2ddl.auto", config.getHbm2ddlAuto());
        props.put("hibernate.connection.isolation", java.sql.Connection.TRANSACTION_READ_COMMITTED);
        props.put("hibernate.use_sql_comments", true);

        props.put("hibernate.cache.use_second_level_cache", false);
        props.put("hibernate.cache.use_query_cache", false);
        props.put("hibernate.connection.CharSet", "utf8");
        props.put("hibernate.connection.characterEncoding", "utf8");
        props.put("hibernate.connection.useUnicode", true);
        props.put("hibernate.autoReconnect", true);
        props.put("hibernate.dialect.storage_engine",config.getDbEngine());

        printHibernateProperties(props);
        return props;

    }*/

    /**
     * Get session factory
     *
     * @param dataSource
     * @return
     */
    public FactoryBean<SessionFactory> getSessionFactory(DataSource dataSource) {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();

        String scanPackages =  getStringConfig("db.scanPackages", "");
        scanPackages = Joiner.on(",").skipNulls().join(Strings.emptyToNull(scanPackages), "com.common.draft.model.ddo");
        if (!Strings.isNullOrEmpty(scanPackages)) {
            sessionFactoryBean.setPackagesToScan(scanPackages.split(","));
        }

        sessionFactoryBean.setHibernateProperties(getDBProperties());
        sessionFactoryBean.setDataSource(dataSource);
        _scanPackages = scanPackages;
        _useCache = getBoolConfig("db.usecache",true);

        return sessionFactoryBean;
    }


    public FeadTableManager getTableManager() {
        return new FeadTableManager(_scanPackages);
    }

    public boolean getUseCache(){
        return _useCache;
    }

}
