package com.common.draft.dao;

import com.common.draft.model.Comparator;
import com.common.draft.model.CurdType;
import com.common.draft.model.FeadConditionDo;
import com.common.draft.model.FeadConst;
import com.common.draft.model.FeadPageDo;
import com.common.draft.model.ddo.FeadHistoryDdo;
import com.common.draft.model.ddo.FeadLogDdo;
import com.common.draft.utils.FeadUtil;
import java.util.List;
import javax.persistence.NoResultException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/******************
 * Fead自身表访问
 *
 * **************************/

@Component
public class FeadDao extends BaseDao {

    private static final Logger logger = LogManager.getLogger(FeadDao.class);


    @Autowired
    public FeadDao(@Qualifier("feadSessionFactory") SessionFactory _sessionFactory) {
        super(_sessionFactory);
    }


    /************************ Draft Log ******************************/

    public List<FeadLogDdo> queryDraftLog(int categoryType, long categoryValue, String tableName, CurdType curdType) {

        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        draftConditionDo.addAnd(Comparator.EQ, "categoryType", categoryType)
                .addAnd(Comparator.EQ, "categoryValue", categoryValue)
                .addAnd(Comparator.EQ, "tableName", tableName)
                .addAnd(Comparator.EQ, "curdType", curdType.ordinal());

        List<FeadLogDdo> draftResults = (List<FeadLogDdo>) queryListByPage(draftConditionDo, FeadConst.DEF_PAGE_INDEX,
                FeadConst.DEF_PAGE_SIZE);
        return draftResults;
    }

    public FeadPageDo queryDraftLog(int categoryType, long categoryValue, String tableName, int pageId, int pageSize) {

        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        draftConditionDo.addAnd(Comparator.EQ, "categoryType", categoryType)
                .addAnd(Comparator.EQ, "categoryValue", categoryValue)
                .addAnd(Comparator.EQ, "tableName", tableName);

        List<FeadLogDdo> draftResults = (List<FeadLogDdo>) queryListByPage(draftConditionDo, pageId, pageSize);
        long recordCount = getCount(draftConditionDo);
        return new FeadPageDo(draftResults, pageId, pageSize, recordCount);

    }

    public void updateDraftLogVersion(int categoryType, long categoryValue, String tableName, long version) {

        String hql = "update from FeadLogDdo set version = :version where categoryType = :categoryType and categoryValue = :categoryValue ";
        if (!FeadUtil.isEmpty(tableName)) {
            hql += " and tableName = :tableName";
        }

        Query query = getSession().createQuery(hql);
        query.setParameter("version", version);
        query.setParameter("categoryType", categoryType);
        query.setParameter("categoryValue", categoryValue);
        if (!FeadUtil.isEmpty(tableName)) {
            query.setParameter("tableName", tableName);
        }
        query.executeUpdate();
    }

    public void clearDraftLog(int categoryType, long categoryValue, String tableName) {

        String hql = "delete from FeadLogDdo where categoryType = :categoryType and categoryValue = :categoryValue ";

        if (!FeadUtil.isEmpty(tableName)) {
            hql += " and tableName = :tableName";
        }

        Query query = getSession().createQuery(hql);
        query.setParameter("categoryType", categoryType);
        query.setParameter("categoryValue", categoryValue);
        if (!FeadUtil.isEmpty(tableName)) {
            query.setParameter("tableName", tableName);
        }
        query.executeUpdate();
    }

    public void clearDraftLogWithExclude(int categoryType, long categoryValue, List<String> excludeTableName) {

        String hql = "delete from FeadLogDdo where categoryType = :categoryType and categoryValue = :categoryValue ";

        if (!FeadUtil.isEmpty(excludeTableName)) {
            hql += " and tableName not in :tableName";
        }

        Query query = getSession().createQuery(hql);
        query.setParameter("categoryType", categoryType);
        query.setParameter("categoryValue", categoryValue);
        if (!FeadUtil.isEmpty(excludeTableName)) {
            query.setParameter("tableName", excludeTableName);
        }
        query.executeUpdate();
    }

    public long countDraftLog(int categoryType, long categoryValue, String tableName) {

        String hql = "select count(1) from FeadLogDdo where categoryType = :categoryType and categoryValue = :categoryValue  ";

        if (!FeadUtil.isEmpty(tableName)) {
            hql += " and tableName = :tableName";
        }

        Query query = getSession().createQuery(hql);
        query.setParameter("categoryType", categoryType);
        query.setParameter("categoryValue", categoryValue);
        if (!FeadUtil.isEmpty(tableName)) {
            query.setParameter("tableName", tableName);
        }
        Long count = null;
        try {
            count = (Long) query.getSingleResult();
        } catch (NoResultException e) {
            logger.error("[FeadData->countDraftLog] result empty");
        }
        if (count == null) {
            return 0;
        }
        return count.longValue();
    }


    public List<FeadLogDdo> queryDraftLog(int categoryType, long categoryValue, String tableName, long version) {

        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        draftConditionDo.addAnd(Comparator.EQ, "categoryType", categoryType)
                .addAnd(Comparator.EQ, "categoryValue", categoryValue);
        if (!FeadUtil.isEmpty(tableName)) {
            draftConditionDo.addAnd(Comparator.EQ, "tableName", tableName);
        }

        List<FeadLogDdo> draftResults = (List<FeadLogDdo>) queryListByPage(draftConditionDo, FeadConst.DEF_PAGE_INDEX,
                FeadConst.DEF_PAGE_SIZE);
        return draftResults;
    }


    public FeadLogDdo queryDraftLog(String tableName, Long primaryValue) {
        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        if (StringHelper.isEmpty(tableName) || primaryValue == null) {
            return null;
        }

        draftConditionDo.addAnd(Comparator.EQ, "primaryValue", primaryValue);
        draftConditionDo.addAnd(Comparator.EQ, "tableName", tableName);
        FeadLogDdo draftResult = (FeadLogDdo) querySingle(draftConditionDo);
        return draftResult;
    }


    public List<FeadLogDdo> queryDraftLogByTable(int categoryType, long categoryValue, String tableName) {
        if (StringHelper.isEmpty(tableName)) {
            return null;
        }

        FeadConditionDo draftConditionDo = new FeadConditionDo(FeadLogDdo.class);
        draftConditionDo.addAnd(Comparator.EQ, "categoryType", categoryType)
                .addAnd(Comparator.EQ, "categoryValue", categoryValue)
                .addAnd(Comparator.EQ, "tableName", tableName);
        List<FeadLogDdo> draftResults = (List<FeadLogDdo>) queryListByPage(draftConditionDo, FeadConst.DEF_PAGE_INDEX,
                FeadConst.DEF_PAGE_SIZE);
        return draftResults;
    }


    public void updateDraftLog(FeadLogDdo draftLogDdo) {
        update(draftLogDdo);
    }

    public void deleteDraftLog(FeadLogDdo draftLogDdo) {
        delete(draftLogDdo);
    }


    /************************ History Data ******************************/

    public List<FeadHistoryDdo> queryHistoryData(int categoryType, long categoryValue, long version, String tableName) {
        FeadConditionDo feadConditionDo = new FeadConditionDo(FeadHistoryDdo.class)
                .addAnd(Comparator.EQ, "categoryType", categoryType)
                .addAnd(Comparator.EQ, "categoryValue", categoryValue);
        if (!FeadUtil.isEmpty(tableName)) {
            feadConditionDo.addAnd(Comparator.EQ, "tableName", tableName);
        }
        return (List<FeadHistoryDdo>) queryListByPage(feadConditionDo, FeadConst.DEF_PAGE_INDEX,
                FeadConst.DEF_PAGE_SIZE);
    }


    public void updateHistoryData(List<FeadHistoryDdo> datas) {
        update(datas);
    }


}