package com.common.draft.model.ddo;

import com.common.draft.FeadBase;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Data;

@Data
@Entity
@Table(name = "fead_data")
public class FeadLogDdo implements FeadBase {

    public FeadLogDdo() {
    }

    public FeadLogDdo(long draftId, int version, int categoryType, int categoryValue, String tableName,
            long primaryValue, int curdType, String dbFlag) {
        this.draftId = draftId;
        this.version = version;
        this.categoryType = categoryType;
        this.categoryValue = categoryValue;
        this.tableName = tableName;
        this.primaryValue = primaryValue;
        this.curdType = curdType;
    }

    @Id
    @Column(name = "draft_id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private long draftId;

    @Column(name = "version")
    private long version;

    @Column(name = "category_type")
    private int categoryType;

    @Column(name = "category_value")
    private long categoryValue;

    @Column(name = "table_name", length = 64)
    private String tableName;

    @Column(name = "primary_value")
    private long primaryValue;

    @Column(name = "curd_type")
    private int curdType;


}
