/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft.dao;

import com.common.draft.FeadComparator;
import com.common.draft.model.Comparator;
import com.common.draft.model.FeadConditionDo;
import com.common.draft.model.FeadConditionUnitDo;
import com.common.draft.model.FeadSort;
import com.common.draft.utils.FeadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public abstract class BaseDao {
    private final SessionFactory _sessionFactory;
    private static final Logger logger = LogManager.getLogger(BaseDao.class);

    public BaseDao(SessionFactory _sessionFactory) {
        this._sessionFactory = _sessionFactory;
    }

    public Session getSession() {
        return this._sessionFactory.getCurrentSession();
    }

    public final SessionFactory getSessionFactory() {
        return this._sessionFactory;
    }

    public <T> void update(T data) {
        this.getSession().saveOrUpdate(data);
    }

    public <T> void update(Iterable<T> datas) {
        for (T data : datas) {
            this.getSession().saveOrUpdate(data);
        }
    }

    public <T> void delete(T data) {
        this.getSession().delete(data);
    }

    public <T> void delete(Iterable<T> datas) {
        for (T data : datas) {
            this.getSession().delete(data);
        }
    }

    public <T> void save(Iterable<T> datas) {
        for (T data : datas) {
            this.getSession().save(data);
        }
    }

    public int deleteByCondition(FeadConditionDo conditionDo) {
        CriteriaDelete criteriaDelete;
        Root root;
        Session session = this.getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        Predicate predicate = this.genPredicate(conditionDo, builder, root = (criteriaDelete = builder.createCriteriaDelete(conditionDo.getClassType())).from(conditionDo.getClassType()));
        if (predicate != null) {
            criteriaDelete.where((Expression)predicate);
        } else {
            logger.warn("No where condition match");
        }
        return session.createQuery(criteriaDelete).executeUpdate();
    }

    public List<?> queryListByPage(FeadConditionDo draftConditionDo, int pageIndex, int pageSize) {
        return this.queryListByIndex(draftConditionDo, (pageIndex - 1) * pageSize, pageSize);
    }

    public List<?> queryListByIndex(FeadConditionDo draftConditionDo, int begin, int pageSize) {
        HashMap<String, FeadSort> feadSortMap;
        Session session = this.getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(draftConditionDo.getClassType());
        Root root = criteriaQuery.from(draftConditionDo.getClassType());
        Predicate predicate = this.genPredicate(draftConditionDo, builder, root);
        criteriaQuery.select((Selection)root);
        if (predicate != null) {
            criteriaQuery.where((Expression)predicate);
        }
        if ((feadSortMap = draftConditionDo.getOrderBy()) != null && !feadSortMap.isEmpty()) {
            ArrayList<Order> orderList = new ArrayList<Order>();
            Set<String> keys = feadSortMap.keySet();
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                Path path = root.get(key);
                orderList.add(feadSortMap.get(key) == FeadSort.ASC ? builder.asc((Expression)path) : builder.desc((Expression)path));
            }
            criteriaQuery.orderBy(orderList);
        }
        if (!FeadUtil.isEmpty(draftConditionDo.getGroupBy())) {
            ArrayList<Path> paths = new ArrayList<Path>();
            for (String prop : draftConditionDo.getGroupBy()) {
                paths.add(root.get(prop));
            }
            criteriaQuery.groupBy(paths);
        }
        Query query = session.createQuery(criteriaQuery);
        query.setFirstResult(begin);
        query.setMaxResults(pageSize);
        List results = query.getResultList();
        return results;
    }

    public Object querySingle(FeadConditionDo draftConditionDo) {
        try {
            Session session = this.getSession();
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(draftConditionDo.getClassType());
            Root root = criteriaQuery.from(draftConditionDo.getClassType());
            Predicate predicate = this.genPredicate(draftConditionDo, builder, root);
            criteriaQuery.select((Selection)root);
            criteriaQuery.where((Expression)predicate);
            Query query = session.createQuery(criteriaQuery);
            return query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public long getCount(FeadConditionDo draftConditionDo) {
        Session session = this.getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(draftConditionDo.getClassType());
        Root root = criteriaQuery.from(draftConditionDo.getClassType());
        Predicate predicate = this.genPredicate(draftConditionDo, builder, root);
        criteriaQuery.select((Selection)builder.count((Expression)root));
        if (predicate != null) {
            criteriaQuery.where((Expression)predicate);
        }
        return (Long)session.createQuery(criteriaQuery).getSingleResult();
    }

    public long getGreatest(FeadConditionDo draftConditionDo) {
        Long issueId;
        Session session = this.getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(Long.class);
        Root root = criteriaQuery.from(draftConditionDo.getClassType());
        Predicate predicate = this.genPredicate(draftConditionDo, builder, root);
        criteriaQuery.select((Selection)builder.greatest((Expression)root));
        if (predicate != null) {
            criteriaQuery.where((Expression)predicate);
        }
        if ((issueId = (Long)session.createQuery(criteriaQuery).uniqueResult()) == null) {
            return 0L;
        }
        return issueId;
    }

    public long getLeast(FeadConditionDo draftConditionDo) {
        Long issueId;
        Session session = this.getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(Long.class);
        Root root = criteriaQuery.from(draftConditionDo.getClassType());
        Predicate predicate = this.genPredicate(draftConditionDo, builder, root);
        criteriaQuery.select((Selection)builder.least((Expression)root));
        if (predicate != null) {
            criteriaQuery.where((Expression)predicate);
        }
        if ((issueId = (Long)session.createQuery(criteriaQuery).uniqueResult()) == null) {
            return 0L;
        }
        return issueId;
    }

    public long getCountByHql(FeadConditionDo draftConditionDo) {
        Long l;
        List<FeadConditionUnitDo> draftConditionOrs;
        String hql = this.genHqlQuery(draftConditionDo);
        String countHql = String.format("select count(1) %s", hql);
        Query query = this.getSession().createQuery(countHql);
        List<FeadConditionUnitDo> draftConditionAnds = draftConditionDo.getAndCondition();
        if (!FeadUtil.isEmpty(draftConditionAnds)) {
            for (FeadConditionUnitDo feadConditionUnitDo : draftConditionAnds) {
                if (feadConditionUnitDo.getComparator() == Comparator.IS_EMPTY || feadConditionUnitDo.getComparator() == Comparator.IS_NOT_EMPTY || feadConditionUnitDo.getComparator() == Comparator.IS_NULL || feadConditionUnitDo.getComparator() == Comparator.IS_NOT_NULL || feadConditionUnitDo.getValue() == null) continue;
                if (feadConditionUnitDo.getComparator() != Comparator.IN) {
                    query.setParameter(feadConditionUnitDo.getProperty(), feadConditionUnitDo.getValue());
                    continue;
                }
                query.setParameterList(feadConditionUnitDo.getProperty(), (Collection)((ArrayList)feadConditionUnitDo.getValue()));
            }
        }
        if (!FeadUtil.isEmpty(draftConditionOrs = draftConditionDo.getOrCondition())) {
            for (FeadConditionUnitDo conditionUnitDo : draftConditionOrs) {
                if (conditionUnitDo.getComparator() == Comparator.IS_EMPTY || conditionUnitDo.getComparator() == Comparator.IS_NOT_EMPTY || conditionUnitDo.getComparator() == Comparator.IS_NULL || conditionUnitDo.getComparator() == Comparator.IS_NOT_NULL || conditionUnitDo.getValue() == null) continue;
                if (conditionUnitDo.getComparator() != Comparator.IN) {
                    query.setParameter(conditionUnitDo.getProperty(), conditionUnitDo.getValue());
                    continue;
                }
                query.setParameterList(conditionUnitDo.getProperty(), (Collection)((ArrayList)conditionUnitDo.getValue()));
            }
        }
        if ((l = (Long)query.getSingleResult()) == null) {
            return 0L;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private String genHqlQuery(FeadConditionDo draftConditionDo) {
        void var6_13;
        List<FeadConditionUnitDo> draftConditionOrs;
        String conditionAnd = "";
        String conditionOr = "";
        List<FeadConditionUnitDo> draftConditionAnds = draftConditionDo.getAndCondition();
        if (!FeadUtil.isEmpty(draftConditionAnds)) {
            for (FeadConditionUnitDo feadConditionUnitDo : draftConditionAnds) {
                conditionAnd = this.linkCondition(conditionAnd, feadConditionUnitDo, true);
            }
        }
        if (!FeadUtil.isEmpty(draftConditionOrs = draftConditionDo.getOrCondition())) {
            for (FeadConditionUnitDo conditionUnitDo : draftConditionOrs) {
                conditionOr = this.linkCondition(conditionOr, conditionUnitDo, false);
            }
        }
        String string = String.format("from %s ", draftConditionDo.getClassType().getName());
        if (!FeadUtil.isEmpty(draftConditionAnds) && !FeadUtil.isEmpty(draftConditionOrs)) {
            String string2 = String.format("%s where (%s) and (%s)", string, conditionAnd, conditionOr);
        } else if (!FeadUtil.isEmpty(draftConditionAnds) && FeadUtil.isEmpty(draftConditionOrs)) {
            String string3 = String.format("%s where %s", string, conditionAnd);
        } else if (FeadUtil.isEmpty(draftConditionAnds) && !FeadUtil.isEmpty(draftConditionOrs)) {
            String string4 = String.format("%s where %s", string, conditionOr);
        }
        logger.info("query hql:{}", (Object)var6_13);
        return var6_13;
    }

    private String linkCondition(String condition, FeadConditionUnitDo conditionUnitDo, boolean bAnd) {
        if (!FeadUtil.isEmpty(condition)) {
            condition = condition + (bAnd ? " and " : " or ");
        }
        condition = condition + FeadComparator.parseConditionStr(conditionUnitDo);
        return condition;
    }

    /*
     * WARNING - void declaration
     */
    private Predicate genPredicate(FeadConditionDo draftConditionDo, CriteriaBuilder builder, Root<?> root) {
        void var8_17;
        List<FeadConditionUnitDo> draftParamsOr;
        ArrayList<Predicate> predicateAnd = new ArrayList<Predicate>();
        ArrayList<Predicate> predicatesOr = new ArrayList<Predicate>();
        List<FeadConditionUnitDo> draftConditionDoAnds = draftConditionDo.getAndCondition();
        if (draftConditionDoAnds != null) {
            for (FeadConditionUnitDo feadConditionUnitDo : draftConditionDoAnds) {
                Predicate predicate = FeadComparator.parseCondition(feadConditionUnitDo, builder, root);
                if (predicate == null) continue;
                predicateAnd.add(predicate);
            }
        }
        if ((draftParamsOr = draftConditionDo.getOrCondition()) != null) {
            for (FeadConditionUnitDo conditionUnitDo : draftParamsOr) {
                Predicate predicate = FeadComparator.parseCondition(conditionUnitDo, builder, root);
                if (predicate == null) continue;
                predicatesOr.add(predicate);
            }
        }
        Object var8_11 = null;
        if (!predicateAnd.isEmpty() && predicatesOr.isEmpty()) {
            Predicate predicate = builder.and(predicateAnd.toArray(new Predicate[predicateAnd.size()]));
        }
        if (predicateAnd.isEmpty() && !predicatesOr.isEmpty()) {
            Predicate predicate = builder.or(predicatesOr.toArray(new Predicate[predicatesOr.size()]));
        }
        if (!predicateAnd.isEmpty() && !predicatesOr.isEmpty()) {
            Predicate predicate = builder.and((Expression)builder.and(predicateAnd.toArray(new Predicate[predicateAnd.size()])), (Expression)builder.or(predicatesOr.toArray(new Predicate[predicatesOr.size()])));
        }
        return var8_17;
    }
}

