package com.common.draft.model.ddo;

import com.common.draft.FeadBase;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Data;

@Data
@Entity
@Table(name = "fead_history")
public class FeadHistoryDdo implements FeadBase {

    public FeadHistoryDdo() {
    }

    public FeadHistoryDdo(FeadLogDdo feadLogDdo, long version) {
        this.draftId = feadLogDdo.getDraftId();
        this.version = version;
        this.tableName = feadLogDdo.getTableName();
        this.primaryValue = feadLogDdo.getPrimaryValue();
        this.curdType = feadLogDdo.getCurdType();
        this.categoryType = feadLogDdo.getCategoryType();
        this.categoryValue = feadLogDdo.getCategoryValue();
    }


    @Id
    @Column(name = "draft_id")
    private long draftId;

    @Column(name = "version")
    private long version;

    @Column(name = "category_type")
    private int categoryType;

    @Column(name = "category_value")
    private long categoryValue;

    @Column(name = "table_name")
    private String tableName;

    @Column(name = "primary_value")
    private long primaryValue;

    @Column(name = "curd_type")
    private int curdType;

}
