/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft;

import com.common.draft.FeadBase;
import com.common.draft.FeadData;
import com.common.draft.FeadException;
import com.common.draft.FeadTableManager;
import com.common.draft.config.FeadBeanConfig;
import com.common.draft.dao.FeadDao;
import com.common.draft.model.Comparator;
import com.common.draft.model.CurdType;
import com.common.draft.model.DataType;
import com.common.draft.model.FeadCategory;
import com.common.draft.model.FeadConditionDo;
import com.common.draft.model.FeadPageDo;
import com.common.draft.model.FeadPrimaryValue;
import com.common.draft.model.MasterData;
import com.common.draft.model.ddo.FeadLogDdo;
import com.common.draft.utils.FeadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class FeadDataImpl
implements FeadData {
    private static final Logger logger = LogManager.getLogger(FeadDataImpl.class);
    @Autowired
    private FeadDao mFeadDao;
    @Autowired
    private FeadTableManager mTableManager;
    @Autowired
    FeadBeanConfig config;

    @Override
    public SessionFactory getSessionFactory() {
        return this.mFeadDao.getSessionFactory();
    }

    @Override
    public Session getSession() {
        return this.mFeadDao.getSession();
    }

    @Override
    public void update(FeadBase draftData) {
        this.updateData(draftData, true);
    }

    private void updateDraftLogByEditData(FeadBase draftData) {
        if (draftData == null) {
            logger.error("update draftLog param null. no draftData");
            return;
        }
        if (draftData.dataType() != DataType.DRAFT_BUSINESS) {
            return;
        }
        Long primaryValue = this.getPrimaryValue(draftData);
        if (primaryValue == null) {
            return;
        }
        String tableName = this.mTableManager.getMappingTableName(draftData.getClass());
        FeadLogDdo draftLogDdo = this.mFeadDao.queryDraftLog(tableName, primaryValue);
        if (draftLogDdo != null) {
            draftLogDdo.setVersion(draftLogDdo.getVersion() + 1L);
            this.mFeadDao.updateDraftLog(draftLogDdo);
        } else {
            FeadLogDdo feadLogDdo = this.genDraftLog(draftData.categoryType(), draftData.categoryValue(), primaryValue, tableName, CurdType.UPDATE);
            this.mFeadDao.updateDraftLog(feadLogDdo);
        }
    }

    private void updateData(FeadBase draftData, boolean needUpdateMasterDraftLog) {
        if (draftData == null) {
            logger.error("update draftData param is null");
            throw new IllegalArgumentException("update draftData param is null");
        }
        if (draftData.dataType() != DataType.DRAFT_BUSINESS) {
            this.mFeadDao.update(draftData);
            return;
        }
        String tableName = this.mTableManager.getMappingTableName(draftData.getClass());
        Long primaryValue = this.getPrimaryValue(draftData);
        if (primaryValue != null) {
            FeadLogDdo draftLogDdo = this.mFeadDao.queryDraftLog(tableName, primaryValue);
            if (draftLogDdo != null) {
                if (draftLogDdo.getCurdType() == CurdType.DELETE.ordinal()) {
                    throw new FeadException("[FeadData->update] draft log curd type error");
                }
                draftLogDdo.setVersion(draftLogDdo.getVersion() + 1L);
                this.mFeadDao.updateDraftLog(draftLogDdo);
            } else {
                FeadLogDdo feadLogDdo = this.genDraftLog(draftData.categoryType(), draftData.categoryValue(), primaryValue, tableName, CurdType.UPDATE);
                this.mFeadDao.updateDraftLog(feadLogDdo);
            }
            this.mFeadDao.update(draftData);
        } else {
            this.mFeadDao.update(draftData);
            primaryValue = this.getPrimaryValue(draftData);
            if (primaryValue == null) {
                throw new FeadException("[FeadData->update] draft log read primaryValue error");
            }
            long categoryValue = draftData.categoryValue();
            if (categoryValue == 0L) {
                categoryValue = primaryValue;
            }
            this.mFeadDao.updateDraftLog(this.genDraftLog(draftData.categoryType(), categoryValue, primaryValue, tableName, CurdType.ADD));
        }
        if (needUpdateMasterDraftLog) {
            this.updateMasterDraftLogByCurrent(draftData);
        }
    }

    private void updateMasterDraftLogByCurrent(FeadBase draftData) {
        MasterData masterData = draftData.getMasterData();
        if (masterData == null || masterData.getMasterClass() == null || masterData.getMasterId() <= 0L) {
            return;
        }
        FeadBase dbMasterData = (FeadBase)this.queryByIdBase(masterData.getMasterId(), masterData.getMasterClass());
        if (dbMasterData != null) {
            this.updateDraftLogByEditData(dbMasterData);
        }
    }

    @Override
    public <T> int update(List<T> draftDataList) {
        if (CollectionUtils.isEmpty(draftDataList)) {
            logger.error("update draftData param is null");
            return 0;
        }
        Map<Class, List<T>> clz2DataMap = this.getMapDataGroupByClassType(draftDataList);
        Class classType = null;
        Set<Map.Entry<Class, List<T>>> entrySet = clz2DataMap.entrySet();
        for (Map.Entry<Class, List<T>> entry : entrySet) {
            classType = entry.getKey();
            this.updateDatasByClassType(classType, entry.getValue());
        }
        return draftDataList.size();
    }

    private <T> void updateDatasByClassType(Class classType, List<T> draftDataList) {
        DataType dataType = this.mTableManager.getClassDataType(classType);
        if (dataType == null || dataType != DataType.DRAFT_BUSINESS) {
            this.mFeadDao.update(draftDataList);
            return;
        }
        int addKey = 0;
        int updateKey = 1;
        long categoryValue = 0L;
        MasterData masterData = this.mTableManager.getMasterDataByClassType(classType);
        HashMap<Long, Map<Integer, List<Long>>> cValue2OperateTypePrimaryValueMap = new HashMap<Long, Map<Integer, List<Long>>>();
        HashMap cValue2MasterDataPrimaryValueMap = new HashMap();
        for (T t : draftDataList) {
            MasterData master;
            FeadBase draftData = (FeadBase)t;
            categoryValue = draftData.categoryValue();
            Long primaryValue = this.getPrimaryValue(t);
            if (primaryValue == null || primaryValue <= 0L) {
                this.filterPrimaryValueGroupByOperateType(addKey, categoryValue, primaryValue, cValue2OperateTypePrimaryValueMap);
            } else {
                this.filterPrimaryValueGroupByOperateType(updateKey, categoryValue, primaryValue, cValue2OperateTypePrimaryValueMap);
            }
            if (masterData == null || (master = draftData.getMasterData()) == null || master.getMasterClass() == null || master.getMasterId() <= 0L) continue;
            if (!cValue2MasterDataPrimaryValueMap.containsKey(categoryValue)) {
                cValue2MasterDataPrimaryValueMap.put(categoryValue, new ArrayList());
            }
            if (((List)cValue2MasterDataPrimaryValueMap.get(categoryValue)).contains(master.getMasterId())) continue;
            ((List)cValue2MasterDataPrimaryValueMap.get(categoryValue)).add(master.getMasterId());
        }
        this.mFeadDao.update(draftDataList);
        for (Map.Entry entry : cValue2OperateTypePrimaryValueMap.entrySet()) {
            for (Map.Entry operateTypeEntry : ((Map)entry.getValue()).entrySet()) {
                this.saveDraftLogByCurdTypeAndPrimaryValues((Long)entry.getKey(), (Integer)operateTypeEntry.getKey() == addKey ? CurdType.ADD : CurdType.UPDATE, classType, (List)operateTypeEntry.getValue());
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)cValue2MasterDataPrimaryValueMap.get(entry.getKey())))) continue;
            this.saveDraftLogByCurdTypeAndPrimaryValues((Long)entry.getKey(), CurdType.UPDATE, masterData.getMasterClass(), (List)cValue2MasterDataPrimaryValueMap.get(entry.getKey()));
        }
    }

    private void filterPrimaryValueGroupByOperateType(int operateType, long categoryValue, Long primaryValue, Map<Long, Map<Integer, List<Long>>> cValue2OperateTypePrimaryValueMap) {
        if (!cValue2OperateTypePrimaryValueMap.containsKey(categoryValue)) {
            cValue2OperateTypePrimaryValueMap.put(categoryValue, new HashMap());
        }
        if (!cValue2OperateTypePrimaryValueMap.get(categoryValue).containsKey(operateType)) {
            cValue2OperateTypePrimaryValueMap.get(categoryValue).put(operateType, new ArrayList());
        }
        cValue2OperateTypePrimaryValueMap.get(categoryValue).get(operateType).add(primaryValue);
    }

    private FeadLogDdo genDraftLog(int categoryType, long categoryValue, long primaryValue, String tableName, CurdType curdType) {
        long version = 0L;
        FeadLogDdo draftLogDdo = new FeadLogDdo();
        draftLogDdo.setVersion(version);
        draftLogDdo.setCategoryType(categoryType);
        draftLogDdo.setCategoryValue(categoryValue);
        draftLogDdo.setTableName(tableName);
        draftLogDdo.setCurdType(curdType.ordinal());
        draftLogDdo.setPrimaryValue(primaryValue);
        return draftLogDdo;
    }

    @Override
    public void delete(FeadBase draftData) {
        this.deleteData(draftData, true);
    }

    private void deleteData(FeadBase draftData, boolean needUpdateMasterDraftLog) {
        if (draftData == null) {
            logger.error("[DraftData->delete]delete draftData param is null");
            throw new IllegalArgumentException("delete draftData param is null");
        }
        if (draftData.dataType() == DataType.DRAFT_BUSINESS) {
            Long primaryValue = this.getPrimaryValue(draftData);
            this.deleteDraftLog(draftData.categoryType(), draftData.categoryValue(), draftData.getClass(), primaryValue);
        }
        this.mFeadDao.delete(draftData);
        if (needUpdateMasterDraftLog) {
            this.updateMasterDraftLogByCurrent(draftData);
        }
    }

    @Override
    public void deleteById(Class classType, long id) {
        this.checkClassType(classType);
        String primaryKey = this.mTableManager.getMappingPrimaryKey(classType);
        FeadConditionDo draftConditionDo = new FeadConditionDo(classType);
        draftConditionDo.addAnd(Comparator.EQ, primaryKey, id);
        FeadBase data = (FeadBase)this.mFeadDao.querySingle(draftConditionDo);
        if (data == null) {
            return;
        }
        this.delete(data);
    }

    private int deleteByPrimaryKeyAndDataList(Class classType, List<FeadBase> dbDataList) {
        if (CollectionUtils.isEmpty(dbDataList)) {
            return 0;
        }
        long primaryValue = 0L;
        MasterData masterData = this.mTableManager.getMasterDataByClassType(classType);
        HashMap categoryValue2DelDataPrimaryValueMap = new HashMap();
        HashMap categoryValue2MasterDataPrimaryValueMap = new HashMap();
        for (FeadBase feadBase : dbDataList) {
            MasterData master;
            if (!categoryValue2DelDataPrimaryValueMap.containsKey(feadBase.categoryValue())) {
                categoryValue2DelDataPrimaryValueMap.put(feadBase.categoryValue(), new ArrayList());
            }
            primaryValue = this.getPrimaryValue(feadBase);
            ((List)categoryValue2DelDataPrimaryValueMap.get(feadBase.categoryValue())).add(primaryValue);
            if (masterData == null || (master = feadBase.getMasterData()) == null || master.getMasterClass() == null || master.getMasterId() <= 0L) continue;
            if (!categoryValue2MasterDataPrimaryValueMap.containsKey(feadBase.categoryValue())) {
                categoryValue2MasterDataPrimaryValueMap.put(feadBase.categoryValue(), new ArrayList());
            }
            if (((List)categoryValue2MasterDataPrimaryValueMap.get(feadBase.categoryValue())).contains(master.getMasterId())) continue;
            ((List)categoryValue2MasterDataPrimaryValueMap.get(feadBase.categoryValue())).add(master.getMasterId());
        }
        this.mFeadDao.delete(dbDataList);
        for (Map.Entry entry : categoryValue2DelDataPrimaryValueMap.entrySet()) {
            this.saveDraftLogByCurdTypeAndPrimaryValues((Long)entry.getKey(), CurdType.DELETE, classType, (List)entry.getValue());
            if (CollectionUtils.isEmpty((Collection)((Collection)categoryValue2MasterDataPrimaryValueMap.get(entry.getKey())))) continue;
            this.saveDraftLogByCurdTypeAndPrimaryValues((Long)entry.getKey(), CurdType.UPDATE, masterData.getMasterClass(), (List)categoryValue2MasterDataPrimaryValueMap.get(entry.getKey()));
        }
        return dbDataList.size();
    }

    @Override
    public int deleteAll(Class classType, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            logger.error("[DraftData->delete]delete draftData param is null");
            return 0;
        }
        this.checkClassType(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        String primaryKey = this.mTableManager.getMappingPrimaryKey(classType);
        FeadConditionDo conditionDo = new FeadConditionDo(classType).addAnd(Comparator.IN, primaryKey, ids);
        if (dataType == null || dataType != DataType.DRAFT_BUSINESS) {
            return this.mFeadDao.deleteByCondition(conditionDo);
        }
        List<FeadBase> dataList = this.queryBase(false, conditionDo);
        if (CollectionUtils.isEmpty(dataList)) {
            return 0;
        }
        return this.deleteByPrimaryKeyAndDataList(classType, dataList);
    }

    private void saveDraftLogByCurdTypeAndPrimaryValues(long categoryValue, CurdType curdType, Class classType, List<Long> primaryValues) {
        DataType dataType = this.mTableManager.getClassDataType(classType);
        if (dataType == null || dataType != DataType.DRAFT_BUSINESS) {
            return;
        }
        Integer categoryType = this.mTableManager.getCategoryType(classType);
        String tableName = this.mTableManager.getMappingTableName(classType);
        FeadConditionDo draftDataCondition = new FeadConditionDo(FeadLogDdo.class).addAnd(Comparator.IN, "primaryValue", primaryValues).addAnd(Comparator.EQ, "tableName", tableName);
        List logs = this.queryBase(false, draftDataCondition);
        Map<Long, FeadLogDdo> primaryValue2LogDataMap = logs.stream().collect(Collectors.toMap(FeadLogDdo::getPrimaryValue, log -> log, (k1, k2) -> k1));
        ArrayList<FeadLogDdo> deleteLogList = new ArrayList<FeadLogDdo>();
        ArrayList<FeadLogDdo> saveLogList = new ArrayList<FeadLogDdo>();
        for (long primaryValue : primaryValues) {
            if (primaryValue2LogDataMap.containsKey(primaryValue)) {
                FeadLogDdo dbLog = primaryValue2LogDataMap.get(primaryValue);
                if (curdType == CurdType.DELETE) {
                    if (dbLog.getCurdType() == CurdType.ADD.ordinal()) {
                        deleteLogList.add(dbLog);
                        continue;
                    }
                    if (dbLog.getCurdType() != CurdType.UPDATE.ordinal()) continue;
                    dbLog.setCurdType(CurdType.DELETE.ordinal());
                    dbLog.setVersion(dbLog.getVersion() + 1L);
                    saveLogList.add(dbLog);
                    continue;
                }
                dbLog.setVersion(dbLog.getVersion() + 1L);
                saveLogList.add(dbLog);
                continue;
            }
            if (curdType == CurdType.DELETE) {
                saveLogList.add(this.genDraftLog(categoryType, categoryValue, primaryValue, tableName, CurdType.DELETE));
                continue;
            }
            if (curdType == CurdType.UPDATE) {
                saveLogList.add(this.genDraftLog(categoryType, categoryValue, primaryValue, tableName, CurdType.UPDATE));
                continue;
            }
            saveLogList.add(this.genDraftLog(categoryType, categoryValue, primaryValue, tableName, CurdType.ADD));
        }
        if (!CollectionUtils.isEmpty(deleteLogList)) {
            this.mFeadDao.delete(deleteLogList);
        }
        if (!CollectionUtils.isEmpty(saveLogList)) {
            this.mFeadDao.update(saveLogList);
        }
    }

    private void checkMasterData(FeadBase draftData, List<Long> masterPrimaryValues) {
        MasterData masterData = draftData.getMasterData();
        if (masterData == null || masterData.getMasterClass() == null || masterData.getMasterId() <= 0L) {
            return;
        }
        if (!masterPrimaryValues.contains(masterData.getMasterId())) {
            masterPrimaryValues.add(masterData.getMasterId());
        }
    }

    @Override
    public <T> int deleteAll(List<T> datas) {
        if (CollectionUtils.isEmpty(datas)) {
            logger.error("[DraftData->delete]delete draftData param is null");
            return 0;
        }
        Map<Class, List<T>> clz2DataMap = this.getMapDataGroupByClassType(datas);
        Class classType = null;
        Set<Map.Entry<Class, List<T>>> entrySet = clz2DataMap.entrySet();
        for (Map.Entry<Class, List<T>> entry : entrySet) {
            classType = entry.getKey();
            DataType dataType = this.mTableManager.getClassDataType(classType);
            if (dataType == null || dataType != DataType.DRAFT_BUSINESS) {
                this.mFeadDao.delete((Iterable)entry.getValue());
                continue;
            }
            this.deleteByPrimaryKeyAndDataList(classType, entry.getValue());
        }
        return datas.size();
    }

    private <T> Map<Class, List<T>> getMapDataGroupByClassType(List<T> datas) {
        HashMap clz2DataMap = new HashMap();
        datas.forEach(e -> {
            if (!clz2DataMap.containsKey(e.getClass())) {
                clz2DataMap.put(e.getClass(), new ArrayList());
            }
            ((List)clz2DataMap.get(e.getClass())).add(e);
        });
        return clz2DataMap;
    }

    @Override
    public int delete(FeadConditionDo draftConditionDo) {
        this.checkCondition(draftConditionDo);
        this.checkClassType(draftConditionDo.getClassType());
        DataType dataType = this.mTableManager.getClassDataType(draftConditionDo.getClassType());
        if (dataType == null || dataType != DataType.DRAFT_BUSINESS) {
            return this.mFeadDao.deleteByCondition(draftConditionDo);
        }
        List<FeadBase> draftBases = this.queryBase(false, draftConditionDo);
        if (CollectionUtils.isEmpty(draftBases)) {
            return 0;
        }
        return this.deleteByPrimaryKeyAndDataList(draftConditionDo.getClassType(), draftBases);
    }

    private void deleteDraftLog(int categoryType, long categoryValue, Class zClass, long id) {
        String tableName = this.mTableManager.getMappingTableName(zClass);
        FeadLogDdo draftLogDdo = this.mFeadDao.queryDraftLog(tableName, id);
        if (draftLogDdo != null) {
            if (draftLogDdo.getCurdType() == CurdType.ADD.ordinal()) {
                this.mFeadDao.deleteDraftLog(draftLogDdo);
            } else if (draftLogDdo.getCurdType() == CurdType.UPDATE.ordinal()) {
                draftLogDdo.setCurdType(CurdType.DELETE.ordinal());
                this.mFeadDao.updateDraftLog(draftLogDdo);
            }
        } else {
            this.mFeadDao.updateDraftLog(this.genDraftLog(categoryType, categoryValue, id, tableName, CurdType.DELETE));
        }
    }

    @Override
    public <T> List<T> query(FeadConditionDo draftConditionDo) {
        return this.queryBase(false, draftConditionDo);
    }

    @Override
    public <T> List<T> queryWithDataPublishStatus(boolean needSetPublishStatus, FeadConditionDo draftConditionDo) {
        return this.queryBase(needSetPublishStatus, draftConditionDo);
    }

    @Override
    public <T> FeadPageDo<T> query(FeadConditionDo draftConditionDo, int pageSize, int pageIndex) {
        return this.queryBase(draftConditionDo, pageSize, pageIndex);
    }

    @Override
    public <T> T querySingle(FeadConditionDo feadConditionDo) {
        this.checkCondition(feadConditionDo);
        Class classType = feadConditionDo.getClassType();
        String tableName = this.mTableManager.getMappingTableName(classType);
        Object data = this.mFeadDao.querySingle(feadConditionDo);
        if (data == null) {
            return null;
        }
        return (T)data;
    }

    @Override
    public <T> T queryById(long id, Class zClass) {
        this.checkClassType(zClass);
        return this.queryByIdBase(id, zClass);
    }

    private <T> T queryByIdBase(long id, Class zClass) {
        String primaryKey = this.mTableManager.getMappingPrimaryKey(zClass);
        FeadConditionDo feadConditionDo = new FeadConditionDo(zClass);
        feadConditionDo.addAnd(Comparator.EQ, primaryKey, id);
        Object data = this.mFeadDao.querySingle(feadConditionDo);
        if (data == null) {
            return null;
        }
        return (T)data;
    }

    @Override
    public long count(FeadConditionDo feadConditionDo) {
        return this.mFeadDao.getCount(feadConditionDo);
    }

    private <T> FeadPageDo<T> queryBase(FeadConditionDo feadConditionDo, int pageSize, int pageIndex) {
        this.checkCondition(feadConditionDo);
        Class classType = feadConditionDo.getClassType();
        this.checkClassType(classType);
        String tableName = this.mTableManager.getMappingTableName(classType);
        List<?> dataList = this.mFeadDao.queryListByPage(feadConditionDo, pageIndex, pageSize);
        long recordCount = this.mFeadDao.getCount(feadConditionDo);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        Integer categoryType = this.mTableManager.getCategoryType(classType);
        if (!CollectionUtils.isEmpty(dataList) && dataType != null && dataType == DataType.DRAFT_BUSINESS && categoryType != null) {
            this.setPublishStatus(categoryType, tableName, dataList);
        }
        return new FeadPageDo(dataList, pageIndex, pageSize, recordCount);
    }

    private <T> List<T> queryBase(boolean needSetPublishStatus, FeadConditionDo draftConditionDo) {
        this.checkCondition(draftConditionDo);
        Class classType = draftConditionDo.getClassType();
        this.checkClassType(classType);
        String tableName = this.mTableManager.getMappingTableName(classType);
        ArrayList dataList = this.mFeadDao.queryListByIndex(draftConditionDo, 0, Integer.MAX_VALUE);
        if (!needSetPublishStatus) {
            return CollectionUtils.isEmpty(dataList) ? new ArrayList() : dataList;
        }
        DataType dataType = this.mTableManager.getClassDataType(classType);
        Integer categoryType = this.mTableManager.getCategoryType(classType);
        if (!CollectionUtils.isEmpty(dataList) && dataType != null && dataType == DataType.DRAFT_BUSINESS && categoryType != null) {
            this.setPublishStatus(categoryType, tableName, dataList);
        }
        return CollectionUtils.isEmpty(dataList) ? new ArrayList() : dataList;
    }

    @Override
    public <T> List<T> queryAdd(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBase(classType, feadCategory, CurdType.ADD);
    }

    @Override
    public <T> List<T> queryUpdate(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBase(classType, feadCategory, CurdType.UPDATE);
    }

    @Override
    public List<Long> queryDelete(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBaseIds(classType, feadCategory, CurdType.DELETE);
    }

    @Override
    public List<Long> queryAddIds(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBaseIds(classType, feadCategory, CurdType.ADD);
    }

    @Override
    public List<Long> queryUpdateIds(Class classType, FeadCategory feadCategory) {
        return this.queryDraftBaseIds(classType, feadCategory, CurdType.UPDATE);
    }

    @Override
    public FeadPageDo queryModifyIds(Class classType, FeadCategory feadCategory, int pageId, int pageSize) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        this.checkDataType(dataType, DataType.DRAFT_BUSINESS, true);
        FeadPageDo feadPageDo = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, pageId, pageSize);
        ArrayList primaryValues = new ArrayList();
        feadPageDo.getData().forEach(feadLogDdo -> {
            FeadLogDdo logDdo = (FeadLogDdo)feadLogDdo;
            primaryValues.add(new FeadPrimaryValue((int)logDdo.getPrimaryValue(), logDdo.getCurdType()));
        });
        feadPageDo.setData(primaryValues);
        return feadPageDo;
    }

    @Override
    public List<FeadPrimaryValue> queryModifyIds(Class classType, FeadCategory feadCategory) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        this.checkDataType(dataType, DataType.DRAFT_BUSINESS, true);
        FeadPageDo feadPageDo = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, 1, Integer.MAX_VALUE);
        ArrayList<FeadPrimaryValue> primaryValues = new ArrayList<FeadPrimaryValue>();
        feadPageDo.getData().forEach(feadLogDdo -> {
            FeadLogDdo logDdo = (FeadLogDdo)feadLogDdo;
            primaryValues.add(new FeadPrimaryValue((int)logDdo.getPrimaryValue(), logDdo.getCurdType()));
        });
        return primaryValues;
    }

    private <T> List<T> queryDraftBase(Class<T> classType, FeadCategory feadCategory, CurdType curdType) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        String primaryKey = this.mTableManager.getMappingPrimaryKey(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        this.checkDataType(dataType, DataType.DRAFT_BUSINESS, true);
        List<FeadLogDdo> feadLogDdos = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, curdType);
        ArrayList primaryValues = new ArrayList();
        feadLogDdos.forEach(feadLogDdo -> primaryValues.add((int)feadLogDdo.getPrimaryValue()));
        if (primaryValues.isEmpty()) {
            return new ArrayList();
        }
        FeadConditionDo feadConditionDo = new FeadConditionDo(classType);
        feadConditionDo.addAnd(Comparator.IN, primaryKey, primaryValues);
        return this.query(feadConditionDo);
    }

    private List<Long> queryDraftBaseIds(Class classType, FeadCategory feadCategory, CurdType curdType) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        DataType dataType = this.mTableManager.getClassDataType(classType);
        this.checkDataType(dataType, DataType.DRAFT_BUSINESS, true);
        List<FeadLogDdo> feadLogDdos = this.mFeadDao.queryDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName, curdType);
        ArrayList<Long> primaryValues = new ArrayList<Long>();
        feadLogDdos.forEach(feadLogDdo -> primaryValues.add(feadLogDdo.getPrimaryValue()));
        return primaryValues;
    }

    @Override
    public long feadRecordCount(FeadCategory feadCategory, Class classType) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        return this.mFeadDao.countDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName);
    }

    @Override
    public long feadRecordCount(FeadCategory feadCategory) {
        return this.mFeadDao.countDraftLog(feadCategory.getType(), feadCategory.getValue(), null);
    }

    @Override
    public void clearEditRecord(FeadCategory feadCategory, Class ... excludeClass) {
        ArrayList<String> excludeTable = new ArrayList<String>();
        if (excludeClass != null) {
            for (Class c : excludeClass) {
                String tableName = this.mTableManager.getMappingTableName(c);
                excludeTable.add(tableName);
            }
        }
        this.mFeadDao.clearDraftLogWithExclude(feadCategory.getType(), feadCategory.getValue(), excludeTable);
    }

    @Override
    public void releaseSuccess(FeadCategory feadCategory, Class classType) {
        String tableName = this.mTableManager.getMappingTableName(classType);
        if (StringUtils.isEmpty((Object)tableName)) {
            return;
        }
        this.mFeadDao.clearDraftLog(feadCategory.getType(), feadCategory.getValue(), tableName);
    }

    @Override
    public void releaseSuccess(FeadCategory feadCategory) {
        this.mFeadDao.clearDraftLog(feadCategory.getType(), feadCategory.getValue(), null);
    }

    @Override
    public <T> void rollbackData(List<T> datas, CurdType curdType) {
        if (FeadUtil.isEmpty(datas)) {
            logger.error("[FeadData] rollbackData data is null ");
            throw new IllegalArgumentException("rollbackData is nul");
        }
        if (CurdType.UPDATE == curdType) {
            for (T val : datas) {
                Long primaryVal = this.getPrimaryValue(val);
                if (primaryVal == null) {
                    throw new IllegalArgumentException("primary value is empty");
                }
                T exists = this.queryById(primaryVal.intValue(), val.getClass());
                if (exists != null) {
                    this.getSession().saveOrUpdate(val);
                    continue;
                }
                this.getSession().save(val);
            }
        } else if (CurdType.ADD == curdType) {
            this.getSession().save(datas);
        } else if (CurdType.DELETE == curdType) {
            this.mFeadDao.delete(datas);
        }
    }

    private void setPublishStatus(Object data, String tableName) {
        if (data == null) {
            return;
        }
        if (!(data instanceof FeadBase)) {
            return;
        }
        FeadBase dataBase = (FeadBase)data;
        if (dataBase.dataType() != DataType.DRAFT_BUSINESS) {
            return;
        }
        Long primaryValue = this.getPrimaryValue(data);
        if (primaryValue == null) {
            return;
        }
        FeadLogDdo feadLogDdo = this.mFeadDao.queryDraftLog(tableName, primaryValue);
        FeadUtil.setFieldValueByName("publishStatus", feadLogDdo == null ? 1 : 0, data);
    }

    private void setPublishStatus(int categoryType, String tableName, List<?> datas) {
        if (CollectionUtils.isEmpty(datas)) {
            return;
        }
        FeadBase feadData = (FeadBase)datas.get(0);
        long categoryValue = feadData.categoryValue();
        List<FeadLogDdo> feadLogDdos = this.mFeadDao.queryDraftLogByTable(categoryType, categoryValue, tableName);
        HashSet feadValues = new HashSet();
        if (!CollectionUtils.isEmpty(feadLogDdos)) {
            feadLogDdos.forEach(feadLogDdo -> feadValues.add(feadLogDdo.getPrimaryValue()));
        }
        datas.forEach(data -> {
            if (!(data instanceof FeadBase)) {
                return;
            }
            Long primaryValue = this.getPrimaryValue(data);
            if (primaryValue != null) {
                FeadUtil.setFieldValueByName("publishStatus", feadValues.contains(primaryValue) ? 0 : 1, data);
            }
        });
    }

    private Long getPrimaryValue(Object draftData) {
        String primaryKey = this.mTableManager.getMappingPrimaryKey(draftData.getClass());
        Object primaryValue = FeadUtil.getFieldValueByName(primaryKey, draftData);
        if (primaryValue == null) {
            return null;
        }
        if (primaryValue instanceof Integer) {
            Integer value = (Integer)primaryValue;
            if (value == 0) {
                return null;
            }
            return value.longValue();
        }
        if (primaryValue instanceof Long) {
            Long value = (Long)primaryValue;
            if (value == 0L) {
                return null;
            }
            return value;
        }
        throw new FeadException("primaryKey Type Error table:" + draftData.getClass().getName());
    }

    private void checkCondition(FeadConditionDo draftConditionDo) {
        if (draftConditionDo == null) {
            logger.error("[FeaodData] DraftConditionDo is null");
            throw new IllegalArgumentException("DraftConditionDo is nul");
        }
    }

    private void checkClassType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeaodData] ClassType empty");
            throw new IllegalArgumentException("ClassType empty");
        }
    }

    private void checkCategoryType(int categoryType) {
        if (categoryType == 0) {
            logger.error("[FeaodData] categoryType empty");
            throw new IllegalArgumentException("categoryType empty");
        }
    }

    private void checkCategoryValue(long categoryValue) {
        if (categoryValue == 0L) {
            logger.error("[FeaodData] categoryValue empty");
            throw new IllegalArgumentException("categoryValue empty");
        }
    }

    private void checkDataType(DataType dataType, DataType checkType, boolean needEqual) {
        boolean bOk;
        if (dataType == null) {
            logger.error("[FeaodData] the class data type is null ");
            throw new IllegalArgumentException("the class data type is null");
        }
        boolean bl = needEqual ? dataType == checkType : (bOk = dataType != checkType);
        if (!bOk) {
            logger.error("[FeaodData]the data type not fit use other interface ");
            throw new IllegalArgumentException("the data type not fit use other interface");
        }
    }
}

