/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft;

import com.common.draft.FeadException;
import com.common.draft.model.DataType;
import com.common.draft.model.MasterData;
import com.common.draft.utils.FeadUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class FeadTableManager {
    private String _scanPackages;
    private ConcurrentHashMap<String, Class<?>> tableClassMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> className2TableMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Class, Field> tablePrimaryKeyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Class, Integer> classType2CategoryTypeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Class, MasterData> classType2MasterDataMap = new ConcurrentHashMap();
    private HashMap<Class, DataType> mClassDataType = new HashMap();
    private HashMap<Integer, String> mCategoryColumn = new HashMap();
    private static final Logger logger = LogManager.getLogger(FeadTableManager.class);

    public FeadTableManager(String scanPackages) {
        this._scanPackages = scanPackages;
        this.readTableInfo();
    }

    public String getMappingTableName(Class<?> clazz) {
        String tableName = this.className2TableMap.get(clazz.getName());
        if (FeadUtil.isEmpty(tableName)) {
            logger.error("[FeadData->getMappingTableName]: can't find table Name");
            throw new FeadException("can't find table Name");
        }
        return tableName;
    }

    public Class<?> getMappingClass(String tableName) {
        if (this.tableClassMap == null) {
            return null;
        }
        Class<?> zClass = this.tableClassMap.get(tableName);
        if (zClass == null) {
            logger.error("[FeadData->getMappingClass]: can't find Class");
            throw new FeadException("can't find Class");
        }
        return zClass;
    }

    public String getMappingPrimaryKey(Class zClass) {
        if (this.tablePrimaryKeyMap == null) {
            return null;
        }
        String primaryKey = this.tablePrimaryKeyMap.get(zClass).getName();
        if (FeadUtil.isEmpty(primaryKey)) {
            logger.error("[FeadData->getMappingTableName]: can't find primary key");
            throw new FeadException("can't find primary key");
        }
        return primaryKey;
    }

    public DataType getClassDataType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeadData->getClassDataType]: Class is null:");
            throw new FeadException("Class is null");
        }
        DataType dataType = this.mClassDataType.get(zClass);
        if (dataType == null) {
            logger.error("[FeadData->getClassDataType]: Class DataType is null:{}", (Object)zClass.getName());
            throw new FeadException("Class DataType is nul");
        }
        return dataType;
    }

    public Integer getCategoryType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeadData->getClassDataType]: Class is null:");
            throw new FeadException("Class is null");
        }
        Integer categoryType = this.classType2CategoryTypeMap.get(zClass);
        if (categoryType == null) {
            logger.error("[FeadData->getClassDataType]: Class CategoryType is null:{}", (Object)zClass.getName());
            return null;
        }
        return categoryType;
    }

    public MasterData getMasterDataByClassType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeadData->getMasterDataByClassType]: Class is null:");
            throw new FeadException("Class is null");
        }
        return this.classType2MasterDataMap.get(zClass);
    }

    private void checkTableDataType(Map<String, Class<?>> tableClass) {
        for (Map.Entry<String, Class<?>> entry : tableClass.entrySet()) {
            Class<?> classType = entry.getValue();
            try {
                Object instance = classType.newInstance();
                DataType dataType = (DataType)((Object)FeadUtil.callMethodByName("dataType", instance));
                Object category = FeadUtil.callMethodByName("categoryType", instance);
                Object masterData = FeadUtil.callMethodByName("getMasterData", instance);
                this.mClassDataType.put(classType, dataType);
                if (category != null) {
                    this.classType2CategoryTypeMap.put(classType, (int)((Integer)category));
                }
                if (masterData == null) continue;
                this.classType2MasterDataMap.put(classType, (MasterData)masterData);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private void readTableInfo() {
        String[] packagesToScan = this._scanPackages.split(",");
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().addScanners(new Scanner[]{new FieldAnnotationsScanner()});
        for (String packageToScan : packagesToScan) {
            configurationBuilder.addUrls(ClasspathHelper.forPackage((String)packageToScan, (ClassLoader[])new ClassLoader[0]));
        }
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set classes = reflections.getTypesAnnotatedWith(Table.class);
        for (Class clazz : classes) {
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) continue;
            this.tableClassMap.put(table.name(), clazz);
            this.className2TableMap.put(clazz.getName(), table.name());
        }
        Set fields = reflections.getFieldsAnnotatedWith(Id.class);
        for (Field field : fields) {
            this.tablePrimaryKeyMap.put(field.getDeclaringClass(), field);
        }
        this.checkTableDataType(this.tableClassMap);
    }
}

