/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft.config;

import com.common.draft.FeadBase;
import java.io.Serializable;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class AuditInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 6892420119984901561L;

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (entity instanceof FeadBase) {
            if (!((FeadBase)entity).writeTimeStamp()) {
                return false;
            }
            for (int i = 0; i < propertyNames.length; ++i) {
                if (!"updateTime".equals(propertyNames[i])) continue;
                currentState[i] = (int)(System.currentTimeMillis() / 1000L);
                return true;
            }
        }
        return false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof FeadBase) {
            if (!((FeadBase)entity).writeTimeStamp()) {
                return false;
            }
            boolean crtModify = false;
            boolean uptModify = false;
            int i = 0;
            while (true) {
                if (i >= propertyNames.length) {
                    if (!crtModify && !uptModify) break;
                    return true;
                }
                if ("createTime".equals(propertyNames[i])) {
                    crtModify = true;
                    state[i] = (int)(System.currentTimeMillis() / 1000L);
                }
                if ("updateTime".equals(propertyNames[i])) {
                    uptModify = true;
                    state[i] = (int)(System.currentTimeMillis() / 1000L);
                }
                ++i;
            }
        }
        return false;
    }
}

