package com.common.draft;


import com.common.draft.model.DataType;
import com.common.draft.model.MasterData;
import com.common.draft.model.UpperData;

/**
 * 使用数据组件的顶层接口
 *
 * @author Administrator
 */
public interface FeadBase {

    /**
     * 控制是否需要写操作记录
     **/
    default DataType dataType() {
        return DataType.MANAGER;
    }

    /**
     * 数据分组
     **/
    default int categoryType() {
        return 0;
    }

    /**
     * 数据分组值
     **/
    default long categoryValue() {
        return 0;
    }

    /**
     * 主表数据
     *
     * @return
     */
    default MasterData getMasterData() {
        return null;
    }

    /**
     * 外部设置上层数据
     *
     * @param upperId
     * @param clazz
     */
    default void setUpperData(int upperId, Class clazz) {
    }

    /**
     * 主表（上层）数据
     *
     * @return
     */
    default UpperData getUpperData() {
        return null;
    }

    /**
     * 数据主键值
     *
     * @return
     */
    default long getPrimaryValue() {
        return 0;
    }

    /**
     * 控制是否需要自动写入createTime和updateTime
     *
     * @return
     */
    default boolean writeTimeStamp() {
        return true;
    }
}
