package com.common.draft;

import com.common.draft.model.DataType;
import com.common.draft.model.MasterData;
import com.common.draft.model.UpperData;
import com.common.draft.utils.FeadUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Table;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class FeadTableManager {

    private String _scanPackages;

    private ConcurrentHashMap<String, Class<?>> tableClassMap = new ConcurrentHashMap<String, Class<?>>();

    /**
     * ClassName-TableName
     */
    private ConcurrentHashMap<String, String> className2TableMap = new ConcurrentHashMap<String, String>();

    private ConcurrentHashMap<Class, Field> tablePrimaryKeyMap = new ConcurrentHashMap<Class, Field>();

    private ConcurrentHashMap<Class, Integer> classType2CategoryTypeMap = new ConcurrentHashMap<Class, Integer>();

    private ConcurrentHashMap<Class, MasterData> classType2MasterDataMap = new ConcurrentHashMap<Class, MasterData>();

    private ConcurrentHashMap<Class, UpperData> classType2UpperDataMap = new ConcurrentHashMap<Class, UpperData>();

    private HashMap<Class, DataType> mClassDataType = new HashMap<Class, DataType>();

    private HashMap<Integer, String> mCategoryColumn = new HashMap<Integer, String>();

    private static final Logger logger = LogManager.getLogger(FeadTableManager.class);

    public FeadTableManager(String scanPackages) {
        _scanPackages = scanPackages;
        readTableInfo();
    }

    public String getMappingTableName(Class<?> clazz) {
//        String tableName = null;
//        Iterator iterator = tableClassMap.entrySet().iterator();
//        while (iterator.hasNext()) {
//            Map.Entry entry = (Map.Entry) iterator.next();
//            Class<?> classType = (Class<?>) entry.getValue();
//            if (classType.getName().equals(clazz.getName())) {
//                tableName = (String) entry.getKey();
//                break;
//            }
//        }
        String tableName = className2TableMap.get(clazz.getName());
        if (FeadUtil.isEmpty(tableName)) {
            logger.error("[FeadData->getMappingTableName]: can't find table Name");
            throw new FeadException("can't find table Name");
        }
        return tableName;
    }

    public Class<?> getMappingClass(String tableName) {
        if (tableClassMap == null) {
            return null;
        }
        Class zClass = tableClassMap.get(tableName);
        if (zClass == null) {
            logger.error("[FeadData->getMappingClass]: can't find Class");
            throw new FeadException("can't find Class");
        }
        return zClass;
    }

    public String getMappingPrimaryKey(Class zClass) {
        if (tablePrimaryKeyMap == null) {
            return null;
        }

        String primaryKey = tablePrimaryKeyMap.get(zClass).getName();

        if (FeadUtil.isEmpty(primaryKey)) {
            logger.error("[FeadData->getMappingTableName]: can't find primary key");
            throw new FeadException("can't find primary key");
        }
        return primaryKey;
    }


    /**
     * Data Type
     ***/
    public DataType getClassDataType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeadData->getClassDataType]: Class is null:");
            throw new FeadException("Class is null");
        }
        DataType dataType = mClassDataType.get(zClass);
        if (dataType == null) {
            logger.error("[FeadData->getClassDataType]: Class DataType is null:{}", zClass.getName());
            throw new FeadException("Class DataType is nul");
        }

        return dataType;
    }

    public Integer getCategoryType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeadData->getClassDataType]: Class is null:");
            throw new FeadException("Class is null");
        }
        Integer categoryType = classType2CategoryTypeMap.get(zClass);
        if (categoryType == null) {
            logger.error("[FeadData->getClassDataType]: Class CategoryType is null:{}", zClass.getName());
            return null;
        }
        return categoryType;
    }

    public MasterData getMasterDataByClassType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeadData->getMasterDataByClassType]: Class is null:");
            throw new FeadException("Class is null");
        }

        return classType2MasterDataMap.get(zClass);
    }

    public UpperData getUpperDataByClassType(Class zClass) {
        if (zClass == null) {
            logger.error("[FeadData->getUpperDataByClassType]: Class is null:");
            throw new FeadException("Class is null");
        }

        return classType2UpperDataMap.get(zClass);
    }

    private void checkTableDataType(Map<String, Class<?>> tableClass) {
        Iterator iterator = tableClass.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry) iterator.next();
            Class<?> classType = (Class<?>) entry.getValue();
            try {
                Object instance = classType.newInstance();
                DataType dataType = (DataType) FeadUtil.callMethodByName("dataType", instance);
                Object category = FeadUtil.callMethodByName("categoryType", instance);
                Object masterData = FeadUtil.callMethodByName("getMasterData", instance);
                Object upperData = FeadUtil.callMethodByName("getUpperData", instance);
                mClassDataType.put(classType, dataType);
                if (category != null) {
                    classType2CategoryTypeMap.put(classType, (int) category);
                }
                if (masterData != null) {
                    classType2MasterDataMap.put(classType, (MasterData) masterData);
                }
                if (upperData != null) {
                    classType2UpperDataMap.put(classType, (UpperData) upperData);
                }
            } catch (Exception e) {
                logger.error(e);
            }
        }
    }

    private void readTableInfo() {
        String[] packagesToScan = _scanPackages.split(",");
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder()
                .addScanners(new FieldAnnotationsScanner());
        for (String packageToScan : packagesToScan) {
            configurationBuilder.addUrls(ClasspathHelper.forPackage(packageToScan));
        }

        Reflections reflections = new Reflections(configurationBuilder);
        Set<Class<?>> classes = reflections.getTypesAnnotatedWith(javax.persistence.Table.class);
        for (Class<?> clazz : classes) {
            Table table = clazz.getAnnotation(Table.class);
            if (table != null) {
                tableClassMap.put(table.name(), clazz);
                className2TableMap.put(clazz.getName(), table.name());
            }
        }

        Set<Field> fields = reflections.getFieldsAnnotatedWith(javax.persistence.Id.class);
        for (Field field : fields) {
            tablePrimaryKeyMap.put(field.getDeclaringClass(), field);
        }

        checkTableDataType(tableClassMap);
    }

}
