/*
 * Decompiled with CFR 0.152.
 */
package com.common.draft.config;

import com.common.draft.FeadTableManager;
import com.common.draft.config.AbstractConfig;
import com.common.draft.config.AuditInterceptor;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class FeadBeanConfig
extends AbstractConfig {
    protected boolean _useCache = true;
    protected String _scanPackages;

    public FeadBeanConfig() {
        super("fead");
    }

    @Bean(value={"feadEntityManager"})
    public EntityManager entityManager(@Qualifier(value="feadSessionFactory") EntityManagerFactory entityManagerFactory) {
        return entityManagerFactory.createEntityManager();
    }

    @Bean(name={"feadDataSource"})
    public DataSource feadDataSource() {
        return this.getDataSource();
    }

    @Bean(name={"feadSessionFactory"})
    public FactoryBean<SessionFactory> feadFactory() {
        return this.getSessionFactory(this.feadDataSource());
    }

    @Bean(name={"feadTransactionManager"})
    public PlatformTransactionManager feadTransactionManager() throws Exception {
        return this.getTransactionManager((SessionFactory)this.feadFactory().getObject());
    }

    @Bean(name={"feadTableManager"})
    public FeadTableManager feadTableManager() {
        return this.getTableManager();
    }

    public FactoryBean<SessionFactory> getSessionFactory(DataSource dataSource) {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        String scanPackages = this.getStringConfig("db.scanPackages", "");
        scanPackages = Joiner.on((String)",").skipNulls().join((Object)Strings.emptyToNull((String)scanPackages), (Object)"com.common.draft.model.ddo", new Object[0]);
        if (!Strings.isNullOrEmpty((String)scanPackages)) {
            sessionFactoryBean.setPackagesToScan(scanPackages.split(","));
        }
        sessionFactoryBean.setHibernateProperties(this.getDBProperties());
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setEntityInterceptor((Interceptor)new AuditInterceptor());
        this._scanPackages = scanPackages;
        this._useCache = this.getBoolConfig("db.usecache", true);
        return sessionFactoryBean;
    }

    public FeadTableManager getTableManager() {
        return new FeadTableManager(this._scanPackages);
    }

    public boolean getUseCache() {
        return this._useCache;
    }
}

