/*
 * Decompiled with CFR 0.152.
 */
package com.common.htmlsanitizer;

import com.common.htmlsanitizer.Strings;
import com.common.htmlsanitizer.TCB;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

@TCB
public final class CssSchema {
    static final int BIT_QUANTITY = 1;
    static final int BIT_HASH_VALUE = 2;
    static final int BIT_NEGATIVE = 4;
    static final int BIT_STRING = 8;
    static final int BIT_URL = 16;
    static final int BIT_UNRESERVED_WORD = 64;
    static final int BIT_UNICODE_RANGE = 128;
    static final Property DISALLOWED = new Property(0, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableMap<String, String>)ImmutableMap.of());
    private final ImmutableMap<String, Property> properties;
    static final ImmutableMap<String, Property> DEFINITIONS;
    static final ImmutableSet<String> DEFAULT_WHITELIST;
    public static final CssSchema DEFAULT;

    private CssSchema(ImmutableMap<String, Property> properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.properties = properties;
    }

    public static CssSchema withProperties(Iterable<? extends String> propertyNames) {
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        for (String string : propertyNames) {
            Property prop = (Property)DEFINITIONS.get((Object)string);
            if (prop == null) {
                throw new IllegalArgumentException(string);
            }
            propertiesBuilder.put((Object)string, (Object)prop);
        }
        return new CssSchema((ImmutableMap<String, Property>)propertiesBuilder.build());
    }

    public static CssSchema withProperties(Map<? extends String, ? extends Property> properties) {
        ImmutableMap propertyMap = ImmutableMap.copyOf(properties);
        for (Map.Entry e : propertyMap.entrySet()) {
            Property property = (Property)e.getValue();
            for (String fnKey : property.fnKeys.values()) {
                if (propertyMap.containsKey((Object)fnKey)) continue;
                throw new IllegalArgumentException("Property map is not self contained.  " + e.getValue() + " depends on undefined function key " + fnKey);
            }
        }
        return new CssSchema((ImmutableMap<String, Property>)propertyMap);
    }

    public static CssSchema union(CssSchema ... cssSchemas) {
        if (cssSchemas.length == 1) {
            return cssSchemas[0];
        }
        LinkedHashMap properties = Maps.newLinkedHashMap();
        for (CssSchema cssSchema : cssSchemas) {
            for (Map.Entry e : cssSchema.properties.entrySet()) {
                String name = (String)e.getKey();
                Property newProp = (Property)e.getValue();
                Preconditions.checkNotNull((Object)name);
                Preconditions.checkNotNull((Object)newProp);
                Property oldProp = properties.put(name, newProp);
                if (oldProp == null || oldProp.equals(newProp)) continue;
                throw new IllegalArgumentException("Duplicate irreconcilable definitions for " + name);
            }
        }
        return new CssSchema((ImmutableMap<String, Property>)ImmutableMap.copyOf((Map)properties));
    }

    public Set<String> allowedProperties() {
        return this.properties.keySet();
    }

    Property forKey(String propertyName) {
        String barePropertyNameCanon;
        String propertyNameCanon = Strings.toLowerCase(propertyName);
        Property property = (Property)this.properties.get((Object)propertyNameCanon);
        if (property != null) {
            return property;
        }
        int n = propertyNameCanon.length();
        if (n != 0 && propertyNameCanon.charAt(0) == '-' && (property = (Property)this.properties.get((Object)(barePropertyNameCanon = CssSchema.stripVendorPrefix(propertyNameCanon)))) != null) {
            return property;
        }
        return DISALLOWED;
    }

    @Nullable
    private static String stripVendorPrefix(String cssKeyword) {
        int prefixLen = 0;
        if (cssKeyword.length() >= 2) {
            switch (cssKeyword.charAt(1)) {
                case 'm': {
                    if (cssKeyword.startsWith("-ms-")) {
                        prefixLen = 4;
                        break;
                    }
                    if (!cssKeyword.startsWith("-moz-")) break;
                    prefixLen = 5;
                    break;
                }
                case 'o': {
                    if (!cssKeyword.startsWith("-o-")) break;
                    prefixLen = 3;
                    break;
                }
                case 'w': {
                    if (!cssKeyword.startsWith("-webkit-")) break;
                    prefixLen = 8;
                    break;
                }
            }
        }
        return prefixLen == 0 ? null : cssKeyword.substring(prefixLen);
    }

    private static <T> ImmutableSet<T> union(ImmutableSet<T> ... subsets) {
        ImmutableSet.Builder all = ImmutableSet.builder();
        for (ImmutableSet<T> subset : subsets) {
            all.addAll(subset);
        }
        return all.build();
    }

    public static void main(String ... argv) {
        TreeSet keys = Sets.newTreeSet();
        TreeSet literals = Sets.newTreeSet();
        for (Map.Entry e : DEFINITIONS.entrySet()) {
            keys.add(e.getKey());
            literals.addAll(((Property)e.getValue()).literals);
        }
        System.out.println("# Below two blocks of tokens.\n#\n# First are all property names.\n# Those followed by an asterisk (*) are in the default white-list.\n#\n# Second are the literal tokens recognized in any defined property\n# value.\n");
        for (String key : keys) {
            System.out.print(key);
            if (DEFAULT_WHITELIST.contains((Object)key)) {
                System.out.print("*");
            }
            System.out.println();
        }
        System.out.println();
        for (String literal : literals) {
            System.out.println(literal);
        }
    }

    static {
        ImmutableMap zeroFns = ImmutableMap.of();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableSet mozBorderRadiusLiterals0 = ImmutableSet.of((Object)"/");
        ImmutableSet mozOpacityLiterals0 = ImmutableSet.of((Object)"inherit");
        ImmutableSet mozOutlineLiterals0 = ImmutableSet.of((Object)"aliceblue", (Object)"antiquewhite", (Object)"aqua", (Object)"aquamarine", (Object)"azure", (Object)"beige", (Object[])new String[]{"bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen"});
        ImmutableSet mozOutlineLiterals1 = ImmutableSet.of((Object)"dashed", (Object)"dotted", (Object)"double", (Object)"groove", (Object)"outset", (Object)"ridge", (Object[])new String[]{"solid"});
        ImmutableSet mozOutlineLiterals2 = ImmutableSet.of((Object)"thick", (Object)"thin");
        ImmutableSet mozOutlineLiterals3 = ImmutableSet.of((Object)"hidden", (Object)"inherit", (Object)"inset", (Object)"invert", (Object)"medium", (Object)"none", (Object[])new String[0]);
        ImmutableMap mozOutlineFunctions = ImmutableMap.of((Object)"rgb(", (Object)"rgb()", (Object)"rgba(", (Object)"rgba()", (Object)"hsl(", (Object)"hsl()", (Object)"hsla(", (Object)"hsla()");
        ImmutableSet mozOutlineColorLiterals0 = ImmutableSet.of((Object)"inherit", (Object)"invert");
        ImmutableSet mozOutlineStyleLiterals0 = ImmutableSet.of((Object)"hidden", (Object)"inherit", (Object)"inset", (Object)"none");
        ImmutableSet mozOutlineWidthLiterals0 = ImmutableSet.of((Object)"inherit", (Object)"medium");
        ImmutableSet oTextOverflowLiterals0 = ImmutableSet.of((Object)"clip", (Object)"ellipsis");
        ImmutableSet azimuthLiterals0 = ImmutableSet.of((Object)"behind", (Object)"center-left", (Object)"center-right", (Object)"far-left", (Object)"far-right", (Object)"left-side", (Object[])new String[]{"leftwards", "right-side", "rightwards"});
        ImmutableSet azimuthLiterals1 = ImmutableSet.of((Object)"left", (Object)"right");
        ImmutableSet azimuthLiterals2 = ImmutableSet.of((Object)"center", (Object)"inherit");
        ImmutableSet backgroundLiterals0 = ImmutableSet.of((Object)"border-box", (Object)"contain", (Object)"content-box", (Object)"cover", (Object)"padding-box");
        ImmutableSet backgroundLiterals1 = ImmutableSet.of((Object)"no-repeat", (Object)"repeat-x", (Object)"repeat-y", (Object)"round", (Object)"space");
        ImmutableSet backgroundLiterals2 = ImmutableSet.of((Object)"bottom", (Object)"top");
        ImmutableSet backgroundLiterals3 = ImmutableSet.of((Object)",", (Object)"/", (Object)"auto", (Object)"center", (Object)"fixed", (Object)"inherit", (Object[])new String[]{"local", "none", "repeat", "scroll", "transparent"});
        ImmutableMap backgroundFunctions = ImmutableMap.builder().put((Object)"image(", (Object)"image()").put((Object)"linear-gradient(", (Object)"linear-gradient()").put((Object)"radial-gradient(", (Object)"radial-gradient()").put((Object)"repeating-linear-gradient(", (Object)"repeating-linear-gradient()").put((Object)"repeating-radial-gradient(", (Object)"repeating-radial-gradient()").put((Object)"rgb(", (Object)"rgb()").put((Object)"rgba(", (Object)"rgba()").put((Object)"hsl(", (Object)"hsl()").put((Object)"hsla(", (Object)"hsla()").build();
        ImmutableSet backgroundAttachmentLiterals0 = ImmutableSet.of((Object)",", (Object)"fixed", (Object)"local", (Object)"scroll");
        ImmutableSet backgroundColorLiterals0 = ImmutableSet.of((Object)"inherit", (Object)"transparent");
        ImmutableSet backgroundImageLiterals0 = ImmutableSet.of((Object)",", (Object)"none");
        ImmutableMap backgroundImageFunctions = ImmutableMap.of((Object)"image(", (Object)"image()", (Object)"linear-gradient(", (Object)"linear-gradient()", (Object)"radial-gradient(", (Object)"radial-gradient()", (Object)"repeating-linear-gradient(", (Object)"repeating-linear-gradient()", (Object)"repeating-radial-gradient(", (Object)"repeating-radial-gradient()");
        ImmutableSet backgroundPositionLiterals0 = ImmutableSet.of((Object)",", (Object)"center");
        ImmutableSet backgroundRepeatLiterals0 = ImmutableSet.of((Object)",", (Object)"repeat");
        ImmutableSet borderLiterals0 = ImmutableSet.of((Object)"hidden", (Object)"inherit", (Object)"inset", (Object)"medium", (Object)"none", (Object)"transparent", (Object[])new String[0]);
        ImmutableSet borderCollapseLiterals0 = ImmutableSet.of((Object)"collapse", (Object)"inherit", (Object)"separate");
        ImmutableSet bottomLiterals0 = ImmutableSet.of((Object)"auto", (Object)"inherit");
        ImmutableSet boxShadowLiterals0 = ImmutableSet.of((Object)",", (Object)"inset", (Object)"none");
        ImmutableSet clearLiterals0 = ImmutableSet.of((Object)"both", (Object)"inherit", (Object)"none");
        ImmutableMap clipFunctions = ImmutableMap.of((Object)"rect(", (Object)"rect()");
        ImmutableSet contentLiterals0 = ImmutableSet.of((Object)"none", (Object)"normal");
        ImmutableSet cueLiterals0 = ImmutableSet.of((Object)"inherit", (Object)"none");
        ImmutableSet cursorLiterals0 = ImmutableSet.of((Object)"all-scroll", (Object)"col-resize", (Object)"crosshair", (Object)"default", (Object)"e-resize", (Object)"hand", (Object[])new String[]{"help", "move", "n-resize", "ne-resize", "no-drop", "not-allowed", "nw-resize", "pointer", "progress", "row-resize", "s-resize", "se-resize", "sw-resize", "text", "vertical-text", "w-resize", "wait"});
        ImmutableSet cursorLiterals1 = ImmutableSet.of((Object)",", (Object)"auto", (Object)"inherit");
        ImmutableSet directionLiterals0 = ImmutableSet.of((Object)"ltr", (Object)"rtl");
        ImmutableSet displayLiterals0 = ImmutableSet.of((Object)"-moz-inline-box", (Object)"-moz-inline-stack", (Object)"block", (Object)"inline", (Object)"inline-block", (Object)"inline-table", (Object[])new String[]{"list-item", "run-in", "table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row", "table-row-group"});
        ImmutableSet elevationLiterals0 = ImmutableSet.of((Object)"above", (Object)"below", (Object)"higher", (Object)"level", (Object)"lower");
        ImmutableSet emptyCellsLiterals0 = ImmutableSet.of((Object)"hide", (Object)"show");
        ImmutableSet fontLiterals0 = ImmutableSet.of((Object)"100", (Object)"200", (Object)"300", (Object)"400", (Object)"500", (Object)"600", (Object[])new String[]{"700", "800", "900", "bold", "bolder", "lighter"});
        ImmutableSet fontLiterals1 = ImmutableSet.of((Object)"large", (Object)"larger", (Object)"small", (Object)"smaller", (Object)"x-large", (Object)"x-small", (Object[])new String[]{"xx-large", "xx-small"});
        ImmutableSet fontLiterals2 = ImmutableSet.of((Object)"caption", (Object)"icon", (Object)"menu", (Object)"message-box", (Object)"small-caption", (Object)"status-bar", (Object[])new String[0]);
        ImmutableSet fontLiterals3 = ImmutableSet.of((Object)"cursive", (Object)"fantasy", (Object)"monospace", (Object)"sans-serif", (Object)"serif");
        ImmutableSet fontLiterals4 = ImmutableSet.of((Object)"italic", (Object)"oblique");
        ImmutableSet fontLiterals5 = ImmutableSet.of((Object)",", (Object)"/", (Object)"inherit", (Object)"medium", (Object)"normal", (Object)"small-caps", (Object[])new String[0]);
        ImmutableSet fontFamilyLiterals0 = ImmutableSet.of((Object)",", (Object)"inherit");
        ImmutableSet fontStretchLiterals0 = ImmutableSet.of((Object)"condensed", (Object)"expanded", (Object)"extra-condensed", (Object)"extra-expanded", (Object)"narrower", (Object)"semi-condensed", (Object[])new String[]{"semi-expanded", "ultra-condensed", "ultra-expanded", "wider"});
        ImmutableSet fontStretchLiterals1 = ImmutableSet.of((Object)"normal");
        ImmutableSet fontStyleLiterals0 = ImmutableSet.of((Object)"inherit", (Object)"normal");
        ImmutableSet fontVariantLiterals0 = ImmutableSet.of((Object)"inherit", (Object)"normal", (Object)"small-caps");
        ImmutableSet listStyleLiterals0 = ImmutableSet.of((Object)"armenian", (Object)"cjk-decimal", (Object)"decimal", (Object)"decimal-leading-zero", (Object)"disc", (Object)"disclosure-closed", (Object[])new String[]{"disclosure-open", "ethiopic-numeric", "georgian", "hebrew", "hiragana", "hiragana-iroha", "japanese-formal", "japanese-informal", "katakana", "katakana-iroha", "korean-hangul-formal", "korean-hanja-formal", "korean-hanja-informal", "lower-alpha", "lower-greek", "lower-latin", "lower-roman", "simp-chinese-formal", "simp-chinese-informal", "square", "trad-chinese-formal", "trad-chinese-informal", "upper-alpha", "upper-latin", "upper-roman"});
        ImmutableSet listStyleLiterals1 = ImmutableSet.of((Object)"inside", (Object)"outside");
        ImmutableSet listStyleLiterals2 = ImmutableSet.of((Object)"circle", (Object)"inherit", (Object)"none");
        ImmutableSet maxHeightLiterals0 = ImmutableSet.of((Object)"auto", (Object)"inherit", (Object)"none");
        ImmutableSet overflowLiterals0 = ImmutableSet.of((Object)"auto", (Object)"hidden", (Object)"inherit", (Object)"scroll", (Object)"visible");
        ImmutableSet overflowXLiterals0 = ImmutableSet.of((Object)"no-content", (Object)"no-display");
        ImmutableSet overflowXLiterals1 = ImmutableSet.of((Object)"auto", (Object)"hidden", (Object)"scroll", (Object)"visible");
        ImmutableSet pageBreakAfterLiterals0 = ImmutableSet.of((Object)"always", (Object)"auto", (Object)"avoid", (Object)"inherit");
        ImmutableSet pageBreakInsideLiterals0 = ImmutableSet.of((Object)"auto", (Object)"avoid", (Object)"inherit");
        ImmutableSet pitchLiterals0 = ImmutableSet.of((Object)"high", (Object)"low", (Object)"x-high", (Object)"x-low");
        ImmutableSet playDuringLiterals0 = ImmutableSet.of((Object)"auto", (Object)"inherit", (Object)"mix", (Object)"none", (Object)"repeat");
        ImmutableSet positionLiterals0 = ImmutableSet.of((Object)"absolute", (Object)"relative", (Object)"static");
        ImmutableSet speakLiterals0 = ImmutableSet.of((Object)"inherit", (Object)"none", (Object)"normal", (Object)"spell-out");
        ImmutableSet speakHeaderLiterals0 = ImmutableSet.of((Object)"always", (Object)"inherit", (Object)"once");
        ImmutableSet speakNumeralLiterals0 = ImmutableSet.of((Object)"continuous", (Object)"digits");
        ImmutableSet speakPunctuationLiterals0 = ImmutableSet.of((Object)"code", (Object)"inherit", (Object)"none");
        ImmutableSet speechRateLiterals0 = ImmutableSet.of((Object)"fast", (Object)"faster", (Object)"slow", (Object)"slower", (Object)"x-fast", (Object)"x-slow", (Object[])new String[0]);
        ImmutableSet tableLayoutLiterals0 = ImmutableSet.of((Object)"auto", (Object)"fixed", (Object)"inherit");
        ImmutableSet textAlignLiterals0 = ImmutableSet.of((Object)"center", (Object)"inherit", (Object)"justify");
        ImmutableSet textDecorationLiterals0 = ImmutableSet.of((Object)"blink", (Object)"line-through", (Object)"overline", (Object)"underline");
        ImmutableSet textTransformLiterals0 = ImmutableSet.of((Object)"capitalize", (Object)"lowercase", (Object)"uppercase");
        ImmutableSet textWrapLiterals0 = ImmutableSet.of((Object)"suppress", (Object)"unrestricted");
        ImmutableSet unicodeBidiLiterals0 = ImmutableSet.of((Object)"bidi-override", (Object)"embed");
        ImmutableSet verticalAlignLiterals0 = ImmutableSet.of((Object)"baseline", (Object)"middle", (Object)"sub", (Object)"super", (Object)"text-bottom", (Object)"text-top", (Object[])new String[0]);
        ImmutableSet visibilityLiterals0 = ImmutableSet.of((Object)"collapse", (Object)"hidden", (Object)"inherit", (Object)"visible");
        ImmutableSet voiceFamilyLiterals0 = ImmutableSet.of((Object)"child", (Object)"female", (Object)"male");
        ImmutableSet volumeLiterals0 = ImmutableSet.of((Object)"loud", (Object)"silent", (Object)"soft", (Object)"x-loud", (Object)"x-soft");
        ImmutableSet whiteSpaceLiterals0 = ImmutableSet.of((Object)"-moz-pre-wrap", (Object)"-o-pre-wrap", (Object)"-pre-wrap", (Object)"nowrap", (Object)"pre", (Object)"pre-line", (Object[])new String[]{"pre-wrap"});
        ImmutableSet wordWrapLiterals0 = ImmutableSet.of((Object)"break-word", (Object)"normal");
        ImmutableSet rgb$FunLiterals0 = ImmutableSet.of((Object)",");
        ImmutableSet linearGradient$FunLiterals0 = ImmutableSet.of((Object)",", (Object)"to");
        ImmutableSet radialGradient$FunLiterals0 = ImmutableSet.of((Object)"at", (Object)"closest-corner", (Object)"closest-side", (Object)"ellipse", (Object)"farthest-corner", (Object)"farthest-side", (Object[])new String[0]);
        ImmutableSet radialGradient$FunLiterals1 = ImmutableSet.of((Object)",", (Object)"center", (Object)"circle");
        ImmutableSet rect$FunLiterals0 = ImmutableSet.of((Object)",", (Object)"auto");
        Property mozBorderRadius = new Property(5, (ImmutableSet<String>)mozBorderRadiusLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"-moz-border-radius", (Object)mozBorderRadius);
        Property mozBorderRadiusBottomleft = new Property(5, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"-moz-border-radius-bottomleft", (Object)mozBorderRadiusBottomleft);
        Property mozOpacity = new Property(1, (ImmutableSet<String>)mozOpacityLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"-moz-opacity", (Object)mozOpacity);
        Property mozOutline = new Property(7, CssSchema.union(mozOutlineLiterals0, mozOutlineLiterals1, mozOutlineLiterals2, mozOutlineLiterals3), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"-moz-outline", (Object)mozOutline);
        Property mozOutlineColor = new Property(2, CssSchema.union(mozOutlineColorLiterals0, mozOutlineLiterals0), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"-moz-outline-color", (Object)mozOutlineColor);
        Property mozOutlineStyle = new Property(0, CssSchema.union(mozOutlineLiterals1, mozOutlineStyleLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"-moz-outline-style", (Object)mozOutlineStyle);
        Property mozOutlineWidth = new Property(5, CssSchema.union(mozOutlineLiterals2, mozOutlineWidthLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"-moz-outline-width", (Object)mozOutlineWidth);
        Property oTextOverflow = new Property(0, (ImmutableSet<String>)oTextOverflowLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"-o-text-overflow", (Object)oTextOverflow);
        Property azimuth = new Property(5, CssSchema.union(azimuthLiterals0, azimuthLiterals1, azimuthLiterals2), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"azimuth", (Object)azimuth);
        Property background = new Property(23, CssSchema.union(azimuthLiterals1, backgroundLiterals0, backgroundLiterals1, backgroundLiterals2, backgroundLiterals3, mozOutlineLiterals0), (ImmutableMap<String, String>)backgroundFunctions);
        builder.put((Object)"background", (Object)background);
        builder.put((Object)"background-attachment", (Object)new Property(0, (ImmutableSet<String>)backgroundAttachmentLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property backgroundColor = new Property(258, CssSchema.union(backgroundColorLiterals0, mozOutlineLiterals0), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"background-color", (Object)backgroundColor);
        builder.put((Object)"background-image", (Object)new Property(16, (ImmutableSet<String>)backgroundImageLiterals0, (ImmutableMap<String, String>)backgroundImageFunctions));
        Property backgroundPosition = new Property(5, CssSchema.union(azimuthLiterals1, backgroundLiterals2, backgroundPositionLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"background-position", (Object)backgroundPosition);
        Property backgroundRepeat = new Property(0, CssSchema.union(backgroundLiterals1, backgroundRepeatLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"background-repeat", (Object)backgroundRepeat);
        Property border = new Property(7, CssSchema.union(borderLiterals0, mozOutlineLiterals0, mozOutlineLiterals1, mozOutlineLiterals2), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"border", (Object)border);
        Property borderBottomColor = new Property(2, CssSchema.union(backgroundColorLiterals0, mozOutlineLiterals0), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"border-bottom-color", (Object)borderBottomColor);
        builder.put((Object)"border-collapse", (Object)new Property(0, (ImmutableSet<String>)borderCollapseLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property borderSpacing = new Property(5, (ImmutableSet<String>)mozOpacityLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"border-spacing", (Object)borderSpacing);
        Property bottom = new Property(5, (ImmutableSet<String>)bottomLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"bottom", (Object)bottom);
        Property boxShadow = new Property(7, CssSchema.union(boxShadowLiterals0, mozOutlineLiterals0), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"box-shadow", (Object)boxShadow);
        Property captionSide = new Property(0, CssSchema.union(backgroundLiterals2, mozOpacityLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"caption-side", (Object)captionSide);
        Property clear = new Property(0, CssSchema.union(azimuthLiterals1, clearLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"clear", (Object)clear);
        builder.put((Object)"clip", (Object)new Property(0, (ImmutableSet<String>)bottomLiterals0, (ImmutableMap<String, String>)clipFunctions));
        Property color = new Property(258, CssSchema.union(mozOpacityLiterals0, mozOutlineLiterals0), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"color", (Object)color);
        builder.put((Object)"content", (Object)new Property(8, (ImmutableSet<String>)contentLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property cue = new Property(16, (ImmutableSet<String>)cueLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"cue", (Object)cue);
        Property cursor = new Property(272, CssSchema.union(cursorLiterals0, cursorLiterals1), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"cursor", (Object)cursor);
        Property direction = new Property(0, CssSchema.union(directionLiterals0, mozOpacityLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"direction", (Object)direction);
        Property display = new Property(0, CssSchema.union(cueLiterals0, displayLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"display", (Object)display);
        Property elevation = new Property(5, CssSchema.union(elevationLiterals0, mozOpacityLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"elevation", (Object)elevation);
        Property emptyCells = new Property(0, CssSchema.union(emptyCellsLiterals0, mozOpacityLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"empty-cells", (Object)emptyCells);
        Property cssFloat = new Property(0, CssSchema.union(azimuthLiterals1, cueLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"float", (Object)cssFloat);
        Property font = new Property(73, CssSchema.union(fontLiterals0, fontLiterals1, fontLiterals2, fontLiterals3, fontLiterals4, fontLiterals5), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"font", (Object)font);
        Property fontFamily = new Property(72, CssSchema.union(fontFamilyLiterals0, fontLiterals3), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"font-family", (Object)fontFamily);
        Property fontSize = new Property(1, CssSchema.union(fontLiterals1, mozOutlineWidthLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"font-size", (Object)fontSize);
        Property fontStretch = new Property(0, CssSchema.union(fontStretchLiterals0, fontStretchLiterals1), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"font-stretch", (Object)fontStretch);
        Property fontStyle = new Property(0, CssSchema.union(fontLiterals4, fontStyleLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"font-style", (Object)fontStyle);
        builder.put((Object)"font-variant", (Object)new Property(0, (ImmutableSet<String>)fontVariantLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property fontWeight = new Property(0, CssSchema.union(fontLiterals0, fontStyleLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"font-weight", (Object)fontWeight);
        Property height = new Property(5, (ImmutableSet<String>)bottomLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"height", (Object)height);
        Property letterSpacing = new Property(5, (ImmutableSet<String>)fontStyleLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"letter-spacing", (Object)letterSpacing);
        builder.put((Object)"line-height", (Object)new Property(1, (ImmutableSet<String>)fontStyleLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property listStyle = new Property(16, CssSchema.union(listStyleLiterals0, listStyleLiterals1, listStyleLiterals2), (ImmutableMap<String, String>)backgroundImageFunctions);
        builder.put((Object)"list-style", (Object)listStyle);
        builder.put((Object)"list-style-image", (Object)new Property(16, (ImmutableSet<String>)cueLiterals0, (ImmutableMap<String, String>)backgroundImageFunctions));
        Property listStylePosition = new Property(0, CssSchema.union(listStyleLiterals1, mozOpacityLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"list-style-position", (Object)listStylePosition);
        Property listStyleType = new Property(0, CssSchema.union(listStyleLiterals0, listStyleLiterals2), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"list-style-type", (Object)listStyleType);
        Property margin = new Property(1, (ImmutableSet<String>)bottomLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"margin", (Object)margin);
        Property maxHeight = new Property(1, (ImmutableSet<String>)maxHeightLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"max-height", (Object)maxHeight);
        Property opacity = new Property(1, (ImmutableSet<String>)mozOpacityLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"opacity", (Object)opacity);
        builder.put((Object)"overflow", (Object)new Property(0, (ImmutableSet<String>)overflowLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property overflowX = new Property(0, CssSchema.union(overflowXLiterals0, overflowXLiterals1), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"overflow-x", (Object)overflowX);
        Property padding = new Property(1, (ImmutableSet<String>)mozOpacityLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"padding", (Object)padding);
        Property pageBreakAfter = new Property(0, CssSchema.union(azimuthLiterals1, pageBreakAfterLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"page-break-after", (Object)pageBreakAfter);
        builder.put((Object)"page-break-inside", (Object)new Property(0, (ImmutableSet<String>)pageBreakInsideLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property pitch = new Property(5, CssSchema.union(mozOutlineWidthLiterals0, pitchLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"pitch", (Object)pitch);
        builder.put((Object)"play-during", (Object)new Property(16, (ImmutableSet<String>)playDuringLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property position = new Property(0, CssSchema.union(mozOpacityLiterals0, positionLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"position", (Object)position);
        builder.put((Object)"quotes", (Object)new Property(8, (ImmutableSet<String>)cueLiterals0, (ImmutableMap<String, String>)zeroFns));
        builder.put((Object)"speak", (Object)new Property(0, (ImmutableSet<String>)speakLiterals0, (ImmutableMap<String, String>)zeroFns));
        builder.put((Object)"speak-header", (Object)new Property(0, (ImmutableSet<String>)speakHeaderLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property speakNumeral = new Property(0, CssSchema.union(mozOpacityLiterals0, speakNumeralLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"speak-numeral", (Object)speakNumeral);
        builder.put((Object)"speak-punctuation", (Object)new Property(0, (ImmutableSet<String>)speakPunctuationLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property speechRate = new Property(5, CssSchema.union(mozOutlineWidthLiterals0, speechRateLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"speech-rate", (Object)speechRate);
        builder.put((Object)"table-layout", (Object)new Property(0, (ImmutableSet<String>)tableLayoutLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property textAlign = new Property(0, CssSchema.union(azimuthLiterals1, textAlignLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"text-align", (Object)textAlign);
        Property textDecoration = new Property(0, CssSchema.union(cueLiterals0, textDecorationLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"text-decoration", (Object)textDecoration);
        Property textTransform = new Property(0, CssSchema.union(cueLiterals0, textTransformLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"text-transform", (Object)textTransform);
        Property textWrap = new Property(0, CssSchema.union(contentLiterals0, textWrapLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"text-wrap", (Object)textWrap);
        Property unicodeBidi = new Property(0, CssSchema.union(fontStyleLiterals0, unicodeBidiLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"unicode-bidi", (Object)unicodeBidi);
        Property verticalAlign = new Property(5, CssSchema.union(backgroundLiterals2, mozOpacityLiterals0, verticalAlignLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"vertical-align", (Object)verticalAlign);
        builder.put((Object)"visibility", (Object)new Property(0, (ImmutableSet<String>)visibilityLiterals0, (ImmutableMap<String, String>)zeroFns));
        Property voiceFamily = new Property(8, CssSchema.union(fontFamilyLiterals0, voiceFamilyLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"voice-family", (Object)voiceFamily);
        Property volume = new Property(1, CssSchema.union(mozOutlineWidthLiterals0, volumeLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"volume", (Object)volume);
        Property whiteSpace = new Property(0, CssSchema.union(fontStyleLiterals0, whiteSpaceLiterals0), (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"white-space", (Object)whiteSpace);
        builder.put((Object)"word-wrap", (Object)new Property(0, (ImmutableSet<String>)wordWrapLiterals0, (ImmutableMap<String, String>)zeroFns));
        builder.put((Object)"zoom", (Object)new Property(1, (ImmutableSet<String>)fontStretchLiterals1, (ImmutableMap<String, String>)zeroFns));
        Property rgb$Fun = new Property(1, (ImmutableSet<String>)rgb$FunLiterals0, (ImmutableMap<String, String>)zeroFns);
        builder.put((Object)"rgb()", (Object)rgb$Fun);
        builder.put((Object)"rgba()", (Object)rgb$Fun);
        builder.put((Object)"hsl()", (Object)rgb$Fun);
        builder.put((Object)"hsla()", (Object)rgb$Fun);
        Property image$Fun = new Property(18, CssSchema.union(mozOutlineLiterals0, rgb$FunLiterals0), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"image()", (Object)image$Fun);
        Property linearGradient$Fun = new Property(7, CssSchema.union(azimuthLiterals1, backgroundLiterals2, linearGradient$FunLiterals0, mozOutlineLiterals0), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"linear-gradient()", (Object)linearGradient$Fun);
        Property radialGradient$Fun = new Property(7, CssSchema.union(azimuthLiterals1, backgroundLiterals2, mozOutlineLiterals0, radialGradient$FunLiterals0, radialGradient$FunLiterals1), (ImmutableMap<String, String>)mozOutlineFunctions);
        builder.put((Object)"radial-gradient()", (Object)radialGradient$Fun);
        builder.put((Object)"rect()", (Object)new Property(5, (ImmutableSet<String>)rect$FunLiterals0, (ImmutableMap<String, String>)zeroFns));
        builder.put((Object)"-moz-border-radius-bottomright", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-moz-border-radius-topleft", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-moz-border-radius-topright", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-moz-box-shadow", (Object)boxShadow);
        builder.put((Object)"-webkit-border-bottom-left-radius", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-webkit-border-bottom-right-radius", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-webkit-border-radius", (Object)mozBorderRadius);
        builder.put((Object)"-webkit-border-radius-bottom-left", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-webkit-border-radius-bottom-right", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-webkit-border-radius-top-left", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-webkit-border-radius-top-right", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-webkit-border-top-left-radius", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-webkit-border-top-right-radius", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"-webkit-box-shadow", (Object)boxShadow);
        builder.put((Object)"border-bottom", (Object)border);
        builder.put((Object)"border-bottom-left-radius", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"border-bottom-right-radius", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"border-bottom-style", (Object)mozOutlineStyle);
        builder.put((Object)"border-bottom-width", (Object)mozOutlineWidth);
        builder.put((Object)"border-color", (Object)borderBottomColor);
        builder.put((Object)"border-left", (Object)border);
        builder.put((Object)"border-left-color", (Object)borderBottomColor);
        builder.put((Object)"border-left-style", (Object)mozOutlineStyle);
        builder.put((Object)"border-left-width", (Object)mozOutlineWidth);
        builder.put((Object)"border-radius", (Object)mozBorderRadius);
        builder.put((Object)"border-right", (Object)border);
        builder.put((Object)"border-right-color", (Object)borderBottomColor);
        builder.put((Object)"border-right-style", (Object)mozOutlineStyle);
        builder.put((Object)"border-right-width", (Object)mozOutlineWidth);
        builder.put((Object)"border-style", (Object)mozOutlineStyle);
        builder.put((Object)"border-top", (Object)border);
        builder.put((Object)"border-top-color", (Object)borderBottomColor);
        builder.put((Object)"border-top-left-radius", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"border-top-right-radius", (Object)mozBorderRadiusBottomleft);
        builder.put((Object)"border-top-style", (Object)mozOutlineStyle);
        builder.put((Object)"border-top-width", (Object)mozOutlineWidth);
        builder.put((Object)"border-width", (Object)mozOutlineWidth);
        builder.put((Object)"cue-after", (Object)cue);
        builder.put((Object)"cue-before", (Object)cue);
        builder.put((Object)"left", (Object)height);
        builder.put((Object)"margin-bottom", (Object)margin);
        builder.put((Object)"margin-left", (Object)margin);
        builder.put((Object)"margin-right", (Object)margin);
        builder.put((Object)"margin-top", (Object)margin);
        builder.put((Object)"max-width", (Object)maxHeight);
        builder.put((Object)"min-height", (Object)margin);
        builder.put((Object)"min-width", (Object)margin);
        builder.put((Object)"outline", (Object)mozOutline);
        builder.put((Object)"outline-color", (Object)mozOutlineColor);
        builder.put((Object)"outline-style", (Object)mozOutlineStyle);
        builder.put((Object)"outline-width", (Object)mozOutlineWidth);
        builder.put((Object)"overflow-y", (Object)overflowX);
        builder.put((Object)"padding-bottom", (Object)padding);
        builder.put((Object)"padding-left", (Object)padding);
        builder.put((Object)"padding-right", (Object)padding);
        builder.put((Object)"padding-top", (Object)padding);
        builder.put((Object)"page-break-before", (Object)pageBreakAfter);
        builder.put((Object)"pause", (Object)borderSpacing);
        builder.put((Object)"pause-after", (Object)borderSpacing);
        builder.put((Object)"pause-before", (Object)borderSpacing);
        builder.put((Object)"pitch-range", (Object)borderSpacing);
        builder.put((Object)"richness", (Object)borderSpacing);
        builder.put((Object)"right", (Object)height);
        builder.put((Object)"stress", (Object)borderSpacing);
        builder.put((Object)"text-indent", (Object)borderSpacing);
        builder.put((Object)"text-overflow", (Object)oTextOverflow);
        builder.put((Object)"text-shadow", (Object)boxShadow);
        builder.put((Object)"top", (Object)height);
        builder.put((Object)"width", (Object)margin);
        builder.put((Object)"word-spacing", (Object)letterSpacing);
        builder.put((Object)"z-index", (Object)bottom);
        builder.put((Object)"repeating-linear-gradient()", (Object)linearGradient$Fun);
        builder.put((Object)"repeating-radial-gradient()", (Object)radialGradient$Fun);
        DEFINITIONS = builder.build();
        DEFAULT_WHITELIST = ImmutableSet.of((Object)"-moz-border-radius", (Object)"-moz-border-radius-bottomleft", (Object)"-moz-border-radius-bottomright", (Object)"-moz-border-radius-topleft", (Object)"-moz-border-radius-topright", (Object)"-moz-box-shadow", (Object[])new String[]{"-moz-outline", "-moz-outline-color", "-moz-outline-style", "-moz-outline-width", "-o-text-overflow", "-webkit-border-bottom-left-radius", "-webkit-border-bottom-right-radius", "-webkit-border-radius", "-webkit-border-radius-bottom-left", "-webkit-border-radius-bottom-right", "-webkit-border-radius-top-left", "-webkit-border-radius-top-right", "-webkit-border-top-left-radius", "-webkit-border-top-right-radius", "-webkit-box-shadow", "azimuth", "background", "background-attachment", "background-color", "background-image", "background-position", "background-repeat", "border", "border-bottom", "border-bottom-color", "border-bottom-left-radius", "border-bottom-right-radius", "border-bottom-style", "border-bottom-width", "border-collapse", "border-color", "border-left", "border-left-color", "border-left-style", "border-left-width", "border-radius", "border-right", "border-right-color", "border-right-style", "border-right-width", "border-spacing", "border-style", "border-top", "border-top-color", "border-top-left-radius", "border-top-right-radius", "border-top-style", "border-top-width", "border-width", "box-shadow", "caption-side", "color", "cue", "cue-after", "cue-before", "direction", "elevation", "empty-cells", "font", "font-family", "font-size", "font-stretch", "font-style", "font-variant", "font-weight", "height", "image()", "letter-spacing", "line-height", "linear-gradient()", "list-style", "list-style-image", "list-style-position", "list-style-type", "margin", "margin-bottom", "margin-left", "margin-right", "margin-top", "max-height", "max-width", "min-height", "min-width", "outline", "outline-color", "outline-style", "outline-width", "padding", "padding-bottom", "padding-left", "padding-right", "padding-top", "pause", "pause-after", "pause-before", "pitch", "pitch-range", "quotes", "radial-gradient()", "rect()", "repeating-linear-gradient()", "repeating-radial-gradient()", "rgb()", "rgba()", "hsl()", "hsla()", "richness", "speak", "speak-header", "speak-numeral", "speak-punctuation", "speech-rate", "stress", "table-layout", "text-align", "text-decoration", "text-indent", "text-overflow", "text-shadow", "text-transform", "text-wrap", "unicode-bidi", "vertical-align", "voice-family", "volume", "white-space", "width", "word-spacing", "word-wrap"});
        DEFAULT = CssSchema.withProperties(DEFAULT_WHITELIST);
    }

    public static final class Property {
        final int bits;
        final ImmutableSet<String> literals;
        final ImmutableMap<String, String> fnKeys;

        public Property(int bits, ImmutableSet<String> literals, ImmutableMap<String, String> fnKeys) {
            this.bits = bits;
            this.literals = literals;
            this.fnKeys = fnKeys;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bits;
            result = 31 * result + (this.fnKeys == null ? 0 : this.fnKeys.hashCode());
            result = 31 * result + (this.literals == null ? 0 : this.literals.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            if (this.bits != other.bits) {
                return false;
            }
            if (this.fnKeys == null ? other.fnKeys != null : !this.fnKeys.equals(other.fnKeys)) {
                return false;
            }
            return !(this.literals == null ? other.literals != null : !this.literals.equals(other.literals));
        }
    }
}

