/*
 * Decompiled with CFR 0.152.
 */
package com.common.htmlsanitizer;

import com.common.htmlsanitizer.HtmlElementTablesCanned;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class HtmlElementTables {
    public static final int TEXT_NODE = -1;
    private final HtmlElementNames elementNames;
    private final DenseElementBinaryMatrix canContain;
    private final DenseElementBinaryMatrix closedOnClose;
    private final DenseElementBinaryMatrix closedOnOpen;
    private final SparseElementToElements explicitClosers;
    private final SparseElementMultitable impliedElements;
    private final TextContentModel textContentModel;
    private final DenseElementSet resumable;
    private final int DIR_TAG;
    private final int OL_TAG;
    private final int UL_TAG;
    private final int LI_TAG;
    private final int SELECT_TAG;
    private final int OPTION_TAG;
    private final int OPTGROUP_TAG;
    private final int SCRIPT_TAG;
    private final int STYLE_TAG;
    private final int TABLE_TAG;
    private final int TBODY_TAG;
    private final int TFOOT_TAG;
    private final int THEAD_TAG;
    private final int TR_TAG;
    private final int TD_TAG;
    private final int TH_TAG;
    private final int CAPTION_TAG;
    private final int COL_TAG;
    private final int COLGROUP_TAG;
    private final int IFRAME_TAG;
    private final FreeWrapper[] FREE_WRAPPERS;
    private final int[] LI_TAG_ARR;
    private final int[] OPTION_TAG_ARR;
    private final DenseElementSet nofeatureElements;
    static final int[] ZERO_INTS = new int[0];
    static final Comparator<int[]> COMPARE_BY_ZEROTH = new Comparator<int[]>(){

        @Override
        public int compare(int[] a, int[] b) {
            return a[0] - b[0];
        }
    };

    public HtmlElementTables(HtmlElementNames elementNames, DenseElementBinaryMatrix canContain, DenseElementBinaryMatrix closedOnClose, DenseElementBinaryMatrix closedOnOpen, SparseElementToElements explicitClosers, SparseElementMultitable impliedElements, TextContentModel textContentModel, DenseElementSet resumable) {
        FreeWrapper freeWrapper2;
        this.elementNames = elementNames;
        this.canContain = canContain;
        this.closedOnClose = closedOnClose;
        this.closedOnOpen = closedOnOpen;
        this.explicitClosers = explicitClosers;
        this.impliedElements = impliedElements;
        this.textContentModel = textContentModel;
        this.resumable = resumable;
        this.DIR_TAG = this.indexForName("dir");
        this.OL_TAG = this.indexForName("ol");
        this.UL_TAG = this.indexForName("ul");
        this.LI_TAG = this.indexForName("li");
        this.SELECT_TAG = this.indexForName("select");
        this.OPTION_TAG = this.indexForName("option");
        this.OPTGROUP_TAG = this.indexForName("opgroup");
        this.SCRIPT_TAG = this.indexForName("script");
        this.STYLE_TAG = this.indexForName("style");
        this.TABLE_TAG = this.indexForName("table");
        this.TBODY_TAG = this.indexForName("tbody");
        this.TFOOT_TAG = this.indexForName("tfoot");
        this.THEAD_TAG = this.indexForName("thead");
        this.TR_TAG = this.indexForName("tr");
        this.TD_TAG = this.indexForName("td");
        this.TH_TAG = this.indexForName("th");
        this.CAPTION_TAG = this.indexForName("caption");
        this.COL_TAG = this.indexForName("col");
        this.COLGROUP_TAG = this.indexForName("colgroup");
        this.IFRAME_TAG = this.indexForName("iframe");
        ImmutableList freeWrappers = ImmutableList.of((Object)new FreeWrapper(this.LI_TAG, new int[]{this.DIR_TAG, this.OL_TAG, this.UL_TAG, this.LI_TAG}, new int[]{this.UL_TAG}), (Object)new FreeWrapper(this.OPTION_TAG, new int[]{this.SELECT_TAG, this.OPTGROUP_TAG, this.OPTION_TAG}, new int[]{this.SELECT_TAG}), (Object)new FreeWrapper(this.OPTGROUP_TAG, new int[]{this.SELECT_TAG, this.OPTGROUP_TAG}, new int[]{this.SELECT_TAG}), (Object)new FreeWrapper(this.TD_TAG, new int[]{this.TR_TAG, this.TD_TAG, this.TH_TAG}, new int[]{this.TABLE_TAG, this.TBODY_TAG, this.TR_TAG}), (Object)new FreeWrapper(this.TH_TAG, new int[]{this.TR_TAG, this.TD_TAG, this.TH_TAG}, new int[]{this.TABLE_TAG, this.TBODY_TAG, this.TR_TAG}), (Object)new FreeWrapper(this.TR_TAG, new int[]{this.TBODY_TAG, this.THEAD_TAG, this.TFOOT_TAG, this.TR_TAG, this.TD_TAG, this.TH_TAG}, new int[]{this.TABLE_TAG, this.TBODY_TAG}), (Object)new FreeWrapper(this.TBODY_TAG, new int[]{this.TABLE_TAG, this.THEAD_TAG, this.TBODY_TAG, this.TFOOT_TAG}, new int[]{this.TABLE_TAG}), (Object)new FreeWrapper(this.THEAD_TAG, new int[]{this.TABLE_TAG, this.THEAD_TAG, this.TBODY_TAG, this.TFOOT_TAG}, new int[]{this.TABLE_TAG}), (Object)new FreeWrapper(this.TFOOT_TAG, new int[]{this.TABLE_TAG, this.THEAD_TAG, this.TBODY_TAG, this.TFOOT_TAG}, new int[]{this.TABLE_TAG}), (Object)new FreeWrapper(this.CAPTION_TAG, new int[]{this.TABLE_TAG}, new int[]{this.TABLE_TAG}), (Object)new FreeWrapper(this.COL_TAG, new int[]{this.COLGROUP_TAG}, new int[]{this.TABLE_TAG, this.COLGROUP_TAG}), (Object)new FreeWrapper(this.COLGROUP_TAG, new int[]{this.TABLE_TAG}, new int[]{this.TABLE_TAG}), (Object[])new FreeWrapper[0]);
        int maxDescIdx = -1;
        for (FreeWrapper freeWrapper2 : freeWrappers) {
            maxDescIdx = Math.max(freeWrapper2.desc, maxDescIdx);
        }
        FreeWrapper[] freeWrapperArr = new FreeWrapper[maxDescIdx + 1];
        freeWrapper2 = freeWrappers.iterator();
        while (freeWrapper2.hasNext()) {
            FreeWrapper freeWrapper3;
            freeWrapperArr[freeWrapper3.desc] = freeWrapper3 = (FreeWrapper)freeWrapper2.next();
        }
        this.FREE_WRAPPERS = freeWrapperArr;
        this.LI_TAG_ARR = new int[]{this.LI_TAG};
        this.OPTION_TAG_ARR = new int[]{this.OPTION_TAG};
        boolean[] nofeatureBits = new boolean[this.nElementTypes()];
        nofeatureBits[this.indexForName((String)"noembed")] = true;
        nofeatureBits[this.indexForName((String)"noframes")] = true;
        nofeatureBits[this.indexForName((String)"noscript")] = true;
        this.nofeatureElements = new DenseElementSet(nofeatureBits);
    }

    public boolean canContain(int parent, int child) {
        if (this.nofeatureElements.get(parent)) {
            return true;
        }
        return child == -1 ? this.canContainText(parent) : this.canContain.get(parent, child);
    }

    public int indexForName(String canonName) {
        return this.elementNames.getElementNameIndex(canonName);
    }

    public String canonNameForIndex(int index) {
        return (String)this.elementNames.canonNames.get(index);
    }

    public boolean resumable(int index) {
        return this.resumable.get(index);
    }

    public boolean canContainText(int index) {
        return this.textContentModel.canContainText(index);
    }

    public boolean canContainPlainText(int index) {
        return this.textContentModel.canContainPlainText(index) && index != this.IFRAME_TAG;
    }

    boolean canContainComment(int ix) {
        return this.textContentModel.canContainComment(ix);
    }

    boolean canContainCharacterReference(int ix) {
        return this.textContentModel.canContainEntities(ix);
    }

    boolean isTextContentRaw(int ix) {
        return this.textContentModel.isRaw(ix);
    }

    boolean isUnended(int ix) {
        return this.textContentModel.isUnended(ix);
    }

    boolean isAlternateCloserFor(int closeTag, int openElement) {
        return this.explicitClosers.get(openElement, closeTag);
    }

    boolean closedOnOpen(int alreadyOpenElement, int openTag) {
        return this.closedOnOpen.get(alreadyOpenElement, openTag);
    }

    boolean closedOnClose(int alreadyOpenElement, int closeTag) {
        return this.closedOnClose.get(alreadyOpenElement, closeTag);
    }

    public int nElementTypes() {
        return this.elementNames.canonNames.size();
    }

    int[] impliedElements(int anc, int desc) {
        int[] implied;
        FreeWrapper wrapper;
        if (desc == this.SCRIPT_TAG || desc == this.STYLE_TAG) {
            return ZERO_INTS;
        }
        FreeWrapper freeWrapper = wrapper = desc != -1 && desc < this.FREE_WRAPPERS.length ? this.FREE_WRAPPERS[desc] : null;
        if (wrapper != null && anc < wrapper.allowedContainers.length && !wrapper.allowedContainers[anc]) {
            return wrapper.implied;
        }
        if (desc != -1 && (implied = this.impliedElements.getElementIndexList(anc, desc)).length != 0) {
            return implied;
        }
        int[] oneImplied = null;
        if (anc == this.OL_TAG || anc == this.UL_TAG) {
            oneImplied = this.LI_TAG_ARR;
        } else if (anc == this.SELECT_TAG) {
            oneImplied = this.OPTION_TAG_ARR;
        }
        if (oneImplied != null && desc != oneImplied[0]) {
            return this.LI_TAG_ARR;
        }
        return ZERO_INTS;
    }

    static HtmlElementTables get() {
        return HtmlElementTablesCanned.TABLES;
    }

    static boolean binSearchRange(int[] arr, int leftIncl, int rightExcl, int value) {
        int lo = leftIncl;
        int hi = rightExcl;
        while (lo < hi) {
            int mid = lo + hi >>> 1;
            assert (mid >= lo);
            int el = arr[mid];
            int delta = value - el;
            if (delta == 0) {
                return true;
            }
            if (delta < 0) {
                hi = mid;
                continue;
            }
            lo = mid + 1;
        }
        return false;
    }

    public static boolean[] unpack(int[] packed, int length) {
        boolean[] bools = new boolean[length];
        for (int i = 0; i < length; ++i) {
            bools[i] = (packed[i >> 5] & 1 << (i & 0x1F)) != 0;
        }
        return bools;
    }

    public static enum TextContentModelBit {
        COMMENTS(1),
        ENTITIES(2),
        RAW(4),
        TEXT(8),
        UNENDED(16),
        PLAIN_TEXT(32);

        public final int bitMask;

        private TextContentModelBit(int bitMask) {
            this.bitMask = bitMask;
        }
    }

    public static final class TextContentModel {
        private final byte[] contentModelBitsPerElement;

        public TextContentModel(byte[] contentModelBitsPerElement) {
            this.contentModelBitsPerElement = (byte[])contentModelBitsPerElement.clone();
        }

        public boolean canContainComment(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.COMMENTS.bitMask);
        }

        public boolean canContainEntities(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.ENTITIES.bitMask);
        }

        public boolean canContainText(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.TEXT.bitMask);
        }

        public boolean canContainPlainText(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.PLAIN_TEXT.bitMask);
        }

        public boolean isRaw(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.RAW.bitMask);
        }

        public boolean isUnended(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.UNENDED.bitMask);
        }

        public boolean isAllowed(int elementIndex, TextContentModelBit modelBit) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & modelBit.bitMask);
        }
    }

    public static final class SparseElementMultitable {
        private final int[][][] arrs;
        private static final int[][] ZERO_INT_ARRS = new int[0][];

        public SparseElementMultitable(int[][][] arrs) {
            this.arrs = (int[][][])arrs.clone();
            int n = arrs.length;
            for (int j = 0; j < n; ++j) {
                if (this.arrs[j] == null) {
                    this.arrs[j] = ZERO_INT_ARRS;
                    continue;
                }
                this.arrs[j] = (int[][])this.arrs[j].clone();
                int[][] arrEl = this.arrs[j];
                int m = arrEl.length;
                for (int i = 0; i < m; ++i) {
                    arrEl[i] = (int[])arrEl[i].clone();
                    int[] row = arrEl[i];
                    Preconditions.checkState((i == 0 || row[0] > arrEl[i - 1][0] ? 1 : 0) != 0);
                }
            }
        }

        public int[] getElementIndexList(int aIndex, int bIndex) {
            if (aIndex < this.arrs.length) {
                int[][] aArrs = this.arrs[aIndex];
                int bi = Arrays.binarySearch(aArrs, new int[]{bIndex}, COMPARE_BY_ZEROTH);
                if (bi >= 0) {
                    int[] bIndexThenRow = aArrs[bi];
                    int[] row = new int[bIndexThenRow.length - 1];
                    System.arraycopy(bIndexThenRow, 1, row, 0, row.length);
                    return row;
                }
            }
            return ZERO_INTS;
        }
    }

    public static final class SparseElementToElements {
        private final int[][] arrs;

        public SparseElementToElements(int[][] arrs) {
            this.arrs = (int[][])arrs.clone();
            int last = -1;
            int n = this.arrs.length;
            for (int i = 0; i < n; ++i) {
                arrs[i] = (int[])arrs[i].clone();
                int[] arr = arrs[i];
                Preconditions.checkArgument((last < arr[0] ? 1 : 0) != 0);
                last = arr[0];
                int lastVal = -1;
                int m = arr.length;
                for (int j = 1; j < m; ++j) {
                    int val = arr[j];
                    Preconditions.checkArgument((val > lastVal ? 1 : 0) != 0, (Object)arr);
                    lastVal = val;
                }
            }
        }

        boolean get(int key, int value) {
            int row = Arrays.binarySearch(this.arrs, new int[]{key}, COMPARE_BY_ZEROTH);
            if (row < 0) {
                return false;
            }
            int[] arr = this.arrs[row];
            return HtmlElementTables.binSearchRange(arr, 1, arr.length, value);
        }
    }

    public static final class DenseElementSet {
        private final boolean[] bits;

        public DenseElementSet(boolean[] bits) {
            this.bits = (boolean[])bits.clone();
        }

        public boolean get(int i) {
            return this.bits[i];
        }
    }

    static final class DenseElementBinaryMatrix {
        private final int matrixLength;
        private final boolean[] bits;

        public DenseElementBinaryMatrix(boolean[] bits, int matrixLength) {
            Preconditions.checkArgument((bits.length == matrixLength * matrixLength ? 1 : 0) != 0);
            this.matrixLength = matrixLength;
            this.bits = (boolean[])bits.clone();
        }

        public boolean get(int a, int b) {
            Preconditions.checkElementIndex((int)a, (int)this.matrixLength);
            Preconditions.checkElementIndex((int)b, (int)this.matrixLength);
            return this.bits[a * this.matrixLength + b];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int k = 0;
            for (int j = 0; j < this.matrixLength; ++j) {
                if (j != 0) {
                    sb.append('\n');
                }
                int i = 0;
                while (i < this.matrixLength) {
                    sb.append(this.bits[k] ? (char)'1' : '.');
                    ++i;
                    ++k;
                }
            }
            return sb.toString();
        }
    }

    public static final class HtmlElementNames {
        static final String CUSTOM_ELEMENT_NAME = "xcustom";
        public final ImmutableList<String> canonNames;
        private transient ImmutableMap<String, Integer> canonNameToIndex;
        private transient int customElementIndex;

        public HtmlElementNames(List<String> canonNames) {
            this.canonNames = ImmutableList.copyOf(canonNames);
        }

        HtmlElementNames(String ... canonNames) {
            this.canonNames = ImmutableList.copyOf((Object[])canonNames);
        }

        public int getElementNameIndex(String canonName) {
            Integer index;
            if (this.canonNameToIndex == null) {
                ImmutableMap.Builder b = ImmutableMap.builder();
                int n = this.canonNames.size();
                for (int i = 0; i < n; ++i) {
                    b.put(this.canonNames.get(i), (Object)i);
                }
                this.canonNameToIndex = b.build();
                this.customElementIndex = this.canonNames.indexOf((Object)CUSTOM_ELEMENT_NAME);
                Preconditions.checkState((this.customElementIndex >= 0 ? 1 : 0) != 0);
            }
            return (index = (Integer)this.canonNameToIndex.get((Object)canonName)) != null ? index : this.customElementIndex;
        }
    }

    private static final class FreeWrapper {
        final int desc;
        final boolean[] allowedContainers;
        final int[] implied;

        FreeWrapper(int desc, int[] allowedContainers, int[] implied) {
            this.desc = desc;
            int maxAllowedContainer = -1;
            for (int allowedContainer : allowedContainers) {
                maxAllowedContainer = Math.max(maxAllowedContainer, allowedContainer);
            }
            this.allowedContainers = new boolean[maxAllowedContainer + 1];
            for (int allowedContainer : allowedContainers) {
                this.allowedContainers[allowedContainer] = true;
            }
            this.implied = implied;
        }
    }
}

