/*
 * Decompiled with CFR 0.152.
 */
package com.common.htmlsanitizer;

import com.common.htmlsanitizer.AbstractTokenStream;
import com.common.htmlsanitizer.HtmlInputSplitter;
import com.common.htmlsanitizer.HtmlToken;
import com.common.htmlsanitizer.HtmlTokenType;
import com.common.htmlsanitizer.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class HtmlLexer
extends AbstractTokenStream {
    private final String input;
    private final HtmlInputSplitter splitter;
    private State state = State.OUTSIDE_TAG;
    private final LinkedList<HtmlToken> lookahead = Lists.newLinkedList();
    private static final Set<String> VALUELESS_ATTRIB_NAMES = ImmutableSet.of((Object)"checked", (Object)"compact", (Object)"declare", (Object)"defer", (Object)"disabled", (Object)"ismap", (Object[])new String[]{"multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"});
    private static final ImmutableSet<String> mixedCaseForeignAttributeNames = ImmutableSet.of((Object)"attributeName", (Object)"attributeType", (Object)"baseFrequency", (Object)"baseProfile", (Object)"calcMode", (Object)"clipPathUnits", (Object[])new String[]{"contentScriptType", "defaultAction", "definitionURL", "diffuseConstant", "edgeMode", "externalResourcesRequired", "filterUnits", "focusHighlight", "gradientTransform", "gradientUnits", "initialVisibility", "kernelMatrix", "kernelUnitLength", "keyPoints", "keySplines", "keyTimes", "lengthAdjust", "limitingConeAngle", "markerHeight", "markerUnits", "markerWidth", "maskContentUnits", "maskUnits", "mediaCharacterEncoding", "mediaContentEncodings", "mediaSize", "mediaTime", "numOctaves", "pathLength", "patternContentUnits", "patternTransform", "patternUnits", "playbackOrder", "pointsAtX", "pointsAtY", "pointsAtZ", "preserveAlpha", "preserveAspectRatio", "primitiveUnits", "refX", "refY", "repeatCount", "repeatDur", "requiredExtensions", "requiredFeatures", "requiredFonts", "requiredFormats", "schemaLocation", "snapshotTime", "specularConstant", "specularExponent", "spreadMethod", "startOffset", "stdDeviation", "stitchTiles", "surfaceScale", "syncBehavior", "syncBehaviorDefault", "syncMaster", "syncTolerance", "syncToleranceDefault", "systemLanguage", "tableValues", "targetX", "targetY", "textLength", "timelineBegin", "transformBehavior", "viewBox", "xChannelSelector", "yChannelSelector", "zoomAndPan"});
    private static final ImmutableSet<String> mixedCaseForeignElementNames = ImmutableSet.of((Object)"animateColor", (Object)"animateMotion", (Object)"animateTransform", (Object)"clipPath", (Object)"feBlend", (Object)"feColorMatrix", (Object[])new String[]{"feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence", "foreignObject", "linearGradient", "radialGradient", "solidColor", "textArea", "textPath"});

    public HtmlLexer(String input) {
        this.input = input;
        this.splitter = new HtmlInputSplitter(input);
    }

    static String canonicalElementName(String elementName) {
        return elementName.indexOf(58) >= 0 || mixedCaseForeignElementNames.contains((Object)elementName) ? elementName : Strings.toLowerCase(elementName);
    }

    static String canonicalAttributeName(String attribName) {
        return attribName.indexOf(58) >= 0 || mixedCaseForeignAttributeNames.contains((Object)attribName) ? attribName : Strings.toLowerCase(attribName);
    }

    public static String canonicalKeywordAttributeValue(String keywordValue) {
        return Strings.toLowerCase(keywordValue);
    }

    @Override
    protected HtmlToken produce() {
        HtmlToken token = this.readToken();
        if (token == null) {
            return null;
        }
        block0 : switch (token.type) {
            case TAGBEGIN: {
                this.state = State.IN_TAG;
                break;
            }
            case TAGEND: {
                if (this.state == State.SAW_EQ && HtmlTokenType.TAGEND == token.type) {
                    this.pushbackToken(token);
                    this.state = State.IN_TAG;
                    return HtmlToken.instance(token.start, token.start, HtmlTokenType.ATTRVALUE);
                }
                this.state = State.OUTSIDE_TAG;
                break;
            }
            case IGNORABLE: {
                return this.produce();
            }
            default: {
                switch (this.state) {
                    case OUTSIDE_TAG: {
                        if (HtmlTokenType.TEXT != token.type && HtmlTokenType.UNESCAPED != token.type) break block0;
                        token = this.collapseSubsequent(token);
                        break block0;
                    }
                    case IN_TAG: {
                        if (HtmlTokenType.TEXT != token.type || token.tokenInContextMatches(this.input, "=")) break block0;
                        token = HtmlInputSplitter.reclassify(token, HtmlTokenType.ATTRNAME);
                        this.state = State.SAW_NAME;
                        break block0;
                    }
                    case SAW_NAME: {
                        if (HtmlTokenType.TEXT == token.type) {
                            if (token.tokenInContextMatches(this.input, "=")) {
                                this.state = State.SAW_EQ;
                                return this.produce();
                            }
                            token = HtmlInputSplitter.reclassify(token, HtmlTokenType.ATTRNAME);
                            break block0;
                        }
                        this.state = State.IN_TAG;
                        break block0;
                    }
                    case SAW_EQ: {
                        if (HtmlTokenType.TEXT != token.type && HtmlTokenType.QSTRING != token.type) break block0;
                        if (HtmlTokenType.TEXT == token.type) {
                            token = this.collapseAttributeName(token);
                        }
                        token = HtmlInputSplitter.reclassify(token, HtmlTokenType.ATTRVALUE);
                        this.state = State.IN_TAG;
                    }
                }
            }
        }
        return token;
    }

    private HtmlToken collapseSubsequent(HtmlToken token) {
        HtmlToken next;
        HtmlToken collapsed = token;
        while ((next = this.peekToken(0)) != null && next.type == token.type) {
            collapsed = HtmlLexer.join(collapsed, next);
            this.readToken();
        }
        return collapsed;
    }

    private HtmlToken collapseAttributeName(HtmlToken token) {
        HtmlToken t;
        int nToMerge = 0;
        while ((t = this.peekToken(nToMerge)) != null) {
            if (t.type == HtmlTokenType.IGNORABLE) {
                HtmlToken tok = this.peekToken(nToMerge + 1);
                if (tok == null || tok.type != HtmlTokenType.TEXT || HtmlLexer.isValuelessAttribute(this.input.substring(tok.start, tok.end))) break;
                HtmlToken eq = this.peekToken(nToMerge + 2);
                if (eq != null && eq.type == HtmlTokenType.IGNORABLE) {
                    eq = this.peekToken(nToMerge + 3);
                }
                if (eq == null || eq.tokenInContextMatches(this.input, "=")) {
                    break;
                }
            } else if (t.type != HtmlTokenType.TEXT) break;
            ++nToMerge;
        }
        if (nToMerge == 0) {
            return token;
        }
        int end = token.end;
        do {
            end = this.readToken().end;
        } while (--nToMerge > 0);
        return HtmlToken.instance(token.start, end, HtmlTokenType.TEXT);
    }

    private static HtmlToken join(HtmlToken a, HtmlToken b) {
        return HtmlToken.instance(a.start, b.end, a.type);
    }

    private HtmlToken readToken() {
        if (!this.lookahead.isEmpty()) {
            return this.lookahead.remove();
        }
        if (this.splitter.hasNext()) {
            return this.splitter.next();
        }
        return null;
    }

    private HtmlToken peekToken(int i) {
        while (this.lookahead.size() <= i && this.splitter.hasNext()) {
            this.lookahead.add(this.splitter.next());
        }
        return this.lookahead.size() > i ? this.lookahead.get(i) : null;
    }

    private void pushbackToken(HtmlToken token) {
        this.lookahead.addFirst(token);
    }

    private static boolean isValuelessAttribute(String attribName) {
        return VALUELESS_ATTRIB_NAMES.contains(HtmlLexer.canonicalAttributeName(attribName));
    }

    private static enum State {
        OUTSIDE_TAG,
        IN_TAG,
        SAW_NAME,
        SAW_EQ;

    }
}

