/*
 * Decompiled with CFR 0.152.
 */
package com.common.htmlsanitizer;

import com.common.htmlsanitizer.AttributePolicy;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class JoinedAttributePolicy
implements AttributePolicy {
    final ImmutableList<AttributePolicy> policies;

    JoinedAttributePolicy(Collection<? extends AttributePolicy> policies) {
        this.policies = ImmutableList.copyOf(policies);
    }

    @Override
    @Nullable
    public String apply(String elementName, String attributeName, @Nullable String rawValue) {
        String value = rawValue;
        for (AttributePolicy p : this.policies) {
            if (value == null) break;
            value = p.apply(elementName, attributeName, value);
        }
        return value;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.policies.equals(((JoinedAttributePolicy)o).policies);
    }

    public int hashCode() {
        return this.policies.hashCode();
    }
}

