/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.codecentric.boot.admin.server.web.client.LegacyEndpointConverter;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class LegacyEndpointConverters {
    private static final ParameterizedTypeReference<Map<String, Object>> RESPONSE_TYPE_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final ParameterizedTypeReference<List<Object>> RESPONSE_TYPE_LIST = new ParameterizedTypeReference<List<Object>>(){};
    private static final ParameterizedTypeReference<List<Map<String, Object>>> RESPONSE_TYPE_LIST_MAP = new ParameterizedTypeReference<List<Map<String, Object>>>(){};
    private static final Jackson2JsonDecoder DECODER;
    private static final Jackson2JsonEncoder ENCODER;
    private static final DateTimeFormatter TIMESTAMP_PATTERN;

    private LegacyEndpointConverters() {
    }

    public static LegacyEndpointConverter health() {
        return new LegacyEndpointConverter("health", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_MAP, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertHealth));
    }

    public static LegacyEndpointConverter env() {
        return new LegacyEndpointConverter("env", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_MAP, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertEnv));
    }

    public static LegacyEndpointConverter httptrace() {
        return new LegacyEndpointConverter("httptrace", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_LIST_MAP, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertHttptrace));
    }

    public static LegacyEndpointConverter threaddump() {
        return new LegacyEndpointConverter("threaddump", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_LIST, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertThreaddump));
    }

    public static LegacyEndpointConverter liquibase() {
        return new LegacyEndpointConverter("liquibase", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_LIST_MAP, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertLiquibase));
    }

    public static LegacyEndpointConverter flyway() {
        return new LegacyEndpointConverter("flyway", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_LIST_MAP, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertFlyway));
    }

    public static LegacyEndpointConverter info() {
        return new LegacyEndpointConverter("info", flux -> flux);
    }

    public static LegacyEndpointConverter beans() {
        return new LegacyEndpointConverter("beans", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_LIST_MAP, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertBeans));
    }

    public static LegacyEndpointConverter configprops() {
        return new LegacyEndpointConverter("configprops", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_MAP, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertConfigprops));
    }

    public static LegacyEndpointConverter mappings() {
        return new LegacyEndpointConverter("mappings", LegacyEndpointConverters.convertUsing(RESPONSE_TYPE_MAP, RESPONSE_TYPE_MAP, LegacyEndpointConverters::convertMappings));
    }

    private static <S, T> Function<Flux<DataBuffer>, Flux<DataBuffer>> convertUsing(ParameterizedTypeReference<S> sourceType, ParameterizedTypeReference<T> targetType, Function<S, T> converterFn) {
        return input -> DECODER.decodeToMono((Publisher)input, ResolvableType.forType((ParameterizedTypeReference)sourceType), null, null).map(body -> converterFn.apply(body)).flatMapMany(output -> ENCODER.encode((Publisher)Mono.just((Object)output), (DataBufferFactory)new DefaultDataBufferFactory(), ResolvableType.forType((ParameterizedTypeReference)targetType), null, null));
    }

    private static Map<String, Object> convertHealth(Map<String, Object> body) {
        LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>();
        LinkedHashMap details = new LinkedHashMap();
        body.forEach((key, value) -> {
            if ("status".equals(key)) {
                converted.put((String)key, value);
            } else if (value instanceof Map) {
                details.put(key, LegacyEndpointConverters.convertHealth((Map)value));
            } else {
                details.put(key, value);
            }
        });
        if (!details.isEmpty()) {
            converted.put("details", details);
        }
        return converted;
    }

    private static Map<String, Object> convertEnv(Map<String, Object> body) {
        LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>();
        ArrayList propertySources = new ArrayList(body.size());
        body.forEach((key, value) -> {
            if ("profiles".equals(key)) {
                converted.put("activeProfiles", value);
            } else if (value instanceof Map) {
                Map values = (Map)value;
                LinkedHashMap properties = new LinkedHashMap();
                values.forEach((propKey, propValue) -> properties.put(propKey, Collections.singletonMap("value", propValue)));
                LinkedHashMap<String, Object> propertySource = new LinkedHashMap<String, Object>();
                propertySource.put("name", key);
                propertySource.put("properties", properties);
                propertySources.add(propertySource);
            }
        });
        converted.put("propertySources", propertySources);
        return converted;
    }

    private static Map<String, Object> convertHttptrace(List<Map<String, Object>> traces) {
        return Collections.singletonMap("traces", ((Stream)traces.stream().sequential()).map(LegacyEndpointConverters::convertHttptrace).collect(Collectors.toList()));
    }

    private static Map<String, Object> convertHttptrace(Map<String, Object> in) {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        out.put("timestamp", LegacyEndpointConverters.getInstant(in.get("timestamp")));
        Map in_info = (Map)in.get("info");
        if (in_info != null) {
            LinkedHashMap request = new LinkedHashMap();
            request.put("method", in_info.get("method"));
            request.put("uri", in_info.get("path"));
            out.put("request", request);
            LinkedHashMap<String, Serializable> response = new LinkedHashMap<String, Serializable>();
            Map in_headers = (Map)in_info.get("headers");
            if (in_headers != null) {
                Map in_response_headers;
                Map in_request_headers = (Map)in_headers.get("request");
                if (in_request_headers != null) {
                    LinkedHashMap requestHeaders = new LinkedHashMap();
                    in_request_headers.forEach((k, v) -> requestHeaders.put(k, Collections.singletonList(v)));
                    request.put("headers", requestHeaders);
                }
                if ((in_response_headers = (Map)in_headers.get("response")) != null) {
                    if (in_response_headers.get("status") instanceof String) {
                        response.put("status", Long.valueOf(in_response_headers.get("status").toString()));
                    }
                    LinkedHashMap responseHeaders = new LinkedHashMap();
                    in_response_headers.forEach((k, v) -> responseHeaders.put(k, Collections.singletonList(v)));
                    responseHeaders.remove("status");
                    response.put("headers", responseHeaders);
                }
            }
            out.put("response", response);
            if (in_info.get("timeTaken") instanceof String) {
                out.put("timeTaken", Long.valueOf(in_info.get("timeTaken").toString()));
            }
        }
        return out;
    }

    private static Map<String, Object> convertThreaddump(List<Object> threads) {
        return Collections.singletonMap("threads", threads);
    }

    private static Map<String, Object> convertLiquibase(List<Map<String, Object>> reports) {
        Map<String, Object> liquibaseBeans = ((Stream)reports.stream().sequential()).collect(Collectors.toMap(r -> (String)r.get("name"), r -> Collections.singletonMap("changeSets", LegacyEndpointConverters.convertLiquibaseChangesets((List)r.get("changeLogs")))));
        return Collections.singletonMap("contexts", Collections.singletonMap("application", Collections.singletonMap("liquibaseBeans", liquibaseBeans)));
    }

    private static List<Map<String, Object>> convertLiquibaseChangesets(List<Map<String, Object>> changeSets) {
        return changeSets.stream().map(changeset -> {
            LinkedHashMap converted = new LinkedHashMap();
            converted.put("id", changeset.get("ID"));
            converted.put("author", changeset.get("AUTHOR"));
            converted.put("changeLog", changeset.get("FILENAME"));
            if (changeset.get("DATEEXECUTED") instanceof Long) {
                converted.put("dateExecuted", new Date((Long)changeset.get("DATEEXECUTED")));
            }
            converted.put("orderExecuted", changeset.get("ORDEREXECUTED"));
            converted.put("execType", changeset.get("EXECTYPE"));
            converted.put("checksum", changeset.get("MD5SUM"));
            converted.put("description", changeset.get("DESCRIPTION"));
            converted.put("comments", changeset.get("COMMENTS"));
            converted.put("tag", changeset.get("TAG"));
            converted.put("contexts", changeset.get("CONTEXTS") instanceof String ? new LinkedHashSet<String>(Arrays.asList(((String)changeset.get("CONTEXTS")).split(",\\s*"))) : Collections.emptySet());
            converted.put("labels", changeset.get("LABELS") instanceof String ? new LinkedHashSet<String>(Arrays.asList(((String)changeset.get("LABELS")).split(",\\s*"))) : Collections.emptySet());
            converted.put("deploymentId", changeset.get("DEPLOYMENT_ID"));
            return converted;
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> convertFlyway(List<Map<String, Object>> reports) {
        Map<String, Object> flywayBeans = ((Stream)reports.stream().sequential()).collect(Collectors.toMap(r -> (String)r.get("name"), r -> Collections.singletonMap("migrations", LegacyEndpointConverters.convertFlywayMigrations((List)r.get("migrations")))));
        return Collections.singletonMap("contexts", Collections.singletonMap("application", Collections.singletonMap("flywayBeans", flywayBeans)));
    }

    private static List<Map<String, Object>> convertFlywayMigrations(List<Map<String, Object>> migrations) {
        return migrations.stream().map(migration -> {
            LinkedHashMap<String, Date> converted = new LinkedHashMap<String, Date>((Map<String, Date>)migration);
            if (migration.get("installedOn") instanceof Long) {
                converted.put("installedOn", new Date((Long)migration.get("installedOn")));
            }
            return converted;
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> convertBeans(List<Map<String, Object>> contextBeans) {
        Map convertedContexts = contextBeans.stream().map(context -> {
            String parentId;
            String contextName = (String)context.get("context");
            if (contextName.equals(parentId = (String)context.get("parent"))) {
                contextName = contextName + ".child";
            }
            List legacyBeans = (List)context.get("beans");
            Map convertedBeans = legacyBeans.stream().collect(Collectors.toMap(bean -> (String)bean.get("bean"), Function.identity()));
            LinkedHashMap<String, Object> convertedContext = new LinkedHashMap<String, Object>();
            convertedContext.put("contextName", contextName);
            convertedContext.put("parentId", parentId);
            convertedContext.put("beans", convertedBeans);
            return convertedContext;
        }).collect(Collectors.toMap(context -> (String)context.get("contextName"), Function.identity()));
        return Collections.singletonMap("contexts", convertedContexts);
    }

    private static Map<String, Object> convertConfigprops(Map<String, Object> configProps) {
        LinkedHashMap<String, Map<String, Object>> contexts = new LinkedHashMap<String, Map<String, Object>>();
        Object parentConfigProps = configProps.get("parent");
        if (parentConfigProps != null) {
            configProps.remove("parent");
            contexts.put("parentContext", Collections.singletonMap("beans", parentConfigProps));
        }
        contexts.put("application", Collections.singletonMap("beans", configProps));
        return Collections.singletonMap("contexts", contexts);
    }

    private static Map<String, Object> convertMappings(Map<String, Object> mappings) {
        List convertedMappings = mappings.entrySet().stream().map(entry -> {
            LinkedHashMap<String, Object> convertedMapping = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Map<String, Object>> convertedMappingDetails = new LinkedHashMap<String, Map<String, Object>>();
            convertedMapping.put("details", convertedMappingDetails);
            String predicate = (String)entry.getKey();
            convertedMapping.put("predicate", predicate);
            String method = (String)((Map)entry.getValue()).get("method");
            if (method != null) {
                convertedMapping.put("handler", method);
                convertedMappingDetails.put("handlerMethod", LegacyEndpointConverters.convertMappingHandlerMethod(method));
            }
            convertedMappingDetails.put("requestMappingConditions", LegacyEndpointConverters.convertMappingConditions(predicate));
            return convertedMapping;
        }).collect(Collectors.toList());
        return Collections.singletonMap("contexts", Collections.singletonMap("application", Collections.singletonMap("mappings", Collections.singletonMap("dispatcherServlets", Collections.singletonMap("dispatcherServlet", convertedMappings)))));
    }

    private static Map<String, Object> convertMappingConditions(String predicate) {
        String[] conditionPairs = predicate.replaceAll("\\{\\[|\\]\\}", "").replaceAll("[\\[\\]]", "").split(",");
        LinkedHashMap<String, Object> conditionsMap = new LinkedHashMap<String, Object>();
        conditionsMap.put("consumes", Collections.emptyList());
        conditionsMap.put("headers", Collections.emptyList());
        conditionsMap.put("methods", Collections.emptyList());
        conditionsMap.put("params", Collections.emptyList());
        conditionsMap.put("patterns", Collections.emptyList());
        conditionsMap.put("produces", Collections.emptyList());
        Arrays.stream(conditionPairs).forEach(condition -> {
            String[] conditionParts = condition.split("=");
            boolean isPattern = conditionParts.length == 2;
            String conditionKey = isPattern ? conditionParts[0] : "patterns";
            String conditionValueStr = isPattern ? conditionParts[1] : conditionParts[0];
            List<String> conditionValue = Arrays.asList(conditionValueStr.split(" \\|\\| "));
            switch (conditionKey) {
                case "consumes": 
                case "produces": {
                    conditionValue = conditionValue.stream().map(v -> Collections.singletonMap("mediaType", v)).collect(Collectors.toList());
                    break;
                }
            }
            conditionsMap.put(conditionKey, conditionValue);
        });
        return conditionsMap;
    }

    private static Map<String, Object> convertMappingHandlerMethod(String methodDeclaration) {
        String[] declarationParts = methodDeclaration.replaceAll("<[a-zA-Z1-9$_\\.,<> ]*>", "").split(" ");
        String method = declarationParts[2];
        String methodRef = method.substring(0, method.indexOf(40));
        String className = methodRef.substring(0, methodRef.lastIndexOf(46));
        String methodName = methodRef.substring(methodRef.lastIndexOf(46) + 1);
        String returnType = declarationParts[1].replaceFirst("^", "L").replace(".", "/").concat(";");
        String methodArgs = Arrays.stream(method.substring(method.indexOf(40), method.length() - 1).replaceAll("[()]", "").split(",")).map(arg -> arg.replaceFirst("^", "L").replace(".", "/").concat(";")).collect(Collectors.joining("", "(", ")"));
        LinkedHashMap<String, Object> handlerMethod = new LinkedHashMap<String, Object>();
        handlerMethod.put("className", className);
        handlerMethod.put("descriptor", methodArgs + returnType);
        handlerMethod.put("name", methodName);
        return handlerMethod;
    }

    @Nullable
    private static Instant getInstant(Object o) {
        try {
            if (o instanceof String) {
                return OffsetDateTime.parse((String)o, TIMESTAMP_PATTERN).toInstant();
            }
            if (o instanceof Long) {
                return Instant.ofEpochMilli((Long)o);
            }
        }
        catch (ClassCastException | DateTimeException ex) {
            return null;
        }
        return null;
    }

    static {
        TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        ObjectMapper om = Jackson2ObjectMapperBuilder.json().featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).build();
        DECODER = new Jackson2JsonDecoder(om, new MimeType[0]);
        ENCODER = new Jackson2JsonEncoder(om, new MimeType[0]);
    }
}

