/*
 * Decompiled with CFR 0.152.
 */
package de.dynamicfiles.projects.gradle.plugins.javafx;

import de.dynamicfiles.projects.gradle.plugins.javafx.JavaFXGradlePluginExtension;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.JfxGenerateKeystoreTask;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.JfxJarTask;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.JfxListBundlersTask;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.JfxNativeTask;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.JfxRunTask;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.internal.JavaDetectionTools;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.internal.MonkeyPatcher;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.internal.classloader.ClasspathUtil;

public class JavaFXGradlePlugin
implements Plugin<Project> {
    public static final String ANT_JAVAFX_JAR_FILENAME = "ant-javafx.jar";

    public void apply(Project project) {
        if (project.getTasks().findByName("jar") == null) {
            throw new GradleException("Could not find jar-task. Please make sure you are applying the 'java'-plugin.");
        }
        JfxJarTask jarTask = (JfxJarTask)project.getTasks().replace("jfxJar", JfxJarTask.class);
        JfxNativeTask nativeTask = (JfxNativeTask)project.getTasks().replace("jfxNative", JfxNativeTask.class);
        JfxGenerateKeystoreTask generateKeystoreTask = (JfxGenerateKeystoreTask)project.getTasks().replace("jfxGenerateKeyStore", JfxGenerateKeystoreTask.class);
        JfxRunTask runTask = (JfxRunTask)project.getTasks().replace("jfxRun", JfxRunTask.class);
        JfxListBundlersTask jfxListBundlersTask = (JfxListBundlersTask)project.getTasks().replace("jfxListBundlers", JfxListBundlersTask.class);
        String taskGroupName = "JavaFX";
        jarTask.setGroup(taskGroupName);
        jarTask.setDescription("Create executable JavaFX-jar");
        nativeTask.setGroup(taskGroupName);
        nativeTask.setDescription("Create native JavaFX-bundle");
        generateKeystoreTask.setGroup(taskGroupName);
        generateKeystoreTask.setDescription("Create a Java keystore");
        runTask.setGroup(taskGroupName);
        runTask.setDescription("Start generated JavaFX-jar");
        jfxListBundlersTask.setGroup(taskGroupName);
        jfxListBundlersTask.setDescription("List all possible bundlers available on this system, use '--info' parameter for detailed information");
        jarTask.dependsOn(new Object[]{project.getTasks().getByName("jar")});
        nativeTask.dependsOn(new Object[]{jarTask});
        runTask.dependsOn(new Object[]{jarTask});
        project.getExtensions().create("jfx", JavaFXGradlePluginExtension.class, new Object[0]);
        project.afterEvaluate(evaluatedProject -> this.addJavaFXAntJARToGradleBuildpath((Project)evaluatedProject));
    }

    private void addJavaFXAntJARToGradleBuildpath(Project project) {
        URLClassLoader sysloader;
        File jfxAntJar;
        String jfxAntJarPath = "/../lib/ant-javafx.jar";
        if (JavaDetectionTools.IS_JAVA_9) {
            jfxAntJarPath = "/lib/ant-javafx.jar";
        }
        if (!(jfxAntJar = new File(System.getProperty("java.home") + jfxAntJarPath)).exists()) {
            throw new GradleException("Couldn't find Ant-JavaFX-library, please make sure you've installed some JDK which includes JavaFX (e.g. OracleJDK or OpenJDK and OpenJFX), and JAVA_HOME is set properly.");
        }
        ClassLoader buildscriptClassloader = project.getBuildscript().getClassLoader();
        if ("org.gradle.internal.classloader.CachingClassLoader".equals(buildscriptClassloader.getClass().getName())) {
            project.getLogger().debug("Using JavaFXGradlePlugin-class classloader");
            sysloader = (URLClassLoader)this.getClass().getClassLoader();
        } else {
            project.getLogger().debug("Using buildscript classloader");
            sysloader = (URLClassLoader)buildscriptClassloader;
        }
        try {
            List loadedAntJavaFXLibs;
            boolean usePatchedJar = System.getProperty("os.name").toLowerCase().startsWith("windows") && this.isGradleDaemonMode() && (JavaDetectionTools.IS_JAVA_9 || JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(60));
            boolean usePatchedJFXAntLib = ((JavaFXGradlePluginExtension)project.getExtensions().getByType(JavaFXGradlePluginExtension.class)).isUsePatchedJFXAntLib();
            if (usePatchedJar && !usePatchedJFXAntLib) {
                usePatchedJar = false;
                project.getLogger().warn("You disabled the patching (by setting 'usePatchedJFXAntLib'-property to 'false' inside 'jfx'-configuration) of the ant-javafx.jar, please make sure you know about the consequences.");
            }
            boolean alreadyLoaded = (loadedAntJavaFXLibs = Arrays.asList(sysloader.getURLs()).stream().filter(loadedURL -> loadedURL.toExternalForm().endsWith(ANT_JAVAFX_JAR_FILENAME)).collect(Collectors.toList())).size() > 0;
            boolean workaroundLoaded = loadedAntJavaFXLibs.stream().filter(libURL -> libURL.toExternalForm().contains("javafx-gradle-plugin-workaround")).count() > 0L;
            project.getLogger().debug("DEBUG > Having " + loadedAntJavaFXLibs.size() + " loadedJars");
            if (!alreadyLoaded) {
                ArrayList<URL> antJarList = new ArrayList<URL>();
                if (usePatchedJar) {
                    URL patchedJfxAntJar = MonkeyPatcher.getPatchedJfxAntJar();
                    antJarList.add(patchedJfxAntJar);
                    project.getLogger().info("using patched ant-javafx.jar, located at > " + patchedJfxAntJar.toExternalForm());
                } else {
                    antJarList.add(jfxAntJar.toURI().toURL());
                }
                ClasspathUtil.addUrl((URLClassLoader)sysloader, antJarList);
            } else if (!usePatchedJFXAntLib && workaroundLoaded) {
                project.getLogger().warn("Please restart gradle-daemon! Patched ant-javafx.jar is loaded, but you disabled to patch and use that file.");
            }
        }
        catch (MalformedURLException ex) {
            throw new GradleException("Could not add Ant-JavaFX-JAR to plugin-classloader", (Throwable)ex);
        }
    }

    protected boolean isGradleDaemonMode() {
        String javaCommand = System.getProperty("sun.java.command");
        return javaCommand != null && javaCommand.startsWith("org.gradle.launcher.daemon");
    }
}

