/*
 * Decompiled with CFR 0.152.
 */
package de.dynamicfiles.projects.gradle.plugins.javafx.tasks.internal;

import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.internal.JavaDetectionTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class MonkeyPatcher {
    private static final String METHOD_TO_MONKEY_PATCH = "copyMSVCDLLs";
    private static final String METHOD_SIGNATURE_TO_MONKEY_PATCH = "(Ljava/io/File;Ljava/io/File;)V";
    private static final String FAULTY_CLASSFILE_TO_MONKEY_PATCH = "com/oracle/tools/packager/windows/WinAppBundler.class";
    public static final String WORKAROUND_DIRECTORY_NAME = "javafx-gradle-plugin-workaround";

    public static URL getPatchedJfxAntJar() throws MalformedURLException {
        File jfxAntJar;
        String jfxAntJarPath = "/../lib/ant-javafx.jar";
        if (JavaDetectionTools.IS_JAVA_9) {
            jfxAntJarPath = "/lib/ant-javafx.jar";
        }
        if (!(jfxAntJar = new File(System.getProperty("java.home") + jfxAntJarPath)).exists()) {
            throw new RuntimeException("Couldn't find Ant-JavaFX-library, please make sure you've installed some JDK which includes JavaFX (e.g. OracleJDK or OpenJDK and OpenJFX), and JAVA_HOME is set properly.");
        }
        try {
            Path tempDirectory = Files.createTempDirectory(WORKAROUND_DIRECTORY_NAME, new FileAttribute[0]);
            tempDirectory.toFile().deleteOnExit();
            JarFile jarFile = new JarFile(jfxAntJar, false, 1);
            File targetManipulatedJarFile = tempDirectory.resolve("ant-javafx.jar").toAbsolutePath().toFile();
            targetManipulatedJarFile.deleteOnExit();
            AtomicBoolean useModifiedVersion = new AtomicBoolean(false);
            try (FileOutputStream processedAntJar = new FileOutputStream(targetManipulatedJarFile);){
                ZipOutputStream zipOutputStream = new ZipOutputStream(processedAntJar);
                jarFile.stream().forEachOrdered(jarEntry -> {
                    ZipEntry zipEntry = new ZipEntry(jarEntry.getName());
                    try {
                        zipOutputStream.putNextEntry(zipEntry);
                        if (jarEntry.getName().equals(FAULTY_CLASSFILE_TO_MONKEY_PATCH)) {
                            useModifiedVersion.set(true);
                            ClassReader classReader = new ClassReader(jarFile.getInputStream((ZipEntry)jarEntry));
                            ClassWriter classWriter = new ClassWriter(classReader, 3);
                            MonkeyPatcher.doMonkeyPatchFileHandleLeak(classReader, classWriter);
                            byte[] generatedBytes = classWriter.toByteArray();
                            zipOutputStream.write(generatedBytes);
                        } else {
                            int count;
                            InputStream storedInputStream = jarFile.getInputStream((ZipEntry)jarEntry);
                            byte[] buffer = new byte[8192];
                            while ((count = storedInputStream.read(buffer)) > 0) {
                                zipOutputStream.write(buffer, 0, count);
                            }
                        }
                        zipOutputStream.flush();
                    }
                    catch (IOException | NullPointerException ex) {
                        Logger.getLogger(MonkeyPatcher.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                zipOutputStream.finish();
            }
            if (useModifiedVersion.get()) {
                return targetManipulatedJarFile.toURI().toURL();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return jfxAntJar.toURI().toURL();
    }

    private static void doMonkeyPatchFileHandleLeak(ClassReader classReader, ClassWriter classWriter) {
        classReader.accept(new ClassVisitor(327680, (ClassVisitor)classWriter){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (!name.equals(MonkeyPatcher.METHOD_TO_MONKEY_PATCH) || !desc.equals(MonkeyPatcher.METHOD_SIGNATURE_TO_MONKEY_PATCH)) {
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
                return this.getMonkeyPatchedFileHandleLeakMethodVisitor(access, name, desc, signature, exceptions);
            }

            private MethodVisitor getMonkeyPatchedFileHandleLeakMethodVisitor(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitCode() {
                        String javalangThrowable = "java/lang/Throwable";
                        String javaioFile = "java/io/File";
                        String javalangString = "java/lang/String";
                        Label l0 = new Label();
                        Label l1 = new Label();
                        Label l2 = new Label();
                        this.mv.visitTryCatchBlock(l0, l1, l2, javalangThrowable);
                        Label l3 = new Label();
                        Label l4 = new Label();
                        Label l5 = new Label();
                        this.mv.visitTryCatchBlock(l3, l4, l5, javalangThrowable);
                        Label l6 = new Label();
                        this.mv.visitTryCatchBlock(l3, l4, l6, null);
                        Label l7 = new Label();
                        Label l8 = new Label();
                        Label l9 = new Label();
                        this.mv.visitTryCatchBlock(l7, l8, l9, javalangThrowable);
                        Label l10 = new Label();
                        this.mv.visitTryCatchBlock(l5, l10, l6, null);
                        this.mv.visitInsn(1);
                        this.mv.visitVarInsn(58, 3);
                        this.mv.visitVarInsn(25, 2);
                        Label l11 = new Label();
                        this.mv.visitJumpInsn(198, l11);
                        this.mv.visitVarInsn(25, 2);
                        this.mv.visitMethodInsn(182, javaioFile, "isDirectory", "()Z", false);
                        Label l12 = new Label();
                        this.mv.visitJumpInsn(154, l12);
                        this.mv.visitLabel(l11);
                        this.mv.visitFrame(1, 1, new Object[]{javalangString}, 0, null);
                        this.mv.visitTypeInsn(187, javaioFile);
                        this.mv.visitInsn(89);
                        this.mv.visitLdcInsn((Object)"java.home");
                        this.mv.visitMethodInsn(184, "java/lang/System", "getProperty", "(Ljava/lang/String;)Ljava/lang/String;", false);
                        this.mv.visitMethodInsn(183, javaioFile, "<init>", "(Ljava/lang/String;)V", false);
                        this.mv.visitVarInsn(58, 2);
                        this.mv.visitLabel(l12);
                        this.mv.visitFrame(3, 0, null, 0, null);
                        this.mv.visitFieldInsn(178, "com/oracle/tools/packager/windows/WinAppBundler", "VS_VERS", "[Ljava/lang/String;");
                        this.mv.visitVarInsn(58, 4);
                        this.mv.visitVarInsn(25, 4);
                        this.mv.visitInsn(190);
                        this.mv.visitVarInsn(54, 5);
                        this.mv.visitInsn(3);
                        this.mv.visitVarInsn(54, 6);
                        Label l13 = new Label();
                        this.mv.visitLabel(l13);
                        this.mv.visitFrame(1, 3, new Object[]{"[Ljava/lang/String;", Opcodes.INTEGER, Opcodes.INTEGER}, 0, null);
                        this.mv.visitVarInsn(21, 6);
                        this.mv.visitVarInsn(21, 5);
                        Label l14 = new Label();
                        this.mv.visitJumpInsn(162, l14);
                        this.mv.visitVarInsn(25, 4);
                        this.mv.visitVarInsn(21, 6);
                        this.mv.visitInsn(50);
                        this.mv.visitVarInsn(58, 7);
                        this.mv.visitVarInsn(25, 0);
                        this.mv.visitVarInsn(25, 1);
                        this.mv.visitVarInsn(25, 7);
                        this.mv.visitMethodInsn(183, "com/oracle/tools/packager/windows/WinAppBundler", MonkeyPatcher.METHOD_TO_MONKEY_PATCH, "(Ljava/io/File;Ljava/lang/String;)Z", false);
                        Label l15 = new Label();
                        this.mv.visitJumpInsn(153, l15);
                        this.mv.visitVarInsn(25, 7);
                        this.mv.visitVarInsn(58, 3);
                        this.mv.visitJumpInsn(167, l14);
                        this.mv.visitLabel(l15);
                        this.mv.visitFrame(3, 0, null, 0, null);
                        this.mv.visitIincInsn(6, 1);
                        this.mv.visitJumpInsn(167, l13);
                        this.mv.visitLabel(l14);
                        this.mv.visitFrame(2, 3, null, 0, null);
                        this.mv.visitVarInsn(25, 3);
                        Label l16 = new Label();
                        this.mv.visitJumpInsn(199, l16);
                        this.mv.visitTypeInsn(187, "java/lang/RuntimeException");
                        this.mv.visitInsn(89);
                        this.mv.visitLdcInsn((Object)"Not found MSVC dlls");
                        this.mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V", false);
                        this.mv.visitInsn(191);
                        this.mv.visitLabel(l16);
                        this.mv.visitFrame(3, 0, null, 0, null);
                        this.mv.visitTypeInsn(187, "java/util/concurrent/atomic/AtomicReference");
                        this.mv.visitInsn(89);
                        this.mv.visitMethodInsn(183, "java/util/concurrent/atomic/AtomicReference", "<init>", "()V", false);
                        this.mv.visitVarInsn(58, 4);
                        this.mv.visitVarInsn(25, 3);
                        this.mv.visitVarInsn(58, 5);
                        this.mv.visitVarInsn(25, 2);
                        this.mv.visitMethodInsn(182, javaioFile, "toPath", "()Ljava/nio/file/Path;", false);
                        this.mv.visitLdcInsn((Object)"bin");
                        this.mv.visitMethodInsn(185, "java/nio/file/Path", "resolve", "(Ljava/lang/String;)Ljava/nio/file/Path;", true);
                        this.mv.visitMethodInsn(184, "java/nio/file/Files", "list", "(Ljava/nio/file/Path;)Ljava/util/stream/Stream;", false);
                        this.mv.visitVarInsn(58, 6);
                        this.mv.visitInsn(1);
                        this.mv.visitVarInsn(58, 7);
                        this.mv.visitLabel(l3);
                        this.mv.visitVarInsn(25, 6);
                        this.mv.visitInvokeDynamicInsn("test", "()Ljava/util/function/Predicate;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;"), new Object[]{Type.getType((String)"(Ljava/lang/Object;)Z"), new Handle(6, "com/oracle/tools/packager/windows/WinAppBundler", "lambda$copyMSVCDLLs$261", "(Ljava/nio/file/Path;)Z"), Type.getType((String)"(Ljava/nio/file/Path;)Z")});
                        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "filter", "(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", true);
                        this.mv.visitVarInsn(25, 5);
                        this.mv.visitInvokeDynamicInsn("test", "(Ljava/lang/String;)Ljava/util/function/Predicate;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;"), new Object[]{Type.getType((String)"(Ljava/lang/Object;)Z"), new Handle(6, "com/oracle/tools/packager/windows/WinAppBundler", "lambda$copyMSVCDLLs$262", "(Ljava/lang/String;Ljava/nio/file/Path;)Z"), Type.getType((String)"(Ljava/nio/file/Path;)Z")});
                        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "filter", "(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", true);
                        this.mv.visitVarInsn(25, 1);
                        this.mv.visitVarInsn(25, 4);
                        this.mv.visitInvokeDynamicInsn("accept", "(Ljava/io/File;Ljava/util/concurrent/atomic/AtomicReference;)Ljava/util/function/Consumer;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;"), new Object[]{Type.getType((String)"(Ljava/lang/Object;)V"), new Handle(6, "com/oracle/tools/packager/windows/WinAppBundler", "lambda$copyMSVCDLLs$263", "(Ljava/io/File;Ljava/util/concurrent/atomic/AtomicReference;Ljava/nio/file/Path;)V"), Type.getType((String)"(Ljava/nio/file/Path;)V")});
                        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "forEach", "(Ljava/util/function/Consumer;)V", true);
                        this.mv.visitLabel(l4);
                        this.mv.visitVarInsn(25, 6);
                        Label l17 = new Label();
                        this.mv.visitJumpInsn(198, l17);
                        this.mv.visitVarInsn(25, 7);
                        Label l18 = new Label();
                        this.mv.visitJumpInsn(198, l18);
                        this.mv.visitLabel(l0);
                        this.mv.visitVarInsn(25, 6);
                        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "close", "()V", true);
                        this.mv.visitLabel(l1);
                        this.mv.visitJumpInsn(167, l17);
                        this.mv.visitLabel(l2);
                        this.mv.visitFrame(0, 8, new Object[]{"com/oracle/tools/packager/windows/WinAppBundler", javaioFile, javaioFile, javalangString, "java/util/concurrent/atomic/AtomicReference", javalangString, "java/util/stream/Stream", javalangThrowable}, 1, new Object[]{javalangThrowable});
                        this.mv.visitVarInsn(58, 8);
                        this.mv.visitVarInsn(25, 7);
                        this.mv.visitVarInsn(25, 8);
                        this.mv.visitMethodInsn(182, javalangThrowable, "addSuppressed", "(Ljava/lang/Throwable;)V", false);
                        this.mv.visitJumpInsn(167, l17);
                        this.mv.visitLabel(l18);
                        this.mv.visitFrame(3, 0, null, 0, null);
                        this.mv.visitVarInsn(25, 6);
                        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "close", "()V", true);
                        this.mv.visitJumpInsn(167, l17);
                        this.mv.visitLabel(l5);
                        this.mv.visitFrame(4, 0, null, 1, new Object[]{javalangThrowable});
                        this.mv.visitVarInsn(58, 8);
                        this.mv.visitVarInsn(25, 8);
                        this.mv.visitVarInsn(58, 7);
                        this.mv.visitVarInsn(25, 8);
                        this.mv.visitInsn(191);
                        this.mv.visitLabel(l6);
                        this.mv.visitFrame(4, 0, null, 1, new Object[]{javalangThrowable});
                        this.mv.visitVarInsn(58, 9);
                        this.mv.visitLabel(l10);
                        this.mv.visitVarInsn(25, 6);
                        Label l19 = new Label();
                        this.mv.visitJumpInsn(198, l19);
                        this.mv.visitVarInsn(25, 7);
                        Label l20 = new Label();
                        this.mv.visitJumpInsn(198, l20);
                        this.mv.visitLabel(l7);
                        this.mv.visitVarInsn(25, 6);
                        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "close", "()V", true);
                        this.mv.visitLabel(l8);
                        this.mv.visitJumpInsn(167, l19);
                        this.mv.visitLabel(l9);
                        this.mv.visitFrame(0, 10, new Object[]{"com/oracle/tools/packager/windows/WinAppBundler", javaioFile, javaioFile, javalangString, "java/util/concurrent/atomic/AtomicReference", javalangString, "java/util/stream/Stream", javalangThrowable, Opcodes.TOP, javalangThrowable}, 1, new Object[]{javalangThrowable});
                        this.mv.visitVarInsn(58, 10);
                        this.mv.visitVarInsn(25, 7);
                        this.mv.visitVarInsn(25, 10);
                        this.mv.visitMethodInsn(182, javalangThrowable, "addSuppressed", "(Ljava/lang/Throwable;)V", false);
                        this.mv.visitJumpInsn(167, l19);
                        this.mv.visitLabel(l20);
                        this.mv.visitFrame(3, 0, null, 0, null);
                        this.mv.visitVarInsn(25, 6);
                        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "close", "()V", true);
                        this.mv.visitLabel(l19);
                        this.mv.visitFrame(3, 0, null, 0, null);
                        this.mv.visitVarInsn(25, 9);
                        this.mv.visitInsn(191);
                        this.mv.visitLabel(l17);
                        this.mv.visitFrame(0, 6, new Object[]{"com/oracle/tools/packager/windows/WinAppBundler", javaioFile, javaioFile, javalangString, "java/util/concurrent/atomic/AtomicReference", javalangString}, 0, new Object[0]);
                        this.mv.visitVarInsn(25, 4);
                        this.mv.visitMethodInsn(182, "java/util/concurrent/atomic/AtomicReference", "get", "()Ljava/lang/Object;", false);
                        this.mv.visitTypeInsn(192, "java/io/IOException");
                        this.mv.visitVarInsn(58, 6);
                        this.mv.visitVarInsn(25, 6);
                        Label l21 = new Label();
                        this.mv.visitJumpInsn(198, l21);
                        this.mv.visitVarInsn(25, 6);
                        this.mv.visitInsn(191);
                        this.mv.visitLabel(l21);
                        this.mv.visitFrame(1, 1, new Object[]{"java/io/IOException"}, 0, null);
                        this.mv.visitInsn(177);
                    }
                };
            }
        }, 8);
    }
}

