/*
 * Decompiled with CFR 0.152.
 */
package de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workarounds;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.internal.JavaDetectionTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class MacAppBundlerWithAdditionalResources
extends MacAppBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacAppBundler.class.getName());
    private static final String LIBRARY_NAME = "libpackager.dylib";
    private static final Class<MacAppBundler> ORIGINAL_MAC_APP_BUNDLER_CLASS = MacAppBundler.class;
    public static final BundlerParamInfo<File> ADDITIONAL_BUNDLER_RESOURCES = new StandardBundlerParam("additional bundler resources", "Field for providing additional resources that will be put into generation-folder.", "mac.app.additionalBundlerResources", File.class, params -> null, (s, p) -> new File((String)s));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File doBundle(Map<String, ? super Object> p, File outputDirectory, boolean dependentTask) {
        File rootDirectory;
        block27: {
            block24: {
                HashMap<String, ? super Object> originalParams;
                File additionalBundlerResources;
                block22: {
                    File file;
                    block26: {
                        block23: {
                            additionalBundlerResources = (File)ADDITIONAL_BUNDLER_RESOURCES.fetchFrom(p);
                            if (additionalBundlerResources == null) {
                                return super.doBundle(p, outputDirectory, dependentTask);
                            }
                            Log.info((String)"Using special javafx-maven-plugin MacAppBundler");
                            originalParams = new HashMap<String, Object>(p);
                            this.doOutputFolderChecks(outputDirectory);
                            rootDirectory = null;
                            File predefinedImage = MacBaseInstallerBundler.getPredefinedImage(p);
                            if (predefinedImage == null) break block22;
                            file = predefinedImage;
                            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) break block23;
                            this.cleanupConfigFiles(p);
                            break block26;
                        }
                        Log.info((String)MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(p)).getAbsolutePath()));
                    }
                    return file;
                }
                try {
                    StandardBundlerParam.BUILD_ROOT.fetchFrom(p);
                    this.prepareConfigFiles(p);
                    rootDirectory = new File(outputDirectory, (String)StandardBundlerParam.APP_NAME.fetchFrom(p) + ".app");
                    IOUtils.deleteRecursive((File)rootDirectory);
                    rootDirectory.mkdirs();
                    if (!dependentTask) {
                        Log.info((String)MessageFormat.format(I18N.getString("message.creating-app-bundle"), rootDirectory.getAbsolutePath()));
                    }
                    File contentsDirectory = new File(rootDirectory, "Contents");
                    contentsDirectory.mkdirs();
                    File macOSDirectory = new File(contentsDirectory, "MacOS");
                    macOSDirectory.mkdirs();
                    File javaDirectory = new File(contentsDirectory, "Java");
                    javaDirectory.mkdirs();
                    File plugInsDirectory = new File(contentsDirectory, "PlugIns");
                    File resourcesDirectory = new File(contentsDirectory, "Resources");
                    resourcesDirectory.mkdirs();
                    File pkgInfoFile = new File(contentsDirectory, "PkgInfo");
                    pkgInfoFile.createNewFile();
                    this.writePkgInfo(pkgInfoFile);
                    File executableFile = new File(macOSDirectory, this.getLauncherName(p));
                    IOUtils.copyFromURL((URL)((URL)RAW_EXECUTABLE_URL.fetchFrom(p)), (File)executableFile);
                    if (JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(40)) {
                        IOUtils.copyFromURL((URL)MacResources.class.getResource(LIBRARY_NAME), (File)new File(macOSDirectory, LIBRARY_NAME));
                        if (JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(60) && !((Boolean)MAC_CONFIGURE_LAUNCHER_IN_PLIST.fetchFrom(p)).booleanValue()) {
                            if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(p)).equals("prop")) {
                                this.writeCfgFile(p, rootDirectory);
                            } else {
                                this.writeCfgFile(p, new File(rootDirectory, MacAppBundlerWithAdditionalResources.getLauncherCfgName(p)), this.getRuntimeLocation(p));
                            }
                        }
                    }
                    executableFile.setExecutable(true, false);
                    this.copyRuntime(plugInsDirectory, p);
                    this.copyClassPathEntries(javaDirectory, p);
                    IOUtils.copyFile((File)this.getConfig_Icon(p), (File)new File(resourcesDirectory, this.getConfig_Icon(p).getName()));
                    if (JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(60)) {
                        for (Map fa : (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(p)) {
                            File f = (File)StandardBundlerParam.FA_ICON.fetchFrom(fa);
                            if (f == null || !f.exists()) continue;
                            IOUtils.copyFile((File)f, (File)new File(resourcesDirectory, f.getName()));
                        }
                    }
                    IOUtils.copyFile((File)this.getConfig_InfoPlist(p), (File)new File(contentsDirectory, "Info.plist"));
                    if (JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(60)) {
                        for (Map entryPoint : (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(p)) {
                            HashMap<String, ? super Object> tmp = new HashMap<String, Object>(originalParams);
                            tmp.putAll(entryPoint);
                            this.createLauncherForEntryPoint(tmp, rootDirectory);
                        }
                    }
                    Log.info((String)"Copying additional bundler resources...");
                    final Path sourceFolder = additionalBundlerResources.toPath();
                    final Path targetFolder = rootDirectory.toPath();
                    final AtomicReference<Object> copyingException = new AtomicReference<Object>(null);
                    final AtomicInteger copiedFiles = new AtomicInteger(0);
                    Files.walkFileTree(sourceFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path subfolder, BasicFileAttributes attrs) throws IOException {
                            Files.createDirectories(targetFolder.resolve(sourceFolder.relativize(subfolder)), new FileAttribute[0]);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path sourceFile, BasicFileAttributes attrs) throws IOException {
                            Files.copy(sourceFile, targetFolder.resolve(sourceFolder.relativize(sourceFile)), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                            copiedFiles.incrementAndGet();
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path source, IOException ioe) throws IOException {
                            copyingException.set(ioe);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path source, IOException ioe) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    if (copyingException.get() != null) {
                        throw new RuntimeException("Got exception while copying additional bundler resources", copyingException.get());
                    }
                    Log.info((String)("Copied additional bundler resources count: " + copiedFiles.get()));
                    String signingIdentity = (String)DEVELOPER_ID_APP_SIGNING_KEY.fetchFrom(p);
                    if (signingIdentity != null) {
                        if (JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(40)) {
                            if (((Boolean)Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(p)).orElse(Boolean.TRUE)).booleanValue()) {
                                MacBaseInstallerBundler.signAppBundle(p, (File)rootDirectory, (String)signingIdentity, (String)((String)BUNDLE_ID_SIGNING_PREFIX.fetchFrom(p)));
                            }
                        } else {
                            MacBaseInstallerBundler.signAppBundle(p, (File)rootDirectory, (String)signingIdentity, (String)((String)BUNDLE_ID_SIGNING_PREFIX.fetchFrom(p)));
                        }
                    }
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) break block24;
                }
                catch (IOException ex) {
                    File file;
                    block28: {
                        block25: {
                            try {
                                Log.info((String)ex.toString());
                                Log.verbose((Throwable)ex);
                                file = null;
                                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) break block25;
                            }
                            catch (Throwable throwable) {
                                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                                    this.cleanupConfigFiles(p);
                                } else {
                                    Log.info((String)MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(p)).getAbsolutePath()));
                                }
                                throw throwable;
                            }
                            this.cleanupConfigFiles(p);
                            break block28;
                        }
                        Log.info((String)MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(p)).getAbsolutePath()));
                    }
                    return file;
                }
                this.cleanupConfigFiles(p);
                break block27;
            }
            Log.info((String)MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(p)).getAbsolutePath()));
        }
        return rootDirectory;
    }

    private void doOutputFolderChecks(File outputDirectory) {
        if (!outputDirectory.isDirectory() && !outputDirectory.mkdirs()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outputDirectory.getAbsolutePath()));
        }
        if (!outputDirectory.canWrite()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outputDirectory.getAbsolutePath()));
        }
    }

    private void prepareConfigFiles(Map<String, ? super Object> params) throws IOException {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("prepareConfigFiles", Map.class);
                method.setAccessible(true);
                method.invoke((Object)this, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof InvocationTargetException)) break block3;
                Throwable cause = ((InvocationTargetException)ex).getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (!(cause instanceof RuntimeException)) break block3;
                throw (RuntimeException)cause;
            }
        }
    }

    private void writeCfgFile(Map<String, ? super Object> params, File rootDir) throws FileNotFoundException {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("writeCfgFile", Map.class, File.class);
                method.setAccessible(true);
                method.invoke((Object)this, params, rootDir);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof InvocationTargetException)) break block3;
                Throwable cause = ((InvocationTargetException)ex).getCause();
                if (cause instanceof FileNotFoundException) {
                    throw (FileNotFoundException)cause;
                }
                if (!(cause instanceof RuntimeException)) break block3;
                throw (RuntimeException)cause;
            }
        }
    }

    private void writePkgInfo(File file) throws IOException {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("writePkgInfo", File.class);
                method.setAccessible(true);
                method.invoke((Object)this, file);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof InvocationTargetException)) break block3;
                Throwable cause = ((InvocationTargetException)ex).getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (!(cause instanceof RuntimeException)) break block3;
                throw (RuntimeException)cause;
            }
        }
    }

    private void copyRuntime(File plugInsDirectory, Map<String, ? super Object> params) throws IOException {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("copyRuntime", File.class, Map.class);
                method.setAccessible(true);
                method.invoke((Object)this, plugInsDirectory, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof InvocationTargetException)) break block3;
                Throwable cause = ((InvocationTargetException)ex).getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (!(cause instanceof RuntimeException)) break block3;
                throw (RuntimeException)cause;
            }
        }
    }

    private void copyClassPathEntries(File javaDirectory, Map<String, ? super Object> params) throws IOException {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("copyClassPathEntries", File.class, Map.class);
                method.setAccessible(true);
                method.invoke((Object)this, javaDirectory, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof InvocationTargetException)) break block3;
                Throwable cause = ((InvocationTargetException)ex).getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (!(cause instanceof RuntimeException)) break block3;
                throw (RuntimeException)cause;
            }
        }
    }

    private File getConfig_Icon(Map<String, ? super Object> params) {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("getConfig_Icon", Map.class);
                method.setAccessible(true);
                Object invokationResult = method.invoke((Object)this, params);
                if (invokationResult instanceof File) {
                    return (File)invokationResult;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof RuntimeException)) break block3;
                throw (RuntimeException)ex;
            }
        }
        return null;
    }

    private String getRuntimeLocation(Map<String, ? super Object> params) {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("getRuntimeLocation", Map.class);
                method.setAccessible(true);
                Object invokationResult = method.invoke((Object)this, params);
                if (invokationResult instanceof String) {
                    return (String)invokationResult;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof RuntimeException)) break block3;
                throw (RuntimeException)ex;
            }
        }
        return null;
    }

    private File getConfig_InfoPlist(Map<String, ? super Object> params) {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("getConfig_InfoPlist", Map.class);
                method.setAccessible(true);
                Object invokationResult = method.invoke((Object)this, params);
                if (invokationResult instanceof File) {
                    return (File)invokationResult;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof RuntimeException)) break block3;
                throw (RuntimeException)ex;
            }
        }
        return null;
    }

    private void createLauncherForEntryPoint(Map<String, ? super Object> p, File rootDirectory) throws IOException {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("createLauncherForEntryPoint", Map.class, File.class);
                method.setAccessible(true);
                method.invoke((Object)this, p, rootDirectory);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof InvocationTargetException)) break block3;
                Throwable cause = ((InvocationTargetException)ex).getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (!(cause instanceof RuntimeException)) break block3;
                throw (RuntimeException)cause;
            }
        }
    }

    private String getLauncherName(Map<String, ? super Object> params) {
        block3: {
            try {
                Method method = ORIGINAL_MAC_APP_BUNDLER_CLASS.getDeclaredMethod("getLauncherName", Map.class);
                method.setAccessible(true);
                Object invokationResult = method.invoke((Object)this, params);
                if (invokationResult instanceof String) {
                    return (String)invokationResult;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                if (!(ex instanceof RuntimeException)) break block3;
                throw (RuntimeException)ex;
            }
        }
        return null;
    }
}

