/*
 * Decompiled with CFR 0.152.
 */
package de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers;

import com.oracle.tools.packager.Log;
import de.dynamicfiles.projects.gradle.plugins.javafx.JavaFXGradlePluginExtension;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers.JfxAbstractWorker;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class JfxGenerateKeystoreWorker
extends JfxAbstractWorker {
    public void jfxgeneratekeystore(Project project) {
        JavaFXGradlePluginExtension ext = (JavaFXGradlePluginExtension)project.getExtensions().getByType(JavaFXGradlePluginExtension.class);
        this.addDeployDirToSystemClassloader(project, ext);
        Log.setLogger((Log.Logger)new Log.Logger(ext.isVerbose()));
        File keyStore = this.getAbsoluteOrProjectRelativeFile(project, ext.getKeyStore(), ext.isCheckForAbsolutePaths());
        if (keyStore.exists()) {
            if (ext.isOverwriteKeyStore()) {
                if (!keyStore.delete()) {
                    throw new GradleException("Unable to delete existing keystore at: " + keyStore);
                }
            } else {
                throw new GradleException("Keystore already exists (set 'overwriteKeyStore' to force) at: " + keyStore);
            }
        }
        this.checkKeystoreRequiredParameter(ext.getKeyStoreAlias(), "keyStoreAlias");
        this.checkKeystoreRequiredParameter(ext.getKeyStorePassword(), "keyStorePassword");
        if (ext.getKeyPassword() == null) {
            ext.setKeyPassword(ext.getKeyStorePassword());
        }
        ArrayList<String> distinguishedNameParts = new ArrayList<String>();
        this.checkAndAddRequiredField(distinguishedNameParts, "certDomain", ext.getCertDomain(), "cn");
        this.checkAndAddRequiredField(distinguishedNameParts, "certOrgUnit", ext.getCertOrgUnit(), "ou", () -> "none");
        this.checkAndAddRequiredField(distinguishedNameParts, "certOrg", ext.getCertOrg(), "o");
        this.checkAndAddRequiredField(distinguishedNameParts, "certState", ext.getCertState(), "st");
        this.checkAndAddRequiredField(distinguishedNameParts, "certCountry", ext.getCertCountry(), "c");
        this.generateKeyStore(project, keyStore, ext.getKeyStoreAlias(), ext.getKeyStorePassword(), ext.getKeyPassword(), String.join((CharSequence)", ", distinguishedNameParts), ext.isVerbose(), ext.isUseEnvironmentRelativeExecutables());
    }

    protected void generateKeyStore(Project project, File keyStore, String keyStoreAlias, String keyStorePassword, String keyPassword, String distinguishedName, boolean verbose, boolean useEnvironmentRelativeExecutables) {
        project.getLogger().info("Generating keystore in: " + keyStore);
        try {
            Files.createDirectories(keyStore.getParentFile().toPath(), new FileAttribute[0]);
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.getEnvironmentRelativeExecutablePath(useEnvironmentRelativeExecutables) + "keytool");
            command.add("-genkeypair");
            command.add("-keystore");
            command.add(keyStore.getPath());
            command.add("-alias");
            command.add(keyStoreAlias);
            command.add("-storepass");
            command.add(keyStorePassword);
            command.add("-keypass");
            command.add(keyPassword);
            command.add("-dname");
            command.add(distinguishedName);
            command.add("-sigalg");
            command.add("SHA256withRSA");
            command.add("-validity");
            command.add("100");
            command.add("-keyalg");
            command.add("RSA");
            command.add("-keysize");
            command.add("2048");
            if (verbose) {
                command.add("-v");
            }
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            if (!this.isGradleDaemonMode()) {
                pb.inheritIO();
            }
            if (verbose) {
                project.getLogger().lifecycle("Running command: " + String.join((CharSequence)" ", command));
            }
            pb.command(command);
            Process p = pb.start();
            if (this.isGradleDaemonMode()) {
                this.redirectIO(p, project.getLogger());
            }
            p.waitFor();
        }
        catch (IOException | InterruptedException ex) {
            throw new GradleException("There was an exception while generating keystore.", (Throwable)ex);
        }
    }

    private void checkKeystoreRequiredParameter(String value, String valueName) {
        if (value == null || value.trim().isEmpty()) {
            throw new GradleException("The property '" + valueName + "' is required to generate a new KeyStore.");
        }
    }

    private void checkAndAddRequiredField(List<String> distinguishedNameParts, String propertyName, String value, String fieldName) {
        this.checkAndAddRequiredField(distinguishedNameParts, propertyName, value, fieldName, null);
    }

    private void checkAndAddRequiredField(List<String> distinguishedNameParts, String propertyName, String value, String fieldName, RequiredFieldAlternativeCallback alternative) {
        if (value != null && !value.trim().isEmpty()) {
            distinguishedNameParts.add(fieldName + "=" + value);
        } else {
            if (alternative == null || alternative.getValue() == null || alternative.getValue().trim().isEmpty()) {
                throw new GradleException("The property '" + propertyName + "' must be provided to generate a new certificate.");
            }
            distinguishedNameParts.add(fieldName + "=" + alternative.getValue());
        }
    }

    @FunctionalInterface
    private static interface RequiredFieldAlternativeCallback {
        public String getValue();
    }
}

