/*
 * Decompiled with CFR 0.152.
 */
package de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers;

import com.oracle.tools.packager.Log;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import de.dynamicfiles.projects.gradle.plugins.javafx.JavaFXGradlePluginExtension;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers.JfxAbstractWorker;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.bundling.Jar;

public class JfxJarWorker
extends JfxAbstractWorker {
    public void jfxjar(Project project) {
        Path someTempDir;
        final JavaFXGradlePluginExtension ext = (JavaFXGradlePluginExtension)project.getExtensions().getByType(JavaFXGradlePluginExtension.class);
        this.addDeployDirToSystemClassloader(project, ext);
        Log.setLogger((Log.Logger)new Log.Logger(ext.isVerbose()));
        Jar jarTask = (Jar)project.getTasks().findByName("jar");
        try {
            someTempDir = Files.createTempDirectory("javafx-gradle-plugin", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new GradleException("Couldn't create temporary folder", (Throwable)ex);
        }
        project.getLogger().info("Extraction of generated JAR-file ...");
        project.copy(copySpec -> {
            copySpec.into((Object)someTempDir.toFile());
            if (ext.getAlternativePathToJarFile() == null) {
                copySpec.from(new Object[]{project.zipTree((Object)jarTask.getArchivePath())});
            } else {
                File alternativeJarFile = this.getAbsoluteOrProjectRelativeFile(project, ext.getAlternativePathToJarFile(), ext.isCheckForAbsolutePaths());
                if (alternativeJarFile.exists()) {
                    copySpec.from(new Object[]{project.zipTree((Object)alternativeJarFile)});
                } else {
                    project.getLogger().warn("Could not find specified alternative JAR-file");
                    copySpec.from(new Object[]{project.zipTree((Object)jarTask.getArchivePath())});
                }
            }
        });
        project.getLogger().info("Creating parameter-map for packager...");
        CreateJarParams createJarParams = new CreateJarParams();
        createJarParams.setOutdir(this.getAbsoluteOrProjectRelativeFile(project, ext.getJfxAppOutputDir(), ext.isCheckForAbsolutePaths()));
        if (!ext.getJfxMainAppJarName().toLowerCase().endsWith(".jar")) {
            throw new GradleException("Please provide a proper value for jfxMainAppJarName-property! It has to end with \".jar\".");
        }
        createJarParams.setOutfile(ext.getJfxMainAppJarName());
        createJarParams.setApplicationClass(ext.getMainClass());
        createJarParams.setCss2bin(ext.isCss2bin());
        createJarParams.setPreloader(ext.getPreLoader());
        Map<String, String> manifestAttributes = ext.getManifestAttributes();
        if (manifestAttributes == null) {
            manifestAttributes = new HashMap<String, String>();
        }
        createJarParams.setManifestAttrs(manifestAttributes);
        final File libDir = new File(this.getAbsoluteOrProjectRelativeFile(project, ext.getJfxAppOutputDir(), ext.isCheckForAbsolutePaths()), ext.getLibFolderName());
        if (!libDir.exists() && !libDir.mkdirs()) {
            throw new GradleException("Unable to create app lib dir: " + libDir);
        }
        if (ext.isUpdateExistingJar()) {
            createJarParams.addResource(null, jarTask.getArchivePath());
        } else {
            createJarParams.addResource(someTempDir.toFile(), "");
        }
        HashSet<String> foundLibs = new HashSet<String>();
        Configuration compileConfiguration = project.getConfigurations().getByName("compile");
        if (!ext.isSkipCopyingDependencies()) {
            this.copyModuleDependencies(compileConfiguration, "compile", project, libDir, foundLibs);
            this.copyFileDependencies(compileConfiguration, "compile", project, ext.isAddPackagerJar(), libDir, foundLibs);
        } else {
            project.getLogger().info("Skipped copying compile dependencies");
        }
        Configuration runtimeConfiguration = project.getConfigurations().getByName("runtime");
        if (!ext.isSkipCopyingDependencies()) {
            this.copyModuleDependencies(runtimeConfiguration, "runtime", project, libDir, foundLibs);
            this.copyFileDependencies(runtimeConfiguration, "runtime", project, ext.isAddPackagerJar(), libDir, foundLibs);
        } else {
            project.getLogger().info("Skipped copying runtime dependencies");
        }
        if (ext.isUseLibFolderContentForManifestClasspath()) {
            final StringBuilder scannedClasspath = new StringBuilder();
            try {
                Files.walkFileTree(libDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        scannedClasspath.append(ext.getLibFolderName().replace("\\", "/")).append("/").append(libDir.toPath().relativize(file).toString().replace("\\", "/")).append(" ");
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException ioex) {
                project.getLogger().warn("Got problem while scanning lib-folder", (Throwable)ioex);
            }
            createJarParams.setClasspath(scannedClasspath.toString());
        } else if (!foundLibs.isEmpty()) {
            createJarParams.setClasspath(ext.getLibFolderName() + "/" + String.join((CharSequence)(" " + ext.getLibFolderName() + "/"), foundLibs));
        }
        Optional.ofNullable(ext.getFixedManifestClasspath()).ifPresent(manifestClasspath -> {
            if (manifestClasspath.trim().isEmpty()) {
                return;
            }
            createJarParams.setClasspath(manifestClasspath);
            if (ext.isUseLibFolderContentForManifestClasspath()) {
                project.getLogger().warn("You specified to use the content of the lib-folder AND specified a fixed classpath. The fixed classpath will get taken.");
            }
        });
        if (ext.isAllPermissions()) {
            manifestAttributes.put("Permissions", "all-permissions");
        }
        PackagerLib packagerLib = new PackagerLib();
        try {
            project.getLogger().info("Running packager...");
            packagerLib.packageAsJar(createJarParams);
        }
        catch (PackagerException ex) {
            throw new GradleException("Unable to build JFX JAR for application", (Throwable)ex);
        }
        if (ext.isCopyAdditionalAppResourcesToJar()) {
            Optional.ofNullable(ext.getAdditionalAppResources()).filter(appRessourcesString -> appRessourcesString != null).map(appRessourcesString -> this.getAbsoluteOrProjectRelativeFile(project, (String)appRessourcesString, ext.isCheckForAbsolutePaths())).filter(File::exists).ifPresent(appResources -> {
                project.getLogger().info("Copying additional app ressources...");
                try {
                    Path targetFolder = this.getAbsoluteOrProjectRelativeFile(project, ext.getJfxAppOutputDir(), ext.isCheckForAbsolutePaths()).toPath();
                    Path sourceFolder = appResources.toPath();
                    this.copyRecursive(sourceFolder, targetFolder, project.getLogger());
                }
                catch (IOException e) {
                    project.getLogger().warn("Couldn't copy additional application resource-file(s).", (Throwable)e);
                }
            });
        }
        if (libDir.list().length == 0) {
            project.getLogger().info("Deleting unused lib-folder...");
            libDir.delete();
        }
        try {
            Files.walkFileTree(someTempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void copyModuleDependencies(Configuration configuration, String toPrint, Project project, File libDir, Set<String> foundLibs) {
        project.getLogger().info("Copying defined " + toPrint + "-dependencies...");
        configuration.getResolvedConfiguration().getFirstLevelModuleDependencies().forEach(resolvedDep -> resolvedDep.getAllModuleArtifacts().forEach(artifact -> {
            try {
                Path artifactPath = artifact.getFile().toPath();
                String artifactFileName = artifactPath.getFileName().toString();
                Files.copy(artifactPath, libDir.toPath().resolve(artifactFileName), StandardCopyOption.REPLACE_EXISTING);
                foundLibs.add(artifactFileName);
            }
            catch (IOException ex) {
                project.getLogger().warn("Couldn't copy dependency " + artifact.getId().getComponentIdentifier().toString(), (Throwable)ex);
            }
        }));
    }

    private void copyFileDependencies(Configuration configuration, String toPrint, Project project, boolean isPackagerJarToBeAdded, File libDir, Set<String> foundLibs) {
        project.getLogger().info("Copying defined " + toPrint + "-dependency-files...");
        configuration.getResolvedConfiguration().getFiles(Specs.SATISFIES_ALL).forEach(someFile -> {
            try {
                Path artifactPath = someFile.toPath();
                String artifactFileName = artifactPath.getFileName().toString();
                if ("packager.jar".equals(artifactFileName) && !isPackagerJarToBeAdded) {
                    project.getLogger().info("Skipped adding packager.jar.");
                    return;
                }
                if (!foundLibs.contains(artifactFileName)) {
                    Files.copy(artifactPath, libDir.toPath().resolve(artifactFileName), StandardCopyOption.REPLACE_EXISTING);
                    foundLibs.add(artifactFileName);
                }
            }
            catch (IOException ex) {
                project.getLogger().warn("Couldn't copy dependency " + someFile.getName(), (Throwable)ex);
            }
        });
    }
}

