/*
 * Decompiled with CFR 0.152.
 */
package de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers;

import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.UnsupportedPlatformException;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers.JfxAbstractWorker;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;

public class JfxListBundlersWorker
extends JfxAbstractWorker {
    public void jfxlistbundlers(Project project) {
        Logger logger = project.getLogger();
        Bundlers bundlers = Bundlers.createBundlersInstance();
        logger.info("Available bundlers:");
        logger.info("-------------------");
        HashMap dummyParams = new HashMap();
        bundlers.getBundlers().stream().forEach(bundler -> {
            try {
                bundler.validate(dummyParams);
            }
            catch (UnsupportedPlatformException ex) {
                return;
            }
            catch (ConfigException ex) {
                // empty catch block
            }
            logger.lifecycle("ID: " + bundler.getID());
            logger.lifecycle("Name: " + bundler.getName());
            logger.lifecycle("Description: " + bundler.getDescription());
            Collection bundleParameters = bundler.getBundleParameters();
            Optional.ofNullable(bundleParameters).ifPresent(nonNullBundleArguments -> {
                logger.info("Available bundle arguments: ");
                nonNullBundleArguments.stream().forEach(bundleArgument -> {
                    logger.info("\t\tArgument ID: " + bundleArgument.getID());
                    logger.info("\t\tArgument Type: " + bundleArgument.getValueType().getName());
                    logger.info("\t\tArgument Name: " + bundleArgument.getName());
                    logger.info("\t\tArgument Description: " + bundleArgument.getDescription());
                    logger.info("");
                });
            });
            logger.lifecycle("-------------------");
        });
        if (!logger.isEnabled(LogLevel.INFO)) {
            logger.lifecycle("For more information, please use --info parameter.");
        }
    }
}

