/*
 * Decompiled with CFR 0.152.
 */
package de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.linux.LinuxDebBundler;
import com.oracle.tools.packager.linux.LinuxRpmBundler;
import com.oracle.tools.packager.windows.WinExeBundler;
import com.oracle.tools.packager.windows.WinMsiBundler;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.SignJarParams;
import de.dynamicfiles.projects.gradle.plugins.javafx.JavaFXGradlePluginExtension;
import de.dynamicfiles.projects.gradle.plugins.javafx.dto.FileAssociation;
import de.dynamicfiles.projects.gradle.plugins.javafx.dto.NativeLauncher;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.internal.Workarounds;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers.JfxAbstractWorker;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.bundling.Jar;

public class JfxNativeWorker
extends JfxAbstractWorker {
    private static final String JNLP_JAR_PATTERN = "(.*)href=(\".*?\")(.*)size=(\".*?\")(.*)";
    private static final String CFG_WORKAROUND_MARKER = "cfgWorkaroundMarker";
    private static final String CFG_WORKAROUND_DONE_MARKER = "cfgWorkaroundMarker.done";
    private Workarounds workarounds = null;

    public void jfxnative(Project project) {
        boolean mainClassInsideResourceJarFile;
        JavaFXGradlePluginExtension ext = (JavaFXGradlePluginExtension)project.getExtensions().getByType(JavaFXGradlePluginExtension.class);
        this.addDeployDirToSystemClassloader(project, ext);
        String requestedBundler = ext.getBundler();
        Logger logger = project.getLogger();
        this.workarounds = new Workarounds(this.getAbsoluteOrProjectRelativeFile(project, ext.getNativeOutputDir(), ext.isCheckForAbsolutePaths()), logger);
        HashMap<String, Object> params = new HashMap<String, Object>();
        logger.info("Creating parameter-map for bundler '" + requestedBundler + "'");
        params.put(StandardBundlerParam.VERBOSE.getID(), ext.isVerbose());
        Optional.ofNullable(ext.getIdentifier()).ifPresent(id -> params.put(StandardBundlerParam.IDENTIFIER.getID(), id));
        String appName = ext.getAppName();
        if (appName == null) {
            Jar jarTask = (Jar)project.getTasks().findByName("jar");
            String archiveName = jarTask.getArchiveName();
            appName = archiveName.substring(0, archiveName.lastIndexOf("."));
        }
        params.put(StandardBundlerParam.APP_NAME.getID(), appName);
        params.put(StandardBundlerParam.VERSION.getID(), ext.getNativeReleaseVersion());
        if (!ext.isSkipNativeVersionNumberSanitizing() && ext.getNativeReleaseVersion() != null) {
            params.put(StandardBundlerParam.VERSION.getID(), ext.getNativeReleaseVersion().replaceAll("[^\\d.]", ""));
        }
        if (ext.getVendor() == null) {
            throw new GradleException("You have to set a vendor, which is required for bundlers.");
        }
        params.put(StandardBundlerParam.VENDOR.getID(), ext.getVendor());
        params.put(StandardBundlerParam.SHORTCUT_HINT.getID(), ext.isNeedShortcut());
        params.put(StandardBundlerParam.MENU_HINT.getID(), ext.isNeedMenu());
        params.put(StandardBundlerParam.MAIN_CLASS.getID(), ext.getMainClass());
        Optional.ofNullable(ext.getJvmProperties()).ifPresent(jvmProps -> params.put(StandardBundlerParam.JVM_PROPERTIES.getID(), new HashMap(jvmProps)));
        Optional.ofNullable(ext.getJvmArgs()).ifPresent(jvmOptions -> params.put(StandardBundlerParam.JVM_OPTIONS.getID(), new ArrayList(jvmOptions)));
        Optional.ofNullable(ext.getUserJvmArgs()).ifPresent(userJvmOptions -> params.put(StandardBundlerParam.USER_JVM_OPTIONS.getID(), new HashMap(userJvmOptions)));
        Optional.ofNullable(ext.getLauncherArguments()).ifPresent(arguments -> params.put(StandardBundlerParam.ARGUMENTS.getID(), new ArrayList(arguments)));
        Optional.ofNullable(ext.getAdditionalAppResources()).filter(appRessourcesString -> appRessourcesString != null).map(appRessourcesString -> this.getAbsoluteOrProjectRelativeFile(project, (String)appRessourcesString, ext.isCheckForAbsolutePaths())).filter(File::exists).ifPresent(appResources -> {
            logger.info("Copying additional app ressources...");
            try {
                Path targetFolder = this.getAbsoluteOrProjectRelativeFile(project, ext.getJfxAppOutputDir(), ext.isCheckForAbsolutePaths()).toPath();
                Path sourceFolder = appResources.toPath();
                this.copyRecursive(sourceFolder, targetFolder, project.getLogger());
            }
            catch (IOException e) {
                logger.warn("Couldn't copy additional application resource-file(s).", (Throwable)e);
            }
        });
        HashSet resourceFiles = new HashSet();
        try {
            Files.walk(this.getAbsoluteOrProjectRelativeFile(project, ext.getJfxAppOutputDir(), ext.isCheckForAbsolutePaths()).toPath(), new FileVisitOption[0]).map(p -> p.toFile()).filter(File::isFile).filter(File::canRead).forEach(f -> {
                logger.info(String.format("Add %s file to application resources.", f));
                resourceFiles.add(f);
            });
        }
        catch (IOException e) {
            logger.warn("There was a problem while processing application files.", (Throwable)e);
        }
        params.put(StandardBundlerParam.APP_RESOURCES.getID(), new RelativeFileSet(this.getAbsoluteOrProjectRelativeFile(project, ext.getJfxAppOutputDir(), ext.isCheckForAbsolutePaths()), resourceFiles));
        HashSet duplicateKeys = new HashSet();
        Optional.ofNullable(ext.getBundleArguments()).ifPresent(bArguments -> {
            duplicateKeys.addAll(params.keySet());
            duplicateKeys.retainAll(bArguments.keySet());
            params.putAll((Map<String, Object>)bArguments);
        });
        if (!duplicateKeys.isEmpty()) {
            throw new GradleException("The following keys in <bundleArguments> duplicate other settings, please remove one or the other: " + ((Object)duplicateKeys).toString());
        }
        if (!ext.isSkipMainClassScanning() && !(mainClassInsideResourceJarFile = resourceFiles.stream().filter(resourceFile -> resourceFile.toString().endsWith(".jar")).filter(resourceJarFile -> this.isClassInsideJarFile(ext.getMainClass(), (File)resourceJarFile)).findFirst().isPresent())) {
            logger.warn(String.format("Class with name %s was not found inside provided jar files!! JavaFX-application might not be working !!", ext.getMainClass()));
        }
        ArrayList<String> launcherNames = new ArrayList<String>();
        launcherNames.add(appName);
        AtomicBoolean nullLauncherNameFound = new AtomicBoolean(false);
        Optional.ofNullable(ext.getSecondaryLaunchers()).filter(list -> !list.isEmpty()).ifPresent(launchersMap -> {
            logger.info("Adding configuration for secondary native launcher");
            nullLauncherNameFound.set(launchersMap.stream().map(launcherMap -> this.getNativeLauncher((Map<String, Object>)launcherMap)).anyMatch(launcher -> launcher.getAppName() == null));
            if (!nullLauncherNameFound.get()) {
                launcherNames.addAll(launchersMap.stream().map(launcherMap -> this.getNativeLauncher((Map<String, Object>)launcherMap)).map(launcher -> launcher.getAppName()).collect(Collectors.toList()));
                params.put(StandardBundlerParam.SECONDARY_LAUNCHERS.getID(), launchersMap.stream().map(launcherMap -> this.getNativeLauncher((Map<String, Object>)launcherMap)).map(launcher -> {
                    logger.info("Adding secondary launcher: " + launcher.getAppName());
                    HashMap<String, Object> secondaryLauncherGenerationMap = new HashMap<String, Object>();
                    this.addToMapWhenNotNull(launcher.getAppName(), StandardBundlerParam.APP_NAME.getID(), secondaryLauncherGenerationMap);
                    this.addToMapWhenNotNull(launcher.getMainClass(), StandardBundlerParam.MAIN_CLASS.getID(), secondaryLauncherGenerationMap);
                    this.addToMapWhenNotNull(launcher.getJfxMainAppJarName(), StandardBundlerParam.MAIN_JAR.getID(), secondaryLauncherGenerationMap);
                    this.addToMapWhenNotNull(launcher.getNativeReleaseVersion(), StandardBundlerParam.VERSION.getID(), secondaryLauncherGenerationMap);
                    this.addToMapWhenNotNull(launcher.getVendor(), StandardBundlerParam.VENDOR.getID(), secondaryLauncherGenerationMap);
                    this.addToMapWhenNotNull(launcher.getIdentifier(), StandardBundlerParam.IDENTIFIER.getID(), secondaryLauncherGenerationMap);
                    this.addToMapWhenNotNull(launcher.isNeedMenu(), StandardBundlerParam.MENU_HINT.getID(), secondaryLauncherGenerationMap);
                    this.addToMapWhenNotNull(launcher.isNeedShortcut(), StandardBundlerParam.SHORTCUT_HINT.getID(), secondaryLauncherGenerationMap);
                    this.addToMapWhenNotNull(launcher.getClasspath(), StandardBundlerParam.CLASSPATH.getID(), secondaryLauncherGenerationMap);
                    Optional.ofNullable(launcher.getJvmArgs()).ifPresent(jvmOptions -> secondaryLauncherGenerationMap.put(StandardBundlerParam.JVM_OPTIONS.getID(), new ArrayList(jvmOptions)));
                    Optional.ofNullable(launcher.getJvmProperties()).ifPresent(jvmProps -> secondaryLauncherGenerationMap.put(StandardBundlerParam.JVM_PROPERTIES.getID(), new HashMap(jvmProps)));
                    Optional.ofNullable(launcher.getUserJvmArgs()).ifPresent(userJvmOptions -> secondaryLauncherGenerationMap.put(StandardBundlerParam.USER_JVM_OPTIONS.getID(), new HashMap(userJvmOptions)));
                    Optional.ofNullable(launcher.getLauncherArguments()).ifPresent(arguments -> secondaryLauncherGenerationMap.put(StandardBundlerParam.ARGUMENTS.getID(), new ArrayList(arguments)));
                    return secondaryLauncherGenerationMap;
                }).collect(Collectors.toList()));
            }
        });
        if (nullLauncherNameFound.get()) {
            throw new GradleException("Not all secondary launchers have been configured properly.");
        }
        HashSet duplicateLauncherNamesCheckSet = new HashSet();
        launcherNames.stream().forEach(launcherName -> duplicateLauncherNamesCheckSet.add(launcherName));
        if (duplicateLauncherNamesCheckSet.size() != launcherNames.size()) {
            throw new GradleException("Secondary launcher needs to have different name, please adjust appName inside your configuration.");
        }
        Optional.ofNullable(ext.getFileAssociations()).ifPresent(associations -> {
            ArrayList allAssociations = new ArrayList();
            associations.stream().map(associationMap -> this.getFileAssociation((Map<String, Object>)associationMap)).forEach(association -> {
                HashMap<String, Object> settings = new HashMap<String, Object>();
                settings.put(StandardBundlerParam.FA_DESCRIPTION.getID(), association.getDescription());
                settings.put(StandardBundlerParam.FA_ICON.getID(), association.getIcon());
                settings.put(StandardBundlerParam.FA_EXTENSIONS.getID(), association.getExtensions());
                settings.put(StandardBundlerParam.FA_CONTENT_TYPE.getID(), association.getContentType());
                allAssociations.add(settings);
            });
            params.put(StandardBundlerParam.FILE_ASSOCIATIONS.getID(), allAssociations);
        });
        if (this.workarounds.isWorkaroundForBug167Needed()) {
            if (!ext.isSkipNativeLauncherWorkaround167()) {
                this.workarounds.applyWorkaround167(params);
            } else {
                project.getLogger().info("Skipped workaround for native launcher regarding cfg-file-format.");
            }
        }
        Bundlers bundlers = Bundlers.createBundlersInstance();
        Collection loadedBundlers = bundlers.getBundlers();
        if (ext.isOnlyCustomBundlers()) {
            loadedBundlers.clear();
        }
        List existingBundlerIds = loadedBundlers.stream().map(existingBundler -> existingBundler.getID()).collect(Collectors.toList());
        Optional.ofNullable(ext.getCustomBundlers()).ifPresent(customBundlerList -> customBundlerList.stream().map(customBundlerClassName -> {
            try {
                Class<?> customBundlerClass = Class.forName(customBundlerClassName);
                Bundler newCustomBundler = (Bundler)customBundlerClass.newInstance();
                if (existingBundlerIds.contains(newCustomBundler.getID())) {
                    return null;
                }
                return newCustomBundler;
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                logger.warn("There was an exception while creating a new instance of custom bundler: " + customBundlerClassName, (Throwable)ex);
                return null;
            }
        }).filter(customBundler -> customBundler != null).forEach(customBundler -> {
            if (ext.isOnlyCustomBundlers()) {
                loadedBundlers.add(customBundler);
            } else {
                bundlers.loadBundler(customBundler);
            }
        }));
        boolean foundBundler = false;
        if (loadedBundlers.isEmpty()) {
            throw new GradleException("There were no bundlers registered. Please make sure to add your custom bundlers as dependency to the bundlescript.");
        }
        for (Bundler b : loadedBundlers) {
            String currentRunningBundlerID = b.getID();
            if (!this.shouldBundlerRun(requestedBundler, currentRunningBundlerID, ext, logger, params)) continue;
            foundBundler = true;
            try {
                HashMap<String, Object> paramsToBundleWith;
                if (ext.getAdditionalBundlerResources() != null && this.workarounds.isWorkaroundForNativeMacBundlerNeeded(this.getAbsoluteOrProjectRelativeFile(project, ext.getAdditionalBundlerResources(), ext.isCheckForAbsolutePaths()))) {
                    if (!ext.isSkipMacBundlerWorkaround()) {
                        b = this.workarounds.applyWorkaroundForNativeMacBundler(b, currentRunningBundlerID, params, this.getAbsoluteOrProjectRelativeFile(project, ext.getAdditionalBundlerResources(), ext.isCheckForAbsolutePaths()));
                    } else {
                        logger.info("Skipping replacement of the 'mac.app'-bundler. Please make sure you know what you are doing!");
                    }
                }
                if (!b.validate(paramsToBundleWith = new HashMap<String, Object>(params))) continue;
                this.doPrepareBeforeBundling(ext, project, currentRunningBundlerID, logger, paramsToBundleWith);
                if ("jnlp".equals(currentRunningBundlerID) && !paramsToBundleWith.containsKey("jnlp.outfile")) {
                    if (ext.isFailOnError()) {
                        throw new GradleException("You missed to specify some bundleArguments-entry, please set 'jnlp.outfile', e.g. using appName.");
                    }
                    logger.warn("You missed to specify some bundleArguments-entry, please set 'jnlp.outfile', e.g. using appName.");
                    continue;
                }
                b.execute(paramsToBundleWith, this.getAbsoluteOrProjectRelativeFile(project, ext.getNativeOutputDir(), ext.isCheckForAbsolutePaths()));
                this.applyWorkaroundsAfterBundling(currentRunningBundlerID, logger, ext, appName, params, project);
            }
            catch (UnsupportedPlatformException paramsToBundleWith) {
            }
            catch (ConfigException e) {
                if (ext.isFailOnError()) {
                    throw new GradleException("Skipping '" + b.getName() + "' because of configuration error '" + e.getMessage() + "'\nAdvice to fix: " + e.getAdvice());
                }
                logger.info("Skipping '" + b.getName() + "' because of configuration error '" + e.getMessage() + "'\nAdvice to fix: " + e.getAdvice());
            }
            catch (GradleException ex) {
                throw new GradleException("Got exception while executing bundler.", (Throwable)ex);
            }
        }
        if (!foundBundler) {
            throw new GradleException("No bundler found for given name " + requestedBundler + ". Please check your configuration.");
        }
    }

    private void applyWorkaroundsAfterBundling(String currentRunningBundlerID, Logger logger, JavaFXGradlePluginExtension ext, String appName, Map<String, ? super Object> params, Project project) {
        if (this.workarounds.isWorkaroundForBug124Needed() && "linux.app".equals(currentRunningBundlerID)) {
            logger.info("Applying workaround for oracle-jdk-bug since 1.8.0u40 regarding native linux launcher(s).");
            if (!ext.isSkipNativeLauncherWorkaround124()) {
                ArrayList<NativeLauncher> nativeLaunchers = new ArrayList<NativeLauncher>();
                Optional.ofNullable(ext.getSecondaryLaunchers()).ifPresent(launchers -> nativeLaunchers.addAll(launchers.stream().map(launcherMap -> this.getNativeLauncher((Map<String, Object>)launcherMap)).collect(Collectors.toList())));
                this.workarounds.applyWorkaround124(appName, nativeLaunchers);
                if (Boolean.parseBoolean(String.valueOf(params.get(CFG_WORKAROUND_MARKER))) && !Boolean.parseBoolean((String)params.get(CFG_WORKAROUND_DONE_MARKER))) {
                    logger.info("Preparing workaround for oracle-jdk-bug since 1.8.0u40 regarding native linux launcher(s) inside native linux installers.");
                    this.workarounds.applyWorkaround205(appName, nativeLaunchers, params);
                    params.put(CFG_WORKAROUND_DONE_MARKER, "true");
                }
            } else {
                logger.info("Skipped workaround for native linux launcher(s).");
            }
        }
        if ("jnlp".equals(currentRunningBundlerID)) {
            if (this.workarounds.isWorkaroundForBug182Needed()) {
                logger.info("Applying workaround for oracle-jdk-bug since 1.8.0u60 regarding jar-path inside generated JNLP-files.");
                if (!ext.isSkipJNLPRessourcePathWorkaround182()) {
                    this.workarounds.fixPathsInsideJNLPFiles();
                } else {
                    logger.info("Skipped workaround for jar-paths jar-path inside generated JNLP-files.");
                }
            }
            if (this.workarounds.isWorkaroundForBug185Needed(params)) {
                logger.info("Signing jar-files referenced inside generated JNLP-files.");
                if (!ext.isSkipSigningJarFilesJNLP185()) {
                    if (!ext.isNoBlobSigning()) {
                        logger.info("Signing jar-files using BLOB method.");
                        this.signJarFilesUsingBlobSigning(project, ext);
                    } else {
                        logger.info("Signing jar-files using jarsigner.");
                        this.signJarFiles(project, ext);
                    }
                    this.workarounds.applyWorkaround185(ext.isSkipSizeRecalculationForJNLP185());
                } else {
                    logger.info("Skipped signing jar-files referenced inside JNLP-files.");
                }
            }
        }
    }

    private void doPrepareBeforeBundling(JavaFXGradlePluginExtension ext, Project project, String currentRunningBundlerID, Logger logger, Map<String, ? super Object> paramsToBundleWith) {
        if (ext.getAdditionalBundlerResources() != null) {
            boolean skipCopyAdditionalBundlerResources = false;
            Path additionalBundlerResources = this.getAbsoluteOrProjectRelativeFile(project, ext.getAdditionalBundlerResources(), ext.isCheckForAbsolutePaths()).toPath();
            Path resolvedBundlerFolder = additionalBundlerResources.resolve(currentRunningBundlerID);
            logger.info("Found additional bundler resources, trying to copy all files into build root, using:" + additionalBundlerResources.toFile().getAbsolutePath());
            File bundlerImageRoot = (File)AbstractBundler.IMAGES_ROOT.fetchFrom(paramsToBundleWith);
            Path targetFolder = bundlerImageRoot.toPath();
            Path sourceFolder = additionalBundlerResources;
            if (Files.exists(resolvedBundlerFolder, new LinkOption[0])) {
                logger.info("Found additional bundler resources for bundler " + currentRunningBundlerID);
                sourceFolder = resolvedBundlerFolder;
                switch (currentRunningBundlerID) {
                    case "windows.app": {
                        skipCopyAdditionalBundlerResources = true;
                        break;
                    }
                    case "exe": {
                        File exeBundlerFolder = (File)WinExeBundler.EXE_IMAGE_DIR.fetchFrom(paramsToBundleWith);
                        targetFolder = exeBundlerFolder.toPath();
                        break;
                    }
                    case "msi": {
                        File msiBundlerFolder = (File)WinMsiBundler.MSI_IMAGE_DIR.fetchFrom(paramsToBundleWith);
                        targetFolder = msiBundlerFolder.toPath();
                        break;
                    }
                    case "windows.service": {
                        skipCopyAdditionalBundlerResources = true;
                        break;
                    }
                    case "mac.app": {
                        if (ext.isSkipMacBundlerWorkaround()) {
                            logger.warn("The bundler with ID 'mac.app' is not supported, as that bundler does not provide any way to copy additional bundler-files.");
                        }
                        skipCopyAdditionalBundlerResources = true;
                        break;
                    }
                    case "mac.appStore": {
                        if (ext.isSkipMacBundlerWorkaround()) {
                            logger.warn("The bundler with ID 'mac.appStore' is not supported for using 'additionalBundlerResources', as that bundler does not provide any way to copy additional bundler-files.");
                        }
                        skipCopyAdditionalBundlerResources = true;
                        break;
                    }
                    case "mac.daemon": {
                        logger.warn("The bundler with ID 'mac.daemon' is not supported, as that bundler does not provide any way to copy additional bundler-files.");
                        skipCopyAdditionalBundlerResources = true;
                        break;
                    }
                    case "dmg": {
                        if (ext.isSkipMacBundlerWorkaround()) {
                            logger.warn("The bundler with ID 'dmg' is not supported for using 'additionalBundlerResources', as that bundler does not provide any way to copy additional bundler-files.");
                        }
                        skipCopyAdditionalBundlerResources = true;
                        break;
                    }
                    case "pkg": {
                        if (ext.isSkipMacBundlerWorkaround()) {
                            logger.warn("The bundler with ID 'pkg' is not supported for using 'additionalBundlerResources', as that bundler does not provide any way to copy additional bundler-files.");
                        }
                        skipCopyAdditionalBundlerResources = true;
                        break;
                    }
                    case "linux.app": {
                        skipCopyAdditionalBundlerResources = true;
                        break;
                    }
                    case "deb": {
                        File linuxDebBundlerFolder = (File)LinuxDebBundler.DEB_IMAGE_DIR.fetchFrom(paramsToBundleWith);
                        targetFolder = linuxDebBundlerFolder.toPath();
                        break;
                    }
                    case "rpm": {
                        File linuxRpmBundlerFolder = (File)LinuxRpmBundler.RPM_IMAGE_DIR.fetchFrom(paramsToBundleWith);
                        targetFolder = linuxRpmBundlerFolder.toPath();
                        break;
                    }
                    default: {
                        logger.warn("Unknown bundler-ID found, copying from root of additionalBundlerResources into IMAGES_ROOT.");
                        sourceFolder = additionalBundlerResources;
                        break;
                    }
                }
            } else {
                logger.info("No additional bundler resources for bundler " + currentRunningBundlerID + " was found, copying all files instead.");
            }
            if (!skipCopyAdditionalBundlerResources) {
                try {
                    logger.info("Copying additional bundler resources into: " + targetFolder.toFile().getAbsolutePath());
                    this.copyRecursive(sourceFolder, targetFolder, project.getLogger());
                }
                catch (IOException e) {
                    logger.warn("Couldn't copy additional bundler resource-file(s).", (Throwable)e);
                }
            } else {
                logger.info("Skipped copying additional bundler resources, mostly because this bundler does not need them. You might want to use additionalAppResources. To make sure, check for any warnings printed above this message.");
            }
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("linux") && "deb".equals(currentRunningBundlerID)) {
            File generationTarget = this.getAbsoluteOrProjectRelativeFile(project, ext.getNativeOutputDir(), ext.isCheckForAbsolutePaths());
            AtomicBoolean needsWarningAboutSlowPerformance = new AtomicBoolean(false);
            generationTarget.toPath().getFileSystem().getFileStores().forEach(store -> {
                if ("ext4".equals(store.type())) {
                    needsWarningAboutSlowPerformance.set(true);
                }
                if ("btrfs".equals(store.type())) {
                    needsWarningAboutSlowPerformance.set(true);
                }
            });
            if (needsWarningAboutSlowPerformance.get()) {
                logger.lifecycle("This bundler might take some while longer than expected.");
                logger.lifecycle("For details about this, please go to: https://wiki.debian.org/Teams/Dpkg/FAQ#Q:_Why_is_dpkg_so_slow_when_using_new_filesystems_such_as_btrfs_or_ext4.3F");
            }
        }
    }

    private boolean shouldBundlerRun(String requestedBundler, String currentRunningBundlerID, JavaFXGradlePluginExtension ext, Logger logger, Map<String, ? super Object> params) {
        if (requestedBundler != null && !"ALL".equalsIgnoreCase(requestedBundler) && !requestedBundler.equalsIgnoreCase(currentRunningBundlerID)) {
            return false;
        }
        if (ext.isSkipJNLP() && "jnlp".equalsIgnoreCase(currentRunningBundlerID)) {
            logger.info("Skipped JNLP-bundling as requested.");
            return false;
        }
        boolean runBundler = true;
        if (System.getProperty("os.name").toLowerCase().startsWith("linux") && this.workarounds.isWorkaroundForBug205Needed() && !"jnlp".equalsIgnoreCase(requestedBundler) && !"linux.app".equalsIgnoreCase(requestedBundler) && "linux.app".equalsIgnoreCase(currentRunningBundlerID)) {
            if (!ext.isSkipNativeLauncherWorkaround205()) {
                logger.info("Detected linux application bundler ('linux.app') needs to run before installer bundlers are executed.");
                runBundler = true;
                params.put(CFG_WORKAROUND_MARKER, "true");
            } else {
                logger.info("Skipped workaround for native linux installer bundlers.");
            }
        }
        return runBundler;
    }

    private void addToMapWhenNotNull(Object value, String key, Map<String, Object> map) {
        if (value == null) {
            return;
        }
        map.put(key, value);
    }

    private List<File> getGeneratedJNLPFiles(Project project, JavaFXGradlePluginExtension ext) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        try (Stream<Path> walkstream = Files.walk(this.getAbsoluteOrProjectRelativeFile(project, ext.getNativeOutputDir(), ext.isCheckForAbsolutePaths()).toPath(), new FileVisitOption[0]);){
            walkstream.forEach(fileEntry -> {
                File possibleJNLPFile = fileEntry.toFile();
                String fileName = possibleJNLPFile.getName();
                if (fileName.endsWith(".jnlp")) {
                    generatedFiles.add(possibleJNLPFile);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return generatedFiles;
    }

    private List<String> getJARFilesFromJNLPFiles(Project project, JavaFXGradlePluginExtension ext) {
        ArrayList<String> jarFiles = new ArrayList<String>();
        this.getGeneratedJNLPFiles(project, ext).stream().map(jnlpFile -> jnlpFile.toPath()).forEach(jnlpPath -> {
            try {
                List<String> allLines = Files.readAllLines(jnlpPath);
                allLines.stream().filter(line -> line.trim().startsWith("<jar href=")).forEach(line -> {
                    String jarFile = line.replaceAll(JNLP_JAR_PATTERN, "$2");
                    jarFiles.add(jarFile.substring(1, jarFile.length() - 1));
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return jarFiles;
    }

    private FileAssociation getFileAssociation(Map<String, Object> rawMap) {
        FileAssociation fileAssociation = new FileAssociation();
        fileAssociation.setDescription((String)rawMap.get("description"));
        fileAssociation.setExtensions((String)rawMap.get("extensions"));
        fileAssociation.setContentType((String)rawMap.get("contentType"));
        if (rawMap.get("icon") != null) {
            if (rawMap.get("icon") instanceof File) {
                fileAssociation.setIcon((File)rawMap.get("icon"));
            } else if (rawMap.get("icon") instanceof Path) {
                fileAssociation.setIcon(((Path)rawMap.get("icon")).toAbsolutePath().toFile());
            } else {
                fileAssociation.setIcon(new File((String)rawMap.get("icon")));
            }
        }
        return fileAssociation;
    }

    private NativeLauncher getNativeLauncher(Map<String, Object> rawMap) {
        NativeLauncher launcher = new NativeLauncher();
        launcher.setAppName((String)rawMap.get("appName"));
        launcher.setMainClass((String)rawMap.get("mainClass"));
        if (rawMap.get("jfxMainAppJarName") != null) {
            launcher.setJfxMainAppJarName(new File((String)rawMap.get("jfxMainAppJarName")));
        }
        launcher.setJvmProperties((Map)rawMap.get("jvmProperties"));
        launcher.setJvmArgs((List)rawMap.get("jvmArgs"));
        launcher.setUserJvmArgs((Map)rawMap.get("userJvmArgs"));
        launcher.setNativeReleaseVersion((String)rawMap.get("nativeReleaseVersion"));
        launcher.setNeedShortcut(Boolean.valueOf(String.valueOf(rawMap.get("needShortcut"))));
        launcher.setNeedMenu(Boolean.valueOf(String.valueOf(rawMap.get("needMenu"))));
        launcher.setVendor((String)rawMap.get("vendor"));
        launcher.setIdentifier((String)rawMap.get("identifier"));
        launcher.setClasspath((String)rawMap.get("classpath"));
        launcher.setLauncherArguments((List)rawMap.get("launcherArguments"));
        return launcher;
    }

    private void signJarFilesUsingBlobSigning(Project project, JavaFXGradlePluginExtension ext) {
        this.checkSigningConfiguration(project, ext);
        File keyStore = this.getAbsoluteOrProjectRelativeFile(project, ext.getKeyStore(), ext.isCheckForAbsolutePaths());
        SignJarParams signJarParams = new SignJarParams();
        signJarParams.setVerbose(ext.isVerbose());
        signJarParams.setKeyStore(keyStore);
        signJarParams.setAlias(ext.getKeyStoreAlias());
        signJarParams.setStorePass(ext.getKeyStorePassword());
        signJarParams.setKeyPass(ext.getKeyPassword());
        signJarParams.setStoreType(ext.getKeyStoreType());
        File nativeOutputDir = this.getAbsoluteOrProjectRelativeFile(project, ext.getNativeOutputDir(), ext.isCheckForAbsolutePaths());
        signJarParams.addResource(nativeOutputDir, ext.getJfxMainAppJarName());
        this.getJARFilesFromJNLPFiles(project, ext).forEach(jarFile -> signJarParams.addResource(nativeOutputDir, jarFile));
        project.getLogger().info("Signing JAR files for webstart bundle");
        try {
            new PackagerLib().signJar(signJarParams);
        }
        catch (PackagerException ex) {
            throw new GradleException("There was a problem while signing JAR files.", (Throwable)ex);
        }
    }

    private void signJarFiles(Project project, JavaFXGradlePluginExtension ext) {
        this.checkSigningConfiguration(project, ext);
        File nativeOutputDir = this.getAbsoluteOrProjectRelativeFile(project, ext.getNativeOutputDir(), ext.isCheckForAbsolutePaths());
        AtomicReference exception = new AtomicReference();
        this.getJARFilesFromJNLPFiles(project, ext).stream().map(relativeJarFilePath -> new File(nativeOutputDir, (String)relativeJarFilePath)).forEach(jarFile -> {
            try {
                if (exception.get() == null) {
                    this.signJar(project, ext, jarFile.getAbsoluteFile());
                }
            }
            catch (GradleException ex) {
                exception.set(ex);
            }
        });
        if (exception.get() != null) {
            throw (GradleException)((Object)exception.get());
        }
    }

    private void checkSigningConfiguration(Project project, JavaFXGradlePluginExtension ext) {
        File keyStore = this.getAbsoluteOrProjectRelativeFile(project, ext.getKeyStore(), ext.isCheckForAbsolutePaths());
        if (!keyStore.exists()) {
            project.getLogger().lifecycle("Keystore does not exist (expected at: " + keyStore + ")");
            throw new GradleException("Keystore does not exist (expected at: " + keyStore + ")");
        }
        if (ext.getKeyStoreAlias() == null || ext.getKeyStoreAlias().isEmpty()) {
            project.getLogger().lifecycle("A 'keyStoreAlias' is required for signing JARs");
            throw new GradleException("A 'keyStoreAlias' is required for signing JARs");
        }
        if (ext.getKeyStorePassword() == null || ext.getKeyStorePassword().isEmpty()) {
            project.getLogger().lifecycle("A 'keyStorePassword' is required for signing JARs");
            throw new GradleException("A 'keyStorePassword' is required for signing JARs");
        }
        String keyPassword = ext.getKeyPassword();
        if (keyPassword == null) {
            ext.setKeyPassword(ext.getKeyStorePassword());
        }
    }

    private void signJar(Project project, JavaFXGradlePluginExtension ext, File jarFile) {
        File keyStore = this.getAbsoluteOrProjectRelativeFile(project, ext.getKeyStore(), ext.isCheckForAbsolutePaths());
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getEnvironmentRelativeExecutablePath(ext.isUseEnvironmentRelativeExecutables()) + "jarsigner");
        command.add("-strict");
        command.add("-keystore");
        command.add(keyStore.getAbsolutePath());
        command.add("-storepass");
        command.add(ext.getKeyStorePassword());
        command.add("-keypass");
        command.add(ext.getKeyPassword());
        command.add(jarFile.getAbsolutePath());
        command.add(ext.getKeyStoreAlias());
        Optional.ofNullable(ext.getAdditionalJarsignerParameters()).ifPresent(jarsignerParameters -> command.addAll((Collection<String>)jarsignerParameters));
        if (ext.isVerbose()) {
            command.add("-verbose");
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            if (!this.isGradleDaemonMode()) {
                pb.inheritIO();
            }
            if (ext.isVerbose()) {
                project.getLogger().lifecycle("Running command: " + String.join((CharSequence)" ", command));
            }
            pb.directory(project.getProjectDir()).command(command);
            Process p = pb.start();
            if (this.isGradleDaemonMode()) {
                this.redirectIO(p, project.getLogger());
            }
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new GradleException("Signing jar using jarsigner wasn't successful! Please check build-log.");
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new GradleException("There was an exception while signing jar-file: " + jarFile.getAbsolutePath(), (Throwable)ex);
        }
    }

    private boolean isClassInsideJarFile(String classname, File jarFile) {
        String requestedJarEntryName = classname.replace(".", "/") + ".class";
        try {
            JarFile jarFileToSearchIn = new JarFile(jarFile, false, 1);
            return ((Stream)jarFileToSearchIn.stream().parallel()).filter(jarEntry -> jarEntry.getName().equals(requestedJarEntryName)).findAny().isPresent();
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

